/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.action;

import bitel.billing.server.admin.action.base.ActionBase;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.common.Utils;

public class ActionFilterHouse
extends ActionBase {
    @Override
    public void doAction() throws Exception {
        Element list = this.createElement(this.rootNode, "list");
        int city = this.getIntParameter("city", 0);
        int quarter = this.getIntParameter("quarter", 0);
        int street = this.getIntParameter("street", 0);
        String houseFrac = this.getParameter("house_frac", "").toLowerCase();
        StringBuffer query = new StringBuffer().append("SELECT t1.*, t2.title FROM address_house AS t1 ").append("LEFT JOIN address_street AS t2 ON t2.id=t1.street_id ").append("WHERE t1.street_id=t2.id ");
        if (city > 0) {
            query.append(" AND t2.cityid=").append(city);
        }
        if (quarter > 0) {
            query.append(" AND t1.quarterid=").append(quarter);
        }
        if (street > 0) {
            query.append(" AND t1.street_id=").append(street);
        }
        query.append(" ORDER BY t1.street_id, t1.house");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());
             ResultSet rs = ps.executeQuery();){
            Object house = null;
            String frac = null;
            String streetTitle = null;
            while (rs.next()) {
                house = rs.getString("t1.house");
                frac = rs.getString("t1.frac");
                streetTitle = rs.getString("t2.title");
                if (Utils.notEmptyString((String)frac)) {
                    if (Character.isDigit(frac.charAt(0))) {
                        house = (String)house + "/";
                    }
                    house = (String)house + frac;
                }
                if (!houseFrac.isEmpty() && ((String)house).toLowerCase().indexOf(houseFrac) <= -1) continue;
                this.addListItem((Node)list, rs.getString("id"), streetTitle + ", " + (String)house).setAttribute("house", (String)house);
            }
        }
    }
}

