/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.customer.common.bean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.json.JSONArray;
import org.json.JSONObject;

public class CustomerBankInfo {
    private String bik;
    private String name;
    private String accountR;
    private String accountC;
    private String uuid;

    public String getBik() {
        return this.bik;
    }

    public String getName() {
        return this.name;
    }

    public String getAccountR() {
        return this.accountR;
    }

    public String getAccountC() {
        return this.accountC;
    }

    public String getUuid() {
        return this.uuid;
    }

    public CustomerBankInfo setBik(String bik) {
        this.bik = bik;
        return this;
    }

    public CustomerBankInfo setName(String name) {
        this.name = name;
        return this;
    }

    public CustomerBankInfo setAccountR(String accountR) {
        this.accountR = accountR;
        return this;
    }

    public CustomerBankInfo setAccountC(String accountC) {
        this.accountC = accountC;
        return this;
    }

    public CustomerBankInfo setUuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public static CustomerBankInfo fromJson(JSONObject json) {
        Objects.requireNonNull(json);
        return new CustomerBankInfo().setBik(json.optString("bik")).setName(json.optString("name")).setAccountC(json.optString("accountC")).setAccountR(json.optString("accountR")).setUuid(json.optString("uuid"));
    }

    public static List<CustomerBankInfo> forCustomer(JSONObject customerInfo) {
        if (customerInfo == null) {
            return Collections.emptyList();
        }
        JSONObject customer = customerInfo.has("customer") ? customerInfo.optJSONObject("customer") : customerInfo;
        JSONArray jsonBanks = Optional.ofNullable(customer.optJSONArray("banks")).orElse(new JSONArray());
        ArrayList<CustomerBankInfo> bankInfos = new ArrayList<CustomerBankInfo>();
        for (int index = 0; index < jsonBanks.length(); ++index) {
            bankInfos.add(CustomerBankInfo.fromJson((JSONObject)jsonBanks.get(index)));
        }
        return bankInfos;
    }
}

