/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client.tree;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import ru.bitel.common.client.tree.BGCheckTreeModel;
import ru.bitel.common.client.tree.BGTreeModel;
import ru.bitel.common.client.tree.CheckTreeCellRenderer;
import ru.bitel.common.model.Id;

public class BGUCheckTree<N extends Id>
extends JTree {
    public BGUCheckTree(BGCheckTreeModel<N> model) {
        model.tree = this;
        this.setCellRenderer(new CheckTreeCellRenderer<N>(model));
        this.setModel(model);
        NodeSelectionListener listener = new NodeSelectionListener();
        this.addKeyListener(listener);
        this.addMouseListener(listener);
    }

    public BGUCheckTree(Class<N> clazz) {
        this(new BGCheckTreeModel<N>(clazz.getName(), clazz));
    }

    public BGUCheckTree(Class<N> clazz, boolean dependChildren) {
        this(new BGCheckTreeModel<N>(clazz.getName(), clazz, dependChildren));
    }

    public Set<Integer> getChecked() {
        return ((BGCheckTreeModel)this.getModel()).getChecked();
    }

    public List<N> getSelectedItems() {
        return ((BGCheckTreeModel)this.getModel()).getSelectedItems();
    }

    public void setChecked(int id, boolean checked) {
        ((BGCheckTreeModel)this.getModel()).setChecked(id, checked);
    }

    public void setChecked(N n, boolean checked) {
        ((BGCheckTreeModel)this.getModel()).setChecked(n, checked);
    }

    public void setChecked(Set<Integer> set) {
        ((BGCheckTreeModel)this.getModel()).setChecked(set);
    }

    public boolean isChecked(N n) {
        return ((BGCheckTreeModel)this.getModel()).isChecked(n);
    }

    public void setData(N root) {
        ((BGTreeModel)this.getModel()).setData(root);
    }

    public void setData(N root, Set<Integer> selected) {
        ((BGCheckTreeModel)this.getModel()).setData(root, selected);
    }

    public void clearChecked() {
        ((BGCheckTreeModel)this.getModel()).clearChecked();
    }

    public void expand() {
        TreeModel model = this.getModel();
        this.expand(model.getRoot(), new Object[20], 0);
    }

    private void expand(Object parent, Object[] path, int level) {
        TreeModel model = this.getModel();
        path[level] = parent;
        boolean expanded = false;
        int size = model.getChildCount(parent);
        for (int i = 0; i < size; ++i) {
            Object child = model.getChild(parent, i);
            if (model.isLeaf(child)) {
                if (expanded) continue;
                expanded = true;
                this.expandPath(new TreePath(path, level + 1){});
                continue;
            }
            this.expand(child, path, level + 1);
        }
    }

    private final class NodeSelectionListener
    extends MouseAdapter
    implements KeyListener {
        private NodeSelectionListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int y;
            int x = e.getX();
            int row = BGUCheckTree.this.getRowForLocation(x, y = e.getY());
            TreePath path = BGUCheckTree.this.getPathForRow(row);
            if (path != null && SwingUtilities.isLeftMouseButton(e)) {
                Id n;
                BGUCheckTree.this.setChecked(n, !BGUCheckTree.this.isChecked(n = (Id)path.getLastPathComponent()));
            }
        }

        @Override
        public final void keyReleased(KeyEvent keyevent) {
            int i = keyevent.getKeyCode();
            if (i == 32 || i == 10) {
                Id n;
                BGUCheckTree.this.setChecked(n, !BGUCheckTree.this.isChecked(n = (Id)BGUCheckTree.this.getLastSelectedPathComponent()));
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

