/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.status.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.field.BGTextArea;
import ru.bitel.bgbilling.client.common.table.renderer.ColorTableCellRender;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.kernel.contract.status.client.StatusChartPanel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;

public class StatusChartInfoPanel
extends BGUPanel {
    private Map<Integer, Color> statusColorMap;
    private BGTextArea comment = new BGTextArea();
    private JTextField status = new JTextField();
    private JTextField period = new JTextField();
    private StatusColorTableModel colorTableModel = new StatusColorTableModel();

    @Override
    protected void jbInit() throws Exception {
        Color bgColor = this.status.getBackground();
        this.status.setHorizontalAlignment(0);
        this.status.setEditable(false);
        this.status.setBackground(bgColor);
        this.status.repaint();
        this.period.setHorizontalAlignment(0);
        this.period.setEditable(false);
        this.period.setBackground(bgColor);
        this.comment.setEditable(false);
        this.comment.setBackground(bgColor);
        BGUTable table = new BGUTable(this.colorTableModel);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 0));
        this.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.period, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 0, 0, 5), 0, 0));
        this.add((Component)new JLabel("\u0421\u0442\u0430\u0442\u0443\u0441:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.status, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 0, 0, 5), 0, 0));
        this.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 10, 1, new Insets(2, 0, 0, 5), 0, 0));
        this.add((Component)new JLabel("\u0426\u0432\u0435\u0442\u0430 \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)BGSwingUtilites.wrapScrollPane(table, 300, 170), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 0, 0, 5), 0, 0));
    }

    public void setStatusData(StatusChartPanel.StatusData statusData) {
        DateTimeFormatter f = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        this.period.setText(Optional.ofNullable(statusData).map(a -> a.from.format(f) + " - " + a.to.format(f)).orElse(""));
        this.status.setText(Optional.ofNullable(statusData).map(a -> a.statusTitle).orElse(""));
        this.comment.setText(Optional.ofNullable(statusData).map(a -> a.comment).orElse(""));
    }

    public void setData(List<BGUTableRowData> rows, Map<Integer, Color> statusColorMap) {
        this.statusColorMap = statusColorMap;
        ArrayList data = new ArrayList();
        if (Utils.notEmptyCollection(rows)) {
            rows.stream().map(a -> new StatusColor().setStatus(Utils.parseInt(a.optValue("statusId").orElse("0"))).setStatusTitle(a.optValue("status").orElse("?"))).filter(a -> !data.contains(a)).forEach(a -> data.add(a));
        }
        this.colorTableModel.setData(data);
    }

    class StatusColorTableModel
    extends BGTableModel<StatusColor> {
        public StatusColorTableModel() {
            super(StatusColorTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u0426\u0432\u0435\u0442", 50, 50, 50, "color", false, new ColorTableCellRender());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 50, 100, -1, "statusTitle", false, HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public Object getValue(StatusColor val, int columnIndex) throws Exception {
            String identifier;
            return switch (identifier = this.getIdentifier(columnIndex)) {
                case "color" -> {
                    if (val.status > -1 && StatusChartInfoPanel.this.statusColorMap.containsKey(val.status)) {
                        yield StatusChartInfoPanel.this.statusColorMap.get(val.status);
                    }
                    yield null;
                }
                default -> super.getValue(val, columnIndex);
            };
        }
    }

    public static class StatusColor {
        private int status;
        private String statusTitle;
        private Color color;

        public int getStatus() {
            return this.status;
        }

        public String getStatusTitle() {
            return this.statusTitle;
        }

        public Color getColor() {
            return this.color;
        }

        public StatusColor setStatus(int status) {
            this.status = status;
            return this;
        }

        public StatusColor setStatusTitle(String statusTitle) {
            this.statusTitle = statusTitle;
            return this;
        }

        public StatusColor setColor(Color color) {
            this.color = color;
            return this;
        }

        public boolean equals(Object obj) {
            return this.status == ((StatusColor)obj).status;
        }
    }
}

