/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.balance.server.service;

import bitel.billing.server.contract.bean.ContractUtils;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.jws.WebService;
import jakarta.xml.bind.annotation.XmlMimeType;
import jakarta.xml.ws.Holder;
import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.admin.mail.server.mail.MailBalanceSender;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.AbstractBalanceBean;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.BalanceBaseType;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.BalanceDetailItem;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.BalanceDistributeData;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ChargeType;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ContractAccount;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ContractAccountDetail;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ContractBalance;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentType;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Reserve;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ReserveType;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.BalanceService;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ReserveDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ChargeEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.balance.common.service.BalanceService")
public class BalanceServiceImpl
extends AbstractService
implements BalanceService {
    private ReserveDao reserveDao;
    private BalanceDao balanceDao;

    private ReserveDao getReserveDao() {
        if (this.reserveDao == null) {
            this.reserveDao = new ReserveDao(this.getConnection());
        }
        return this.reserveDao;
    }

    private BalanceDao getBalanceDao() {
        if (this.balanceDao == null) {
            this.balanceDao = new BalanceDao(this.getConnection());
        }
        return this.balanceDao;
    }

    @Override
    public List<BalanceDetailItem> balanceDetailList(int contractId, Period period, boolean available) throws BGException {
        return this.tryReturn(() -> {
            BigDecimal sum;
            BigDecimal reserveSum;
            String title;
            ArrayList<BalanceDetailItem> resultList = new ArrayList<BalanceDetailItem>();
            if (period == null || contractId < 1) {
                return resultList;
            }
            Calendar date1 = period.getDateFromCalendar();
            Calendar date2 = period.getDateToCalendar();
            Calendar now = Calendar.getInstance();
            ContractUtils utils = new ContractUtils(this.getConnection());
            Directory<ChargeType> chargeTypeDirectory = this.context.getDirectory(ChargeType.class, 0);
            Directory<PaymentType> paymentTypeDirectory = this.context.getDirectory(PaymentType.class, 0);
            Directory<Service> seriviceDirectory = this.context.getDirectory(Service.class, 0);
            ArrayList<BalanceDetailItem> balanceItemList = new ArrayList<BalanceDetailItem>();
            if (date1 == null) {
                date1 = (Calendar)now.clone();
            }
            if (date2 == null) {
                date2 = (Calendar)now.clone();
            }
            date1.set(5, 1);
            date1 = TimeUtils.clear_HOUR_MIN_MIL_SEC(date1);
            date2.set(date2.get(1), date2.get(2), date2.getActualMaximum(5), 23, 59, 59);
            if (!date1.before(date2)) {
                return resultList;
            }
            if (available) {
                List<Reserve> reserveList = this.getReserveDao().getReserveList(contractId, new Period(date1.getTime(), date2.getTime()), 2);
                Directory<ReserveType> reserveTypeDirectory = this.context.getDirectory(ReserveType.class, 0);
                for (Reserve reserve : reserveList) {
                    String cTitle = utils.getContractTitle(reserve.getContractId());
                    String rTitle = reserveTypeDirectory.get(reserve.getTypeId()) != null ? reserveTypeDirectory.get(reserve.getTypeId()).getTitle() : "<\u0422\u0438\u043f \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>";
                    Calendar from = TimeUtils.convertDateToCalendar(reserve.getPeriod().getDateFrom());
                    Calendar to = TimeUtils.convertDateToCalendar(reserve.getDateClose());
                    if (from.compareTo(date1) >= 0 && from.compareTo(date2) <= 0) {
                        balanceItemList.add(new BalanceDetailItem(reserve, 5, cTitle, rTitle));
                    }
                    if (to == null || to.compareTo(date2) > 0 || to.compareTo(date1) < 0) continue;
                    balanceItemList.add(new BalanceDetailItem(reserve, 6, cTitle, rTitle));
                }
            }
            Period period1 = new Period(date1.getTime(), date2.getTime());
            ChargeDao chargeDao = new ChargeDao(this.getConnection());
            for (Charge charge : chargeDao.getChargeList(contractId, -1, period1, 2).getList()) {
                title = chargeTypeDirectory.get(charge.getTypeId()) != null ? chargeTypeDirectory.get(charge.getTypeId()).getTitle() : "<\u0422\u0438\u043f \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>";
                balanceItemList.add(new BalanceDetailItem(charge, utils.getContractTitle(charge.getContractId()), title));
            }
            for (Charge charge : chargeDao.getPaybackList(contractId, -1, period1, 2).getList()) {
                title = chargeTypeDirectory.get(charge.getTypeId()) != null ? chargeTypeDirectory.get(charge.getTypeId()).getTitle() : "<\u0422\u0438\u043f \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>";
                balanceItemList.add(new BalanceDetailItem(charge, utils.getContractTitle(charge.getContractId()), title));
            }
            for (Payment payment : new PaymentDao(this.getConnection()).getPaymentList(contractId, period1, 2).getList()) {
                title = paymentTypeDirectory.get(payment.getTypeId()) != null ? paymentTypeDirectory.get(payment.getTypeId()).getTitle() : "<\u0422\u0438\u043f \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>";
                balanceItemList.add(new BalanceDetailItem(payment, utils.getContractTitle(payment.getContractId()), title));
            }
            for (ContractAccount account : this.getBalanceDao().getContractAccountList(contractId, period1, 2).getList()) {
                title = seriviceDirectory.get(account.getServiceId()) != null ? seriviceDirectory.get(account.getServiceId()).getTitle() : "<\u0422\u0438\u043f \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>";
                balanceItemList.add(new BalanceDetailItem(account, utils.getContractTitle(account.getContractId()), title));
            }
            Collections.sort(balanceItemList);
            Iterator iterator = balanceItemList.iterator();
            BalanceDetailItem currentBalanceItem = null;
            if (iterator.hasNext()) {
                currentBalanceItem = (BalanceDetailItem)iterator.next();
            }
            BigDecimal currentSum = null;
            Calendar cal = Calendar.getInstance();
            ContractBalance contractBalance = null;
            boolean emptyFlag = true;
            while (date1.before(date2)) {
                contractBalance = this.getBalanceDao().getContractBalance(contractId, date1.get(1), date1.get(2) + 1);
                if (contractBalance.getMonth() == date1.get(2) + 1) {
                    int mm = date1.get(2);
                    int yy = date1.get(1);
                    reserveSum = available ? this.getReserveDao().getReserveSumByDate(contractId, date1.getTime()) : BigDecimal.ZERO;
                    BigDecimal bigDecimal = sum = available ? contractBalance.getIncomingSaldo().subtract(reserveSum) : contractBalance.getIncomingSaldo();
                    if (emptyFlag) {
                        emptyFlag = false;
                        resultList.add(new BalanceDetailItem(7, date1.getTime(), sum));
                    }
                    while (currentBalanceItem != null) {
                        int month = TimeUtils.convertDateToCalendar(currentBalanceItem.getDate()).get(2);
                        int year = TimeUtils.convertDateToCalendar(currentBalanceItem.getDate()).get(1);
                        if (month != mm || yy != year) break;
                        currentSum = currentSum == null ? currentBalanceItem.toSetSumAfterChange(sum) : currentBalanceItem.toSetSumAfterChange(currentSum);
                        resultList.add(currentBalanceItem);
                        currentBalanceItem = null;
                        if (!iterator.hasNext()) continue;
                        currentBalanceItem = (BalanceDetailItem)iterator.next();
                    }
                }
                date1.add(2, 1);
            }
            date1.add(2, -1);
            if (available) {
                cal.set(date1.get(1), date1.get(2), cal.getActualMaximum(5), 23, 59, 59);
                reserveSum = this.getReserveDao().getReserveSumByDate(contractId, cal.get(2) == now.get(2) ? now.getTime() : cal.getTime());
                sum = contractBalance.toBalanceWithoutReserves().subtract(reserveSum);
            } else {
                sum = contractBalance.toBalanceWithoutReserves();
            }
            resultList.add(new BalanceDetailItem(8, date2.getTime(), sum));
            return resultList;
        });
    }

    @Override
    public List<ContractBalance> contractBalanceList(int contractId, Period period) throws BGException {
        return this.getBalanceDao().getContractBalanceList(contractId, period);
    }

    @Override
    public SearchResult<ContractAccount> contractAccountList(int contractId, Period period, int members) throws BGException {
        return this.getBalanceDao().getContractAccountList(contractId, period, members);
    }

    @Override
    public SearchResult<ContractAccountDetail> contractAccountDetailList(int contractId, int serviceId, Period period) throws BGException {
        return this.tryReturn(() -> {
            SearchResult<ContractAccountDetail> searchResult = new SearchResult<ContractAccountDetail>(period, null);
            this.getBalanceDao().getContractAccountDetailList(searchResult, contractId, serviceId);
            return searchResult;
        });
    }

    @Override
    public ContractBalance contractBalanceGet(int contractId, int year, int month) throws BGException {
        return this.getBalanceDao().getContractBalance(contractId, year, month);
    }

    @Override
    public void getDataSource(String type, int mode, int contractId, Period period, @XmlMimeType(value="application/octet-stream") Holder<DataHandler> data) throws BGException {
        this.tryCall(() -> {
            Contract contract = ContractDao.getContract(this.getConnection(), contractId);
            data.value = new DataHandler(this.getData(contract, type, mode, period, false));
        });
    }

    @Override
    public String sendEmail(String email, String type, int mode, int contractId, Period period) throws BGException {
        return this.tryReturn(() -> {
            Contract contract = this.getContract(contractId);
            DataSource file = this.getData(contract, type, mode, period, false);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            outputStream.write(file.getInputStream().readAllBytes());
            MailBalanceSender mailData = new MailBalanceSender().setContractTitle(contract.getTitle());
            mailData.setRecipients(email).setSubject("\u0411\u0430\u043b\u0430\u043d\u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 " + contract.getTitle()).setContractId(contractId).addTextPart("text", "\u0414\u0430\u043d\u043d\u043e\u0435 \u043f\u0438\u0441\u044c\u043c\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u043e\u043c \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430. \u0412 \u043f\u0440\u0438\u043a\u0440\u0435\u043f\u043b\u0435\u043d\u043d\u043e\u043c \u0444\u0430\u0439\u043b\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442\u0441\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0431\u0430\u043b\u0430\u043d\u0441\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430.").addPart("file1", "attachment", file.getContentType(), file.getName(), outputStream.toByteArray());
            return new MailMsg((Preferences)Setup.getSetup()).sendMessage(mailData);
        });
    }

    private DataSource getData(Contract contract, String type, int mode, Period period, boolean zip) throws Exception {
        String xsl = null;
        String ext = ".html";
        Object fileName = null;
        String contentType = null;
        Document doc = XMLUtils.newDocument();
        Element root = XMLUtils.createElement(doc, "data");
        root.setAttribute("contractTitle", contract.getTitle());
        root.setAttribute("cid", "" + contract.getId());
        root.setAttribute("comment", contract.getComment());
        String dateFrom = TimeUtils.format(period.getDateFrom(), "dd.MM.yyyy");
        String dateTo = TimeUtils.format(period.getDateTo(), "dd.MM.yyyy");
        root.setAttribute("date1", dateFrom);
        root.setAttribute("date2", dateTo);
        if (mode == 2 || mode == 0 || mode == 1) {
            if (type.equals("csv")) {
                xsl = "contract_balance_account_print_csv.xsl";
                ext = ".csv";
                contentType = "application/csv";
            } else {
                xsl = "contract_balance_account_print.xsl";
                contentType = "text/html";
            }
        }
        switch (mode) {
            case 0: 
            case 1: {
                ArrayList<AbstractBalanceBean> list;
                fileName = mode == 0 ? "payments" : "charges( " + dateFrom + " - " + dateTo + " )";
                BigDecimal totalSum = BigDecimal.ZERO;
                Directory<BalanceBaseType> directory = null;
                if (mode == 0) {
                    PaymentDao paymentDao = new PaymentDao(this.getConnection());
                    SearchResult<Payment> paymentList = paymentDao.getPaymentList(contract.getId(), period, 1);
                    list = new ArrayList<Payment>(paymentList.getList());
                    directory = this.context.getDirectory(PaymentType.class, this.moduleId);
                    totalSum = paymentList.getSum();
                } else {
                    ChargeDao chargeDao = new ChargeDao(this.getConnection());
                    SearchResult<Charge> chargeList = chargeDao.getChargeList(contract.getId(), -1, period, 1);
                    list = new ArrayList<Charge>(chargeList.getList());
                    directory = this.context.getDirectory(ChargeType.class, this.moduleId);
                    totalSum = chargeList.getSum();
                }
                for (AbstractBalanceBean bb : list) {
                    Element row = XMLUtils.createElement(root, "row");
                    Calendar calendar = TimeUtils.convertDateToCalendar(bb.getDate());
                    row.setAttribute("date", TimeUtils.monthNames[calendar.get(2)] + " " + calendar.get(1));
                    if (mode == 0) {
                        PaymentType pt = (PaymentType)directory.get(bb.getTypeId());
                        row.setAttribute("serviceTitle", pt != null ? pt.getTitle() : "<\u0422\u0438\u043f \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>");
                    } else {
                        ChargeType ct = (ChargeType)directory.get(bb.getTypeId());
                        row.setAttribute("serviceTitle", ct != null ? ct.getTitle() : "<\u0422\u0438\u043f \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>");
                    }
                    row.setAttribute("sum", Utils.formatBigDecimalSumm(bb.getSum()));
                }
                Element row = XMLUtils.createElement(root, "row");
                row.setAttribute("sum", "\u0418\u0442\u043e\u0433\u043e: " + Utils.formatBigDecimalSumm(totalSum));
                root.setAttribute("reportTitle", mode == 0 ? "\u041e\u0442\u0447\u0435\u0442 \u043f\u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0430\u043c" : "\u041e\u0442\u0447\u0435\u0442 \u043f\u043e \u0440\u0430\u0441\u0445\u043e\u0434\u0430\u043c");
                root.setAttribute("serviceName", mode == 0 ? "\u0422\u0438\u043f \u043f\u043b\u0430\u0442\u0435\u0436\u0430" : "\u0422\u0438\u043f \u0440\u0430\u0441\u0445\u043e\u0434\u0430");
                break;
            }
            case 2: {
                fileName = "account( " + dateFrom + " - " + dateTo + " )";
                SearchResult<ContractAccount> accountList = this.contractAccountList(contract.getId(), period, 1);
                Directory<Service> serviceDirectory = this.context.getDirectory(Service.class, this.moduleId);
                for (ContractAccount account : accountList.getList()) {
                    Element row = XMLUtils.createElement(root, "row");
                    Calendar calendar = TimeUtils.convertDateToCalendar(account.getDate());
                    row.setAttribute("date", TimeUtils.monthNames[calendar.get(2)] + " " + calendar.get(1));
                    Service ser = serviceDirectory.get(account.getServiceId());
                    row.setAttribute("serviceTitle", ser != null ? ser.getTitle() : "<\u0422\u0438\u043f \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>");
                    row.setAttribute("sum", Utils.formatBigDecimalSumm(account.getSum()));
                }
                Element row = XMLUtils.createElement(root, "row");
                row.setAttribute("sum", "\u0418\u0442\u043e\u0433\u043e: " + Utils.formatBigDecimalSumm(accountList.getSum()));
                root.setAttribute("reportTitle", "\u041e\u0442\u0447\u0435\u0442 \u043f\u043e \u043d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0435");
                root.setAttribute("serviceName", "\u0423\u0441\u043b\u0443\u0433\u0430");
                break;
            }
            case 3: {
                if (type.equals("csv")) {
                    xsl = "contract_balance_print_csv.xsl";
                    ext = ".csv";
                    contentType = "application/csv";
                } else {
                    xsl = "contract_balance_print.xsl";
                    ext = ".html";
                    contentType = "text/html";
                }
                fileName = "balance";
                List<ContractBalance> list = this.contractBalanceList(contract.getId(), period);
                for (ContractBalance contractBalance : list) {
                    Element row = XMLUtils.createElement(root, "row");
                    row.setAttribute("month", TimeUtils.monthNames[contractBalance.getMonth() - 1] + " " + contractBalance.getYear());
                    row.setAttribute("input_balance", Utils.formatBigDecimalSumm(contractBalance.getIncomingSaldo()));
                    row.setAttribute("charge", Utils.formatBigDecimalSumm(contractBalance.getCharges()));
                    row.setAttribute("account", Utils.formatBigDecimalSumm(contractBalance.getAccounts()));
                    row.setAttribute("payment", Utils.formatBigDecimalSumm(contractBalance.getPayments()));
                    BigDecimal outBalance = contractBalance.getIncomingSaldo().add(contractBalance.getPayments());
                    outBalance = outBalance.subtract(contractBalance.getAccounts()).subtract(contractBalance.getCharges());
                    row.setAttribute("output_balance", Utils.formatBigDecimalSumm(outBalance));
                }
                break;
            }
            default: {
                if (type.equals("csv")) {
                    xsl = "contract_balance_detail_print_csv.xsl";
                    ext = ".csv";
                    contentType = "application/csv";
                } else {
                    xsl = "contract_balance_detail_print.xsl";
                    ext = ".html";
                    contentType = "text/html";
                }
                fileName = "balance";
                Calendar d1 = period.getDateFromCalendar();
                Calendar d2 = period.getDateToCalendar();
                while (d1.before(d2) || d1.equals(d2)) {
                    Element month = XMLUtils.createElement(root, "month");
                    month.setAttribute("title", TimeUtils.monthNames[d1.get(2)] + "  " + d1.get(1));
                    GregorianCalendar date1 = new GregorianCalendar(d1.get(1), d1.get(2), 1);
                    d1.set(5, 1);
                    Calendar date2 = (Calendar)d1.clone();
                    date2.add(2, 1);
                    date2.set(5, 1);
                    date2.add(6, -1);
                    d1.add(2, 1);
                    Period tmpPeriod = new Period();
                    tmpPeriod.setDateFrom(date1.getTime());
                    tmpPeriod.setDateTo(date2.getTime());
                    List<BalanceDetailItem> list = this.balanceDetailList(contract.getId(), tmpPeriod, false);
                    for (BalanceDetailItem balanceDetailItem : list) {
                        Element row = XMLUtils.createElement(month, "row");
                        row.setAttribute("contractTitle", balanceDetailItem.getContractTitle());
                        row.setAttribute("date", TimeUtils.format(balanceDetailItem.getDate(), "dd.MM.yyyy"));
                        row.setAttribute("type", balanceDetailItem.getTypeTitle());
                        row.setAttribute("comment", balanceDetailItem.getComment());
                        row.setAttribute("summa", Utils.formatBigDecimalSumm(balanceDetailItem.getSum()));
                        row.setAttribute("summAfterCharge", Utils.formatBigDecimalSumm(balanceDetailItem.getSumAfterChange()));
                    }
                }
                break block0;
            }
        }
        return XSLManager.getInstance().transform(xsl, new DOMSource(doc), null, contentType, (String)fileName + ext, zip);
    }

    @Override
    public List<Integer> contractBalanceTransfer(int contractId, Date date, List<BalanceDistributeData> balanceDistributeDataList, boolean customer) throws BGException {
        return this.tryReturn(() -> {
            Setup setup = this.getSetup();
            Connection con = this.getConnection();
            if (contractId <= 0 || date == null) {
                throw new BGIllegalArgumentException();
            }
            if (balanceDistributeDataList == null || balanceDistributeDataList.size() == 0) {
                throw new BGIllegalArgumentException();
            }
            balanceDistributeDataList.stream().filter(a -> a.getAmout() != null).forEach(a -> a.setAmout(a.getAmout().setScale(2, RoundingMode.HALF_EVEN)));
            List balanceDistributeDataListFilter = balanceDistributeDataList.stream().filter(a -> a.getAmout() != null && a.getAmout().compareTo(BigDecimal.ZERO) >= 0).collect(Collectors.toList());
            if (balanceDistributeDataListFilter.size() == 0) {
                throw new BGIllegalArgumentException();
            }
            if (setup.getInt("allow.future.payment", 0) == 0 && TimeUtils.dateBefore(new Date(), date)) {
                throw new BGMessageException("\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u044b \u043f\u0440\u0438\u0445\u043e\u0434\u044b \u0441 \u0434\u0430\u0442\u043e\u0439 \u043f\u043e\u0437\u0434\u043d\u0435\u0435 \u0442\u0435\u043a\u0443\u0449\u0435\u0439", "contractBalanceTransfer.pastPaymentsForbidden");
            }
            int paymentTransferType = setup.getInt("transfer.payment.type", 0);
            int chargeTransferType = setup.getInt("transfer.charge.type", 0);
            if (paymentTransferType == 0 || chargeTransferType == 0) {
                throw new BGMessageException("\u0412 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430\u0445 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d \u0442\u0438\u043f \u0440\u0430\u0441\u0445\u043e\u0434\u0430 \u0438 \u043f\u0440\u0438\u0445\u043e\u0434\u0430 \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u043d\u043e\u0441\u0430 (transfer.payment.type \u0438 transfer.charge.type)!", "contractBalanceTransfer.notConfigured");
            }
            Contract contract = null;
            try (ContractDao contractDao = new ContractDao(con, this.userId);){
                BalanceUtils balanceUtils = new BalanceUtils(con);
                try {
                    BigDecimal balance;
                    contract = (Contract)contractDao.get(contractId);
                    if (contract == null) {
                        throw new BGMessageException("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", "contractBalanceTransfer.contractNotFound");
                    }
                    ChargeDao cm = new ChargeDao(con);
                    PaymentDao pm = new PaymentDao(con);
                    if (!TimeUtils.dateInRange(TimeUtils.convertDateToCalendar(date), TimeUtils.convertDateToCalendar(contract.getDateFrom()), TimeUtils.convertDateToCalendar(contract.getDateTo()))) {
                        throw new BGMessageException("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 " + contract.getTitle() + " \u043d\u0435\u0430\u043a\u0442\u0438\u0432\u0435\u043d \u0432 \u043c\u043e\u043c\u0435\u043d\u0442 \u043f\u043b\u0430\u0442\u0435\u0436\u0430!", "contractBalanceTransfer.contractPeriodNotActive");
                    }
                    BigDecimal sum = BigDecimal.ZERO;
                    HashMap<Integer, Contract> subContractMap = new HashMap<Integer, Contract>();
                    for (BalanceDistributeData data : balanceDistributeDataListFilter) {
                        Contract subContract = (Contract)contractDao.get(data.getContractId());
                        if (subContract == null) {
                            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0441 \u043a\u043e\u0434\u043e\u043c " + data.getContractId(), "contractBalanceTransfer.subContractNotFound");
                        }
                        if (subContract.getSuperContractId() != contract.getId() || !subContract.isIndependSub()) {
                            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 ID \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 ", "contractBalanceTransfer.wrongSubContractId");
                        }
                        subContractMap.put(data.getContractId(), subContract);
                        if (!TimeUtils.dateInRange(TimeUtils.convertDateToCalendar(date), TimeUtils.convertDateToCalendar(subContract.getDateFrom()), TimeUtils.convertDateToCalendar(subContract.getDateTo()))) {
                            throw new BGMessageException("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 " + subContract.getTitle() + " \u043d\u0435\u0430\u043a\u0442\u0438\u0432\u0435\u043d \u0432 \u043c\u043e\u043c\u0435\u043d\u0442 \u043f\u043b\u0430\u0442\u0435\u0436\u0430!", "contractBalanceTransfer.subContractPeriodNotActive");
                        }
                        sum = sum.add(data.getAmout());
                    }
                    if (customer && (balance = contract.getBalanceMode() == 0 ? balanceUtils.getSaldo(new Date(), contract.getId()) : balanceUtils.getBalance(LocalDate.now(), contract.getId())).compareTo(sum) < 0) {
                        throw new BGMessageException("\u0412\u0432\u0435\u0434\u0435\u043d\u043d\u044b\u0435 \u0441\u0443\u043c\u043c\u044b \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u044e\u0442 \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0435 \u0441\u0440\u0435\u0434\u0441\u0442\u0432\u0430 \u0441\u0443\u043f\u0435\u0440\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430!", "contractBalanceTransfer.amountSumBalanceError");
                    }
                    ArrayList<Integer> ids = new ArrayList<Integer>();
                    for (BalanceDistributeData data : balanceDistributeDataListFilter) {
                        Payment payment = new Payment().setTypeId(paymentTransferType).setContractId(data.getContractId()).setDate(date).setSum(data.getAmout()).setComment("\u041f\u0435\u0440\u0435\u043d\u043e\u0441 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0441 \u0441\u0443\u043f\u0435\u0440\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430").setUserId(this.userId);
                        pm.update(payment);
                        ids.add(payment.getContractId());
                        Contract subContract = (Contract)subContractMap.get(data.getContractId());
                        balanceUtils.updateBalance(payment.getDate(), subContract);
                        this.context.publishAfterCommit(new PaymentEvent(0, payment));
                        this.context.publishAfterCommit(new ContractBalanceChangedEvent(data.getContractId(), 3, payment.getSum()));
                        Charge charge = new Charge().setTypeId(chargeTransferType).setContractId(contractId).setDate(date).setSum(data.getAmout()).setComment("\u0421\u0440\u0435\u0434\u0441\u0442\u0432\u0430 \u043f\u0435\u0440\u0435\u043d\u0435\u0441\u0435\u043d\u044b \u043d\u0430 \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + subContract.getTitle()).setUserId(this.userId);
                        cm.update(charge);
                        balanceUtils.updateBalance(date, contractId);
                        this.context.publishAfterCommit(new ChargeEvent(0, charge));
                        this.context.publishAfterCommit(new ContractBalanceChangedEvent(data.getContractId(), 4, charge.getSum()));
                    }
                    ArrayList<Integer> arrayList = ids;
                    balanceUtils.close();
                    return arrayList;
                }
                catch (Throwable throwable) {
                    try {
                        balanceUtils.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        });
    }
}

