/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.status.client;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.bushe.swing.event.EventBus;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.emuns.BGEntityType;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractStatusService;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractEditor;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractSubPanel;
import ru.bitel.bgbilling.kernel.contract.status.client.ClientStatusUtil;
import ru.bitel.bgbilling.kernel.contract.status.client.StatusChartInfoPanel;
import ru.bitel.bgbilling.kernel.contract.status.client.StatusChartPanel;
import ru.bitel.bgbilling.kernel.contract.status.client.StatusControlPanel;
import ru.bitel.bgbilling.kernel.contract.status.client.StatusLogPanel;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatus;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.Status;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.table.client.BGDataSourceTableModel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.task.common.bean.BGFutureTask;
import ru.bitel.bgbilling.kernel.task.common.bean.enums.BGFutureTaskStatus;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGTitleLabel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.Period;

public class ContractSubPanel_Status
extends ContractSubPanel {
    private BGUTable statusTable = null;
    private List<Status> statusList = null;
    private JLabel recordCountLabel = new JLabel();
    private JTabbedPane tabbedPane = new JTabbedPane();
    private StatusChartPanel chart = new StatusChartPanel();
    private StatusLogPanel statusLogPanel = new StatusLogPanel();
    private BGControlPanelPages panelPages = new BGControlPanelPages();
    private StatusChartInfoPanel chartInfoPanel = new StatusChartInfoPanel();
    private StatusControlPanel statusControlPanel = new StatusControlPanel();
    private BGDataSourceTableModel statusTableModel = new BGDataSourceTableModel("ContractStatus");
    private StatusFutureTaskTableModel statusFutureTaskTableModel = new StatusFutureTaskTableModel();
    private ContractStatusService contractStatusService = null;
    private ButtonGroup statusFilterButtonGroup = new ButtonGroup();

    public ContractSubPanel_Status() {
        this.jbInit();
    }

    private void jbInit() {
        this.tabbedPane.add((Component)this.getStatusPanel(), "\u0421\u0442\u0430\u0442\u0443\u0441");
        this.tabbedPane.add((Component)((Object)this.statusLogPanel), "\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439");
        this.tabbedPane.addChangeListener(e -> this.setData());
        this.setLayout(new GridBagLayout());
        this.add(this.tabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getStatusPanel() {
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(0, (Component)this.getStatusPeriodPanel(), (Component)this.getStatusFutureTaskPanel(), 600L);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)splitPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getStatusPeriodPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getStatusFilterPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)this.getTableAndDiagramPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getTableAndDiagramPanel() {
        this.statusTable = new BGUTable((TableModel)((Object)this.statusTableModel));
        this.chart.addPropertyChangeListener(e -> Optional.ofNullable(e).filter(a -> a.getPropertyName().equals("selectDate")).map(a -> (StatusChartPanel.StatusData)a.getNewValue()).ifPresent(a -> this.chartInfoPanel.setStatusData((StatusChartPanel.StatusData)a)));
        JScrollPane scrollPane = new JScrollPane(this.chart);
        scrollPane.setBackground(Color.WHITE);
        JPanel chartPanel = new JPanel(new BorderLayout());
        chartPanel.add((Component)scrollPane, "Center");
        chartPanel.add((Component)((Object)this.chartInfoPanel), "East");
        CardLayout cardLayout = new CardLayout();
        JPanel cardPanel = new JPanel(cardLayout);
        cardPanel.add((Component)new JScrollPane((Component)this.statusTable), "table");
        cardPanel.add((Component)chartPanel, "chart");
        BGDialogToolBar toolBar = new BGDialogToolBar();
        toolBar.setFloatable(false);
        toolBar.setOrientation(1);
        toolBar.setDefaultButtons(e -> cardLayout.show(cardPanel, e.getActionCommand()), new BGDialogToolBar.ButtonData[]{BGDialogToolBar.ButtonData.TABLE, BGDialogToolBar.ButtonData.CHART});
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)toolBar, "West");
        panel.add((Component)cardPanel, "Center");
        return panel;
    }

    private JPanel getStatusFilterPanel() {
        this.statusControlPanel.addActionListener(e -> {
            this.panelPages.setPageIndex(1);
            this.changeStatus();
        });
        this.panelPages.addToHandler(a -> this.setData());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)((Object)this.statusControlPanel), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)this.recordCountLabel, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 0, 15), 0, 0));
        panel.add((Component)this.panelPages, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        return panel;
    }

    private JPanel getStatusFutureTaskPanel() {
        final BGUTable table = new BGUTable((TableModel)((Object)this.statusFutureTaskTableModel));
        table.setSelectionMode(0);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (SwingUtilities.isRightMouseButton(event) && table.rowAtPoint(event.getPoint()) == ContractSubPanel_Status.this.statusFutureTaskTableModel.getSelectedRowIndex()) {
                    ContractSubPanel_Status.this.getPopupMenu().show((Component)table, event.getX(), event.getY());
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getStatusFutureTaskTopPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 10, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getStatusFutureTaskTopPanel() {
        ActionListener actionListener = e -> this.tryCall(() -> Async.ofWithTry(() -> this.statusFutureTaskTableModel.setData(this.getContractStatusService().statusFutureTasks(BGEntityType.CONTRACT, this.getContractId(), BGFutureTaskStatus.getBGFutureTaskStatusByCode(Utils.parseInt((String)this.statusFilterButtonGroup.getSelection().getActionCommand()))))));
        JToggleButton activeButton = new JToggleButton("\u0410\u043a\u0442\u0438\u0432\u043d\u044b\u0435");
        activeButton.setSelected(true);
        activeButton.setActionCommand("1");
        activeButton.addActionListener(actionListener);
        this.statusFilterButtonGroup.add(activeButton);
        JToggleButton executedButton = new JToggleButton("\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u044b\u0435");
        executedButton.setActionCommand("2");
        executedButton.addActionListener(actionListener);
        this.statusFilterButtonGroup.add(executedButton);
        JToggleButton cancelButton = new JToggleButton("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043d\u044b\u0435");
        cancelButton.setActionCommand("3");
        cancelButton.addActionListener(actionListener);
        this.statusFilterButtonGroup.add(cancelButton);
        JToggleButton allButton = new JToggleButton("\u0412\u0441\u0435");
        allButton.setActionCommand("0");
        allButton.addActionListener(actionListener);
        this.statusFilterButtonGroup.add(allButton);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new BGTitleLabel("\u0417\u0430\u0434\u0430\u0447\u0438 \u043d\u0430 \u0441\u043c\u0435\u043d\u0443 \u0441\u0442\u0430\u0442\u0443\u0441\u0430:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)activeButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        panel.add((Component)executedButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)cancelButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)allButton, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    @Override
    public void init(ContractEditor editor) {
        super.init(editor);
    }

    public void setData() {
        if (this.statusList == null) {
            this.tryCall(() -> {
                this.statusList = this.getContractStatusService().getStatusList(false);
                this.statusLogPanel.setStatusList(this.statusList);
            });
        }
        if (this.tabbedPane.getSelectedIndex() == 0) {
            Async.ofWithTry(() -> this.statusControlPanel.setStatusList(this.getContractStatusService().getStatusList(true)));
            Async.ofWithTry(() -> this.statusFutureTaskTableModel.setData(this.getContractStatusService().statusFutureTasks(BGEntityType.CONTRACT, this.getContractId(), BGFutureTaskStatus.getBGFutureTaskStatusByCode(Utils.parseInt((String)this.statusFilterButtonGroup.getSelection().getActionCommand())))));
            Async.ofWithTry(() -> {
                BGUTableParams tableParams = new BGUTableParams(this.getContractId()).setSort(this.statusTable.getSort()).setPage(this.panelPages.getPage());
                this.statusTableModel.loadData(this.getKernelContext(), tableParams, this.panelPages, this.recordCountLabel);
                HashMap<Integer, Color> statusColorMap = new HashMap<Integer, Color>();
                this.statusTableModel.getRows().stream().forEach(a -> statusColorMap.put(Utils.parseInt((String)a.optValue("statusId").orElse("0")), Color.WHITE));
                float hueIncrement = 360.0f / (float)statusColorMap.size();
                float saturation = 0.9f;
                float brightness = 0.9f;
                int i = 0;
                ArrayList statusIds = new ArrayList(statusColorMap.keySet());
                Collections.sort(statusIds);
                for (Integer statusId : statusIds) {
                    float hue = (float)i * hueIncrement + 90.0f;
                    hue = hue > 360.0f ? hue - 360.0f : hue;
                    statusColorMap.put(statusId, Color.getHSBColor(hue / 360.0f, saturation, brightness));
                    ++i;
                }
                this.chart.setData(this.statusTableModel.getRows(), statusColorMap);
                this.chartInfoPanel.setData(this.statusTableModel.getRows(), statusColorMap);
            });
        } else {
            this.statusLogPanel.performAction("refresh");
        }
    }

    private JPopupMenu getPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add("\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u0437\u0430\u0434\u0430\u0447\u0443").addActionListener(e -> this.tryCall(() -> {
            this.getContractStatusService().statusFutureTaskCancel(this.getContractId(), ((BGFutureTask)((Object)((Object)((Object)this.statusFutureTaskTableModel.getSelectedRow())))).getId());
            Async.ofWithTry(() -> this.statusFutureTaskTableModel.setData(this.getContractStatusService().statusFutureTasks(BGEntityType.CONTRACT, this.getContractId(), BGFutureTaskStatus.getBGFutureTaskStatusByCode(Utils.parseInt((String)this.statusFilterButtonGroup.getSelection().getActionCommand())))));
        }));
        return popupMenu;
    }

    private void changeStatus() {
        if (this.statusControlPanel.getDateFrom() == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430");
            return;
        }
        int[] cids = new int[]{this.getContractId()};
        ClientStatusUtil.changeStatusOnServer((Component)((Object)this), this.getContext(), cids, 0, this.statusControlPanel.getStatusId(), this.statusControlPanel.getDateFrom(), this.statusControlPanel.getDateTo(), this.statusControlPanel.getComment());
        this.setData();
        EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
    }

    private ContractStatusService getContractStatusService() {
        if (this.contractStatusService == null) {
            this.contractStatusService = (ContractStatusService)this.getContext().getWebService(ContractStatusService.class, 0);
        }
        return this.contractStatusService;
    }

    class StatusFutureTaskTableModel
    extends BGTableModel<BGFutureTask> {
        Directory<UserInfo> userInfoDirectory;

        public StatusFutureTaskTableModel() {
            super(StatusFutureTaskTableModel.class.getName());
            this.userInfoDirectory = null;
            try {
                this.userInfoDirectory = ContractSubPanel_Status.this.getContext().getDirectory(UserInfo.class, 0);
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 180, 180, 180, "period", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 100, 150, 200, "status", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441 \u0437\u0430\u0434\u0430\u0447\u0438", 120, 120, 120, "taskStatus", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u043e\u0437\u0434\u0430\u043d\u043e", 200, 200, 200, "createTime", false, (TableCellRenderer)new DatetimeTableCellRenderer("dd.MM.yyyy HH:mm:ss"));
            this.addColumn("\u0421\u043e\u0437\u0434\u0430\u043b", 100, 200, 250, "userName", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }

        public Object getValueAt(BGFutureTask val, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            ContractStatus contractStatus = ContractStatus.fromJson(new JSONObject(val.getData()));
            if ("status".equals(identifier)) {
                return ContractSubPanel_Status.this.statusList.stream().filter(a -> a.getId() == contractStatus.getStatus()).map(a -> a.getGuiTitle()).findFirst().orElse("#" + contractStatus.getStatus());
            }
            if ("taskStatus".equals(identifier)) {
                return val.getStatus().getTitle();
            }
            if ("period".equals(identifier)) {
                return new Period(contractStatus.getDateFrom(), contractStatus.getDateTo());
            }
            if ("userName".equals(identifier)) {
                return Optional.ofNullable(this.userInfoDirectory.get(val.getCreateUserId())).map(UserInfo::getName).orElse("??? [ID#" + val.getCreateUserId() + "]");
            }
            if ("comment".equals(identifier)) {
                return new JSONObject(val.getData()).optString("comment");
            }
            return super.getValueAt((Object)val, column);
        }
    }
}

