/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.script.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.script.common.bean.Script;

public class ScriptManager
extends BGLogger {
    private Connection con;

    public ScriptManager(Connection con) {
        this.con = con;
    }

    public List<Script> getScriptList() {
        ArrayList<Script> result = new ArrayList<Script>();
        String query = "SELECT * FROM script ORDER BY title";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                result.add(this.loadScriptFromRS(rs));
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return result;
    }

    public Map<Integer, Script> getScriptMap() {
        HashMap<Integer, Script> result = new HashMap<Integer, Script>();
        String query = "SELECT * FROM script ORDER BY title";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                Script script = this.loadScriptFromRS(rs);
                result.put(script.getId(), script);
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return result;
    }

    public Script getScriptById(int id) {
        Script result = null;
        String query = "SELECT * FROM script WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.loadScriptFromRS(rs);
                }
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return result;
    }

    public void deleteScript(int id) {
        String query = "DELETE FROM script WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    private Script loadScriptFromRS(ResultSet rs) throws SQLException {
        Script script = new Script();
        script.setId(rs.getInt("id"));
        script.setTitle(rs.getString("title"));
        return script;
    }
}

