/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import ru.bitel.bgbilling.client.common.table.tree.JTreeTable;
import ru.bitel.bgbilling.client.common.table.tree.TreeTableModel;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.Utils;

public class BGTreeTable
extends JTreeTable {
    public BGTreeTable(TreeTableModel model) {
        super(model);
        this.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                BGTreeTable.this.saveSize();
            }

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }
        });
    }

    private String getKey() {
        return ClientUtils.getComponentKey(this, "columnWidth");
    }

    @Override
    public void addNotify() {
        super.addNotify();
        try {
            String str = ClientSetup.getInstance().getUserConfig().get(this.getKey(), null);
            if (str != null) {
                String[] pair = str.split(":");
                int i = 0;
                for (String p : pair) {
                    Integer preferredWidth;
                    String[] val = p.split(",");
                    Integer width = Utils.parseInt(val[0], -1);
                    if (width != -1) {
                        this.getColumnModel().getColumn(i).setWidth(width);
                    }
                    if ((preferredWidth = Integer.valueOf(Utils.parseInt(val[1], -1))) != -1) {
                        this.getColumnModel().getColumn(i).setPreferredWidth(preferredWidth);
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveSize() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            sb.append(tableColumn.getWidth());
            sb.append(",");
            sb.append(tableColumn.getPreferredWidth());
            sb.append(":");
        }
        sb.setLength(sb.length() - 1);
        ClientSetup.getInstance().getUserConfig().set(this.getKey(), sb.toString());
    }
}

