/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.quartz.server;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.DirectSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.simpl.RAMJobStore;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.JobStore;
import org.quartz.spi.ThreadPool;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.oss.kernel.quartz.server.QuartzJob;

public class QuartzScheduler {
    private static QuartzScheduler instance;
    private final Setup setup;
    private Map<String, Scheduler> schedulerMap = new HashMap<String, Scheduler>();

    private QuartzScheduler(Setup setup) {
        this.setup = setup;
    }

    public static QuartzScheduler getInstance() throws BGException {
        if (instance == null) {
            instance = new QuartzScheduler(Setup.getSetup());
        }
        return instance;
    }

    public void startScheduler(String schedulerName) throws BGException {
        try {
            DirectSchedulerFactory.getInstance().getScheduler(schedulerName).start();
        }
        catch (SchedulerException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void stopScheduler(String schedulerName) throws BGException {
        try {
            DirectSchedulerFactory.getInstance().getScheduler(schedulerName).shutdown();
        }
        catch (SchedulerException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void stopAllSchedullers() throws BGException {
        try {
            for (Scheduler s : this.schedulerMap.values()) {
                s.shutdown();
            }
        }
        catch (SchedulerException e) {
            throw new BGException((Throwable)e);
        }
    }

    public boolean schedulerExist(String schedulerName) throws BGException {
        try {
            return DirectSchedulerFactory.getInstance().getScheduler(schedulerName) != null;
        }
        catch (SchedulerException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void addScheduler(String schedulerName, int threadCount) throws BGException {
        try {
            SimpleThreadPool threadPool = new SimpleThreadPool(threadCount, 5);
            threadPool.initialize();
            RAMJobStore jobStore = new RAMJobStore();
            Scheduler scheduler = DirectSchedulerFactory.getInstance().getScheduler(schedulerName);
            if (scheduler == null) {
                DirectSchedulerFactory.getInstance().createScheduler(schedulerName, "schedulerInstanceId", (ThreadPool)threadPool, (JobStore)jobStore);
                scheduler = DirectSchedulerFactory.getInstance().getScheduler(schedulerName);
                this.schedulerMap.put(schedulerName, scheduler);
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void deleteAllTasks(String schedulerName) throws BGException {
        try {
            Scheduler scheduler = DirectSchedulerFactory.getInstance().getScheduler(schedulerName);
            for (JobKey key : scheduler.getJobKeys(GroupMatcher.anyJobGroup())) {
                scheduler.deleteJob(key);
            }
        }
        catch (SchedulerException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void deleteAllTasks(String schedulerName, String taskGroup) throws BGException {
        try {
            Scheduler scheduler = DirectSchedulerFactory.getInstance().getScheduler(schedulerName);
            for (JobKey key : scheduler.getJobKeys(GroupMatcher.groupEquals((String)taskGroup))) {
                scheduler.deleteJob(key);
            }
        }
        catch (SchedulerException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void deleteTask(String schedulerName, String taskGroup, String taskName) throws BGException {
        try {
            Scheduler scheduler = DirectSchedulerFactory.getInstance().getScheduler(schedulerName);
            for (JobKey key : scheduler.getJobKeys(GroupMatcher.groupEquals((String)taskGroup))) {
                if (!key.equals((Object)new JobKey(taskName))) continue;
                scheduler.deleteJob(key);
            }
        }
        catch (SchedulerException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void addTaskCron(Class<?> taskClass, String schedulerName, String taskGroup, String taskName, String cronTab, Map<String, ?> params, int moduleId) throws BGException {
        Calendar startFrom = Calendar.getInstance();
        startFrom.add(13, 1);
        CronScheduleBuilder builder = CronScheduleBuilder.cronSchedule((String)cronTab);
        this.AddTaskInternal(taskClass, schedulerName, taskGroup, taskName, params, moduleId, (ScheduleBuilder<?>)builder, startFrom.getTime());
    }

    public void addTask(Class<?> taskClass, String schedulerName, String taskGroup, String taskName, Date date, Map<String, ?> params, int moduleId) throws BGException {
        SimpleScheduleBuilder builder = SimpleScheduleBuilder.simpleSchedule();
        this.AddTaskInternal(taskClass, schedulerName, taskGroup, taskName, params, moduleId, (ScheduleBuilder<?>)builder, date);
    }

    private void AddTaskInternal(Class<?> taskClass, String schedulerName, String taskGroup, String taskName, Map<String, ?> params, int moduleId, ScheduleBuilder<?> builder, Date startAt) throws BGException {
        try {
            JobDataMap jobDataMap = new JobDataMap();
            jobDataMap.put("taskClass", taskClass);
            jobDataMap.put("params", params);
            jobDataMap.put("moduleId", moduleId);
            jobDataMap.put("setup", (Object)this.setup);
            JobDetail job = JobBuilder.newJob(QuartzJob.class).setJobData(jobDataMap).withIdentity(taskName, taskGroup).build();
            Calendar startFrom = Calendar.getInstance();
            startFrom.add(13, 1);
            Trigger trigger = TriggerBuilder.newTrigger().withSchedule(builder).startAt(startAt).build();
            Scheduler scheduler = DirectSchedulerFactory.getInstance().getScheduler(schedulerName);
            scheduler.scheduleJob(job, trigger);
        }
        catch (SchedulerException e) {
            throw new BGException((Throwable)e);
        }
    }
}

