/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.mail.server.bean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.admin.mail.common.dto.MailComponentDto;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.enums.ComponentType;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.common.Utils;

public class MailCache
extends BGLogger {
    private static Map<String, List<MailData>> mailCacheMap = null;

    public List<MailData> getMailList(String componentId) {
        return this.getMailCacheMap().get(componentId);
    }

    public List<MailComponentDto> getMailComponentList() {
        ArrayList<MailComponentDto> componentDtos = new ArrayList<MailComponentDto>();
        MailComponentDto mailKernel = new MailComponentDto();
        mailKernel.setType("kernel");
        mailKernel.setComponentName("kernel");
        mailKernel.setComponentTitle("\u042f\u0434\u0440\u043e");
        mailKernel.setMailCount(this.getMailCacheMap().get(mailKernel.getComponentName()).size());
        componentDtos.add(mailKernel);
        for (BGModule bGModule : ModuleCache.getInstance().getModulesList()) {
            BGInstalledModule bgInstalledModule = bGModule.getInstalledModule();
            List<MailData> datas = this.getMailCacheMap().get(bgInstalledModule.getName());
            if (datas == null || datas.isEmpty()) continue;
            MailComponentDto dto = new MailComponentDto();
            dto.setType("module");
            dto.setComponentName(bgInstalledModule.getName());
            dto.setComponentTitle(bGModule.getGuiTitle());
            dto.setModuleId(bGModule.getId());
            dto.setMailCount(datas.size());
            componentDtos.add(dto);
        }
        for (Map.Entry entry : BGPluginManagerServer.getManager().getPluginsMap().entrySet()) {
            List<MailData> datas = this.getMailCacheMap().get(entry.getKey());
            if (datas == null || datas.isEmpty()) continue;
            MailComponentDto dto = new MailComponentDto();
            dto.setType("plugin");
            dto.setComponentName((String)entry.getKey());
            dto.setComponentTitle(((BGPluginServer)entry.getValue()).getName());
            dto.setMailCount(datas.size());
            componentDtos.add(dto);
        }
        return componentDtos;
    }

    private Map<String, List<MailData>> getMailCacheMap() {
        if (mailCacheMap == null) {
            HashMap<String, List<MailData>> map = new HashMap<String, List<MailData>>();
            this.a("ru.bitel.bgbilling.kernel.admin.mail.server.mail", "kernel", map);
            for (BGInstalledModule bGInstalledModule : ModuleCache.getInstance().getInstalledModulesList()) {
                if (bGInstalledModule.getType() != ComponentType.MODULE) continue;
                this.a(bGInstalledModule.getPackageServer() + ".mail", bGInstalledModule.getName(), map);
            }
            for (Map.Entry entry : BGPluginManagerServer.getManager().getPluginsMap().entrySet()) {
                this.a(((BGPluginServer)entry.getValue()).getPackServer() + ".mail", (String)entry.getKey(), map);
            }
            mailCacheMap = map;
        }
        return mailCacheMap;
    }

    private void a(String packageName, String componentName, Map<String, List<MailData>> map) {
        for (Class<?> clazz : Utils.getClassList(packageName)) {
            if (!MailData.class.isAssignableFrom(clazz)) continue;
            try {
                String componentId = componentName;
                MailData mailData = Utils.newInstance(clazz.getName(), MailData.class);
                List<MailData> mailDatas = map.get(componentId);
                if (mailDatas == null) {
                    mailDatas = new ArrayList<MailData>();
                    map.put(componentId, mailDatas);
                }
                mailDatas.add(mailData);
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
    }
}

