/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.service;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.model.ConfigParameter;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceGroup;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceManagerMethod;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceTreeFilter;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceType;
import ru.bitel.oss.systems.inventory.resource.common.service.DeviceService;
import ru.bitel.oss.systems.inventory.resource.server.bean.DeviceDao;
import ru.bitel.oss.systems.inventory.resource.server.bean.DeviceGroupDao;
import ru.bitel.oss.systems.inventory.resource.server.bean.DeviceManagerMethodMap;
import ru.bitel.oss.systems.inventory.resource.server.bean.DeviceTypeDao;

public abstract class AbstractDeviceServiceImpl<D extends Device<D, T>, T extends DeviceType>
extends AbstractService
implements DeviceService<D, T> {
    private DeviceGroupDao deviceGroupDao = null;

    protected DeviceGroupDao getDeviceGroupDao() {
        this.deviceGroupDao = new DeviceGroupDao(this.getConnection(), this.moduleId);
        return Optional.ofNullable(this.deviceGroupDao).orElse(this.deviceGroupDao);
    }

    public DeviceGroup deviceGroupGet(int id) throws BGException {
        return (DeviceGroup)this.getDeviceGroupDao().get(id);
    }

    public DeviceGroup deviceGroupRoot() throws BGException {
        return this.getDeviceGroupDao().root();
    }

    public void deviceGroupDelete(int id) throws BGException {
        this.tryCall(() -> this.getDeviceGroupDao().delete(id));
    }

    public int deviceGroupUpdate(DeviceGroup b) throws BGException {
        return (Integer)this.tryReturn(() -> {
            this.getDeviceGroupDao().update(b);
            return b.getId();
        });
    }

    public List<T> deviceTypeList() throws BGException {
        return (List)this.tryReturn(() -> this.getDeviceTypeDirectory().list());
    }

    public List<IdTitle> deviceTypeTitleList() throws BGException {
        return (List)this.tryReturn(() -> this.getDeviceTypeDirectory().list().stream().map(IdTitle::toIdTitle).toList());
    }

    public void deviceTypeDelete(int id) throws Exception {
        if (this.getDeviceDao().listByType(id, false).size() > 0) {
            throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0442 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430");
        }
        this.getDeviceTypeDirectory().delete(id);
    }

    public int deviceTypeUpdate(T d) throws Exception {
        this.getDeviceTypeDirectory().update(d);
        return d.getId();
    }

    public D deviceRoot(DeviceTreeFilter deviceTreeFilter) throws BGException {
        return (D)((Device)this.tryReturn(() -> this.getDeviceDao().root(deviceTreeFilter)));
    }

    public void deviceMove(int id, Set<Integer> children) throws BGException {
        this.tryCall(() -> this.getDeviceDao().move(id, children));
    }

    public void deviceDelete(int id) throws Exception {
        this.getDeviceDao().delete(id);
    }

    public List<D> deviceList(int deviceTypeId) throws BGException {
        return (List)this.tryReturn(() -> this.getDeviceDao().list(deviceTypeId, false));
    }

    protected abstract Directory<T> getDeviceTypeDirectory() throws Exception;

    protected abstract DeviceDao<D, T> getDeviceDao() throws Exception;

    protected abstract DeviceTypeDao<T> getDeviceTypeDao() throws Exception;

    public List<DeviceManagerMethod> deviceManagerMethodList(int deviceTypeId) throws Exception {
        DeviceType t = this.deviceTypeGet(deviceTypeId);
        if (t == null) {
            return Collections.emptyList();
        }
        String className = t.getDeviceManagerClass();
        if (Utils.isBlankString((String)className)) {
            return Collections.emptyList();
        }
        return DeviceManagerMethodMap.getInstance().getMethodList(className);
    }

    public List<ConfigParameter> configParameterList(String className) throws BGException, BGMessageException {
        if (Utils.isEmptyString((String)className) || "---".equals(className)) {
            return Collections.emptyList();
        }
        ArrayList<ConfigParameter> configParameters = new ArrayList<ConfigParameter>();
        try {
            Class<?> clazz = DynamicClassManager.getInstance().loadClass(className);
            Method method = clazz.getMethod("configParameterList", new Class[0]);
            Object object = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            List list = (List)method.invoke(object, new Object[0]);
            list.forEach(a -> a.setHandlerName(clazz.getSimpleName()));
            configParameters.addAll(list);
        }
        catch (Exception ex) {
            BGLogger.error(ex);
        }
        return configParameters;
    }
}

