/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.search.server;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.contract.search.common.SearchImplementation;

public class ContractSearchableDao
extends AbstractIdDao<SearchImplementation> {
    public ContractSearchableDao(Connection con) {
        this(con, "contract_search_implementation", 0, null);
    }

    public ContractSearchableDao(Connection con, String tableName, int moduleId, Date date) {
        super(con, tableName, moduleId, date);
    }

    public List<SearchImplementation> getList() throws SQLException {
        ArrayList<SearchImplementation> result = new ArrayList<SearchImplementation>();
        String query = "SELECT  *  FROM " + this.tableName;
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
        }
        return result;
    }

    @Override
    protected SearchImplementation getFromRS(ResultSet rs) throws SQLException {
        return new SearchImplementation().setId(rs.getInt("id")).setTitle(rs.getString("title")).setPathToImplClass(rs.getString("implClass")).setModuleTitle(rs.getString("moduleTitle")).setModuleId(rs.getInt("moduleId")).setEnable(rs.getInt("enable") == 1);
    }

    @Override
    protected void updateImpl(SearchImplementation searchImplementation) throws SQLException {
        String querySet = "title=?, implClass=?, moduleTitle=?, moduleId=?, enable=?";
        try (PreparedStatement ps = this.prepareStatement(searchImplementation, querySet);){
            int index = 1;
            ps.setString(index++, searchImplementation.getTitle());
            ps.setString(index++, searchImplementation.getPathToImplClass());
            ps.setString(index++, searchImplementation.getModuleTitle());
            ps.setInt(index++, searchImplementation.getModuleId());
            ps.setInt(index++, searchImplementation.isEnable() ? 1 : 0);
            this.executeUpdate(searchImplementation, index, ps);
        }
    }
}

