/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.dhcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpListenerWorkerContext;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpPacket;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpProcessor;
import ru.bitel.bgbilling.kernel.network.processor.DatagramListener;
import ru.bitel.bgbilling.kernel.network.processor.ProcessorRequest;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.model.Idable;

public class DhcpListenerWorker<D extends Idable>
extends ProcessorRequest<DhcpListenerWorkerContext> {
    private static final Logger log;
    private final int overloadLevel;
    private final DhcpProcessor<D> processor;
    public int interfaceId = -1;
    public String circuitId;
    public long connectionId = 0L;
    public int relayDeviceId = -1;
    public int agentDeviceId = -1;
    protected D device;
    protected DhcpPacket request;
    protected DhcpPacket response;
    private boolean connectionModified;
    protected static final InetAddress broadcastAddress;
    protected static final InetSocketAddress broadcastAddress68;

    public DhcpListenerWorker(DatagramListener listener, DhcpProcessor<D> processor, SocketAddress clientAddress, long millis, ByteBuffer data, int overloadLevel) {
        super(listener, clientAddress, millis, data);
        this.processor = processor;
        this.overloadLevel = overloadLevel;
    }

    public int getOverloadLevel() {
        return this.overloadLevel > 9 ? this.overloadLevel : ((DhcpListenerWorkerContext)this.context).getListener().getOverloadLevel();
    }

    protected void runImpl() {
        try {
            int overloadLevel;
            int n = overloadLevel = this.overloadLevel > 9 ? this.overloadLevel : ((DhcpListenerWorkerContext)this.context).getListener().getOverloadLevel();
            if (overloadLevel > 0) {
                long millis = System.currentTimeMillis();
                switch (overloadLevel) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (millis - this.millis <= 5000L) break;
                        log.info("Due to high load skip packet processing what was recieved > 5 sec ago.");
                        return;
                    }
                    case 2: {
                        if (millis - this.millis <= 3000L) break;
                        log.info("Due to high load skip packet processing what was recieved > 3 sec ago.");
                        return;
                    }
                    case 3: {
                        if (millis - this.millis <= 1000L) break;
                        log.info("Due to high load skip packet processing what was recieved > 1 sec ago.");
                        return;
                    }
                    default: {
                        if (millis - this.millis <= 500L) break;
                        log.debug("Due to high load skip packet processing what was recieved > 500 msec ago.");
                        return;
                    }
                }
                this.request = new DhcpPacket(this.data);
                if (overloadLevel > 1) {
                    if (this.request.messageType == 1) {
                        log.info("Due to high load skip DISCOVER packet processing.");
                        return;
                    }
                    if (!(overloadLevel <= 10 || DhcpPacket.isNil(this.request.giaddr) && DhcpPacket.isRenewRequest(this.request))) {
                        return;
                    }
                }
            } else {
                this.request = new DhcpPacket(this.data);
            }
            this.processor.processRequest(this, this.clientAddress, this.request);
            if (this.response != null && (this.device != null || this.response.messageType == 6)) {
                ByteBuffer responseData = switch (this.processor.sendFix) {
                    case 1 -> this.sendResponse(this.request, this.response);
                    case 2 -> this.sendResponse3(this.request, this.response);
                    default -> this.sendResponse2(this.request, this.response);
                };
                if (this.response.messageType == 5) {
                    long now = System.currentTimeMillis();
                    int[] requestPositions = new int[3];
                    int[] responsePositions = new int[3];
                    this.data.rewind();
                    ((DhcpListenerWorkerContext)this.context).writeRecord((Idable)this.device, requestPositions, this.data, now);
                    responseData.rewind();
                    ((DhcpListenerWorkerContext)this.context).writeRecord((Idable)this.device, responsePositions, responseData, now);
                    this.processor.writeLog(this, requestPositions, responsePositions, now);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private ByteBuffer sendResponse2(DhcpPacket request, DhcpPacket response) throws InvalidKeyException, NoSuchAlgorithmException, IOException {
        ByteBuffer bb = ByteBuffer.allocate(4096);
        response.serialize(bb);
        bb.flip();
        InetSocketAddress address = (InetSocketAddress)this.clientAddress;
        if (address.getPort() != 67) {
            address = new InetSocketAddress(address.getAddress(), 67);
        }
        this.send(address, bb);
        return bb;
    }

    private ByteBuffer sendResponse(DhcpPacket request, DhcpPacket response) throws IOException {
        InetSocketAddress socketAddress;
        ByteBuffer bb = ByteBuffer.allocate(4096);
        response.serialize(bb);
        bb.flip();
        InetSocketAddress address = request.isFromRelayAgent() ? (IpAddress.equals((byte[])(socketAddress = (InetSocketAddress)this.clientAddress).getAddress().getAddress(), (byte[])request.giaddr) && socketAddress.getPort() == 67 ? socketAddress : new InetSocketAddress(InetAddress.getByAddress(request.giaddr), 67)) : (request.isClientAddressSet() ? new InetSocketAddress(InetAddress.getByAddress(request.ciaddr), 68) : ((request.flags & DhcpPacket.FLAG_BROADCAST) > 0 ? broadcastAddress68 : broadcastAddress68));
        this.send(address, bb);
        return bb;
    }

    private ByteBuffer sendResponse3(DhcpPacket request, DhcpPacket response) throws IOException {
        InetSocketAddress socketAddress;
        ByteBuffer bb = ByteBuffer.allocate(4096);
        response.serialize(bb);
        bb.flip();
        InetSocketAddress address = request.isFromRelayAgent() ? ((socketAddress = (InetSocketAddress)this.clientAddress).getPort() != 67 ? new InetSocketAddress(socketAddress.getAddress(), 67) : socketAddress) : (request.isClientAddressSet() ? new InetSocketAddress(InetAddress.getByAddress(request.ciaddr), 68) : ((request.flags & DhcpPacket.FLAG_BROADCAST) > 0 ? broadcastAddress68 : broadcastAddress68));
        this.send(address, bb);
        return bb;
    }

    public void setDevice(D device) {
        this.device = device;
    }

    public D getDevice() {
        return this.device;
    }

    public void setResponse(DhcpPacket response) {
        this.response = response;
    }

    public boolean isConnectionModified() {
        return this.connectionModified;
    }

    public void setConnectionModified(boolean connectionModified) {
        this.connectionModified = connectionModified;
    }

    public DhcpPacket getRequest() {
        return this.request;
    }

    static {
        InetAddress a;
        log = LogManager.getLogger();
        try {
            a = InetAddress.getByName("255.255.255.255");
        }
        catch (Exception e) {
            a = null;
            e.printStackTrace();
        }
        broadcastAddress = a;
        broadcastAddress68 = new InetSocketAddress(a, 68);
    }
}

