/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.radius;

import bitel.billing.server.radius.AttributeParams;
import bitel.billing.server.radius.RadiusAttributes;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.common.Utils;

public class RadiusAttribute {
    protected int length;
    protected byte[] byteValue;
    protected final int code;
    private AttributeParams attributeParams;

    public RadiusAttribute(int code) {
        this.code = code;
    }

    public final int getIntValue() {
        return Utils.convertBytesToInt((byte[])this.byteValue);
    }

    public final void setIntValue(int value) {
        this.byteValue = Utils.convertIntToBytes((int)value);
        this.length = 4;
    }

    public String getStringValue() {
        String result = null;
        if (this.byteValue != null) {
            try {
                result = new String(this.byteValue, "ISO-8859-1");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public void setStringValue(String value) {
        this.length = value.length();
        try {
            this.byteValue = value.getBytes("ISO-8859-1");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final byte[] getByteValue() {
        return this.byteValue;
    }

    public final void setByteValue(byte[] value) {
        this.length = value.length;
        this.byteValue = value;
    }

    public final int getAttrLength() {
        return this.length;
    }

    public final int getAttrCode() {
        return this.code;
    }

    public String toString() {
        String result = "undef";
        AttributeParams attribute = RadiusAttributes.getAttributeParams(this.code);
        if (attribute != null) {
            result = this.valueToString(attribute);
        }
        return result;
    }

    protected String valueToString(AttributeParams attribute) {
        String result = "undef";
        switch (attribute.getType()) {
            case 0: {
                result = this.getStringValue();
                break;
            }
            case 1: {
                result = String.valueOf(Utils.unsignedIntToLong((int)this.getIntValue()));
                break;
            }
            case 2: {
                result = IPUtils.convertIpToString((int)this.getIntValue());
            }
        }
        return result;
    }

    public void loadFromString(String value) {
        AttributeParams attribute = RadiusAttributes.getAttributeParams(this.code);
        if (attribute != null) {
            this.valueFromString(attribute, value);
        }
    }

    protected void valueFromString(AttributeParams attribute, String value) {
        switch (attribute.getType()) {
            case 0: {
                this.setStringValue(value);
                break;
            }
            case 2: {
                this.setIntValue(IPUtils.convertStringIPtoInt((String)value));
                break;
            }
            case 1: {
                this.setIntValue(Utils.parseInt((String)value, (int)-1));
            }
        }
    }

    public RadiusAttribute clone() {
        RadiusAttribute result = new RadiusAttribute(this.code);
        result.byteValue = new byte[this.byteValue.length];
        result.length = this.length;
        System.arraycopy(this.byteValue, 0, result.byteValue, 0, this.byteValue.length);
        return result;
    }

    public final AttributeParams getAttributeParams() {
        return this.attributeParams;
    }

    public final void setAttributeParams(AttributeParams attributeParams) {
        this.attributeParams = attributeParams;
    }
}

