/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import java.math.BigDecimal;
import java.util.Date;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.enums.ContractFace;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.IdTitle;

public class Contract
extends IdTitle {
    public static final byte CREDIT_BALANCE_MODE = 0;
    public static final byte DEBET_BALANCE_MODE = 1;
    public static final int IS_SUPER = -1;
    public static final int IS_INDEPENDENT = 0;
    public static final int SUB_MODE_DEPENDENT = 0;
    public static final int SUB_MODE_INDEPENDENT = 1;
    private long groups = 0L;
    private String password;
    private Date dateFrom;
    private Date dateTo;
    private byte balanceMode;
    private BigDecimal limit = BigDecimal.ZERO;
    private int paramGroupId;
    private byte personType;
    private boolean hidden;
    private int superContractId;
    private String dependSubList = "";
    private byte status;
    private Date statusTimeChange;
    private String comment = "";
    private int commentPatternId;
    private byte balanceSubMode;
    private int domainId;

    @XmlAttribute
    public BigDecimal getBalanceLimit() {
        return this.limit;
    }

    @XmlAttribute
    public byte getBalanceMode() {
        return this.balanceMode;
    }

    @XmlAttribute
    public byte getBalanceSubMode() {
        return this.balanceSubMode;
    }

    @XmlAttribute
    public String getComment() {
        return this.comment;
    }

    @XmlAttribute
    public int getCommentPatternId() {
        return this.commentPatternId;
    }

    @XmlAttribute
    public Date getDateFrom() {
        return this.dateFrom;
    }

    @XmlAttribute
    public Date getDateTo() {
        return this.dateTo;
    }

    @XmlAttribute
    public String getDependSubList() {
        return this.dependSubList;
    }

    @XmlAttribute
    public int getDomainId() {
        return this.domainId;
    }

    @XmlAttribute
    public ContractFace getFace() {
        return this.personType == 0 ? ContractFace.FIZIC : ContractFace.URIC;
    }

    @XmlAttribute
    public long getGroups() {
        return this.groups;
    }

    @XmlAttribute
    public int getParamGroupId() {
        return this.paramGroupId;
    }

    @XmlAttribute
    public String getPassword() {
        return this.password;
    }

    @XmlAttribute
    public byte getPersonType() {
        return this.personType;
    }

    @XmlAttribute
    public byte getStatus() {
        return this.status;
    }

    @XmlAttribute
    public Date getStatusTimeChange() {
        return this.statusTimeChange;
    }

    @XmlAttribute
    public int getSuperContractId() {
        return this.superContractId;
    }

    public boolean isActualDate(Date date) {
        return TimeUtils.dateInRange(date, this.dateFrom, this.dateTo);
    }

    @XmlAttribute
    public boolean isDependSub() {
        return this.superContractId > 0 && this.balanceSubMode == 0;
    }

    @XmlAttribute
    public boolean isHidden() {
        return this.hidden;
    }

    @XmlAttribute
    public boolean isIndependSub() {
        return this.superContractId > 0 && this.balanceSubMode == 1;
    }

    @XmlAttribute
    public boolean isSub() {
        return this.superContractId > 0;
    }

    @XmlAttribute
    public boolean isSuper() {
        return this.superContractId == -1;
    }

    public Contract setBalanceLimit(BigDecimal limit) {
        this.limit = limit;
        return this;
    }

    public Contract setBalanceMode(byte balanceMode) {
        this.balanceMode = balanceMode;
        return this;
    }

    public Contract setBalanceSubMode(byte balanceSubMode) {
        this.balanceSubMode = balanceSubMode;
        return this;
    }

    public Contract setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public Contract setCommentPatternId(int commentPatternId) {
        this.commentPatternId = commentPatternId;
        return this;
    }

    public Contract setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
        return this;
    }

    public Contract setDateTo(Date dateTo) {
        this.dateTo = dateTo;
        return this;
    }

    public Contract setDependSubList(String dependSubList) {
        this.dependSubList = dependSubList;
        return this;
    }

    public Contract setDomainId(int domainId) {
        this.domainId = domainId;
        return this;
    }

    public Contract setFace(ContractFace contractFace) {
        this.personType = (byte)(ContractFace.FIZIC != contractFace ? 1 : 0);
        return this;
    }

    public Contract setGroups(long groups) {
        this.groups = groups;
        return this;
    }

    public Contract setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Override
    public Contract setId(int id) {
        super.setId(id);
        return this;
    }

    public Contract setParamGroupId(int paramGroupId) {
        this.paramGroupId = paramGroupId;
        return this;
    }

    public Contract setPassword(String password) {
        this.password = password;
        return this;
    }

    public Contract setPersonType(byte personType) {
        this.personType = personType;
        return this;
    }

    public Contract setStatus(byte status) {
        this.status = status;
        return this;
    }

    public Contract setStatusTimeChange(Date statusTimeChange) {
        this.statusTimeChange = statusTimeChange;
        return this;
    }

    public Contract setSuperContractId(int superContractId) {
        this.superContractId = superContractId;
        return this;
    }

    @Override
    public Contract setTitle(String title) {
        super.setTitle(title);
        return this;
    }

    @Override
    public String toString() {
        return this.getTitle() + "[ " + this.comment + " ]\nStatus = " + this.status + "\nPeriod = " + String.valueOf(this.dateFrom) + " - " + String.valueOf(this.dateTo) + "\nLimit = " + String.valueOf(this.limit) + "\nBalanceMode = " + this.balanceMode + "\nSuperCid = " + this.superContractId + "\nDependSubList = " + this.dependSubList + "\nBalanceSubMode = " + this.balanceSubMode + "\nGroups = " + this.groups + "\nParamGroupId = " + this.paramGroupId + "\nPersonType = " + this.personType + "\nHidden = " + this.hidden + "\nTitlePatternId = " + this.commentPatternId + "\nStatusTimeChange = " + TimeUtils.format(this.statusTimeChange, "yyyy-MM-dd") + "\nPassword = " + this.password;
    }

    public static Contract fromContract(Contract contract) {
        return new Contract().setId(contract.getId()).setTitle(contract.getTitle()).setGroups(contract.getGroups()).setPassword(contract.getPassword()).setDateFrom(contract.getDateFrom()).setDateTo(contract.getDateTo()).setBalanceMode(contract.getBalanceMode()).setBalanceLimit(contract.getBalanceLimit()).setParamGroupId(contract.getParamGroupId()).setPersonType(contract.getPersonType()).setHidden(contract.isHidden()).setSuperContractId(contract.getSuperContractId()).setDependSubList(contract.getDependSubList()).setStatus(contract.getStatus()).setStatusTimeChange(contract.getStatusTimeChange()).setComment(contract.getComment()).setCommentPatternId(contract.getCommentPatternId()).setBalanceSubMode(contract.getBalanceSubMode()).setDomainId(contract.getDomainId());
    }
}

