/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.job.server;

import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.oss.kernel.job.server.JobScheduler;

public class JobRuntime
implements Callable<Object> {
    public final JobScheduler jobExecutor;
    public final long id;
    private Class<?> jobClass;
    private boolean persistent;
    private boolean concurrent;
    private String paramsString;
    private ParameterMap params;
    private long version;
    private final Lock runLock;
    private final Lock lock;

    public JobRuntime(JobScheduler jobExecutor, long id) {
        this.jobExecutor = jobExecutor;
        this.id = id;
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.runLock = readWriteLock.readLock();
        this.lock = readWriteLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setJob(Class<?> jobClass, boolean persistent, boolean concurrent, ParameterMap data, String dataString, long version) {
        Lock lock = this.lock;
        lock.lock();
        try {
            this.jobClass = jobClass;
            this.persistent = persistent;
            this.concurrent = concurrent;
            this.paramsString = dataString;
            this.params = data != null ? data : new Preferences(dataString, "\n");
            this.version = version;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() throws Exception {
        Object jobInstance = this.jobClass.newInstance();
        Lock runLock = this.runLock;
        runLock.lock();
        try {
            Object object = this.callImpl(jobInstance);
            return object;
        }
        finally {
            runLock.unlock();
        }
    }

    private Object callImpl(Object jobInstance) throws Exception {
        if (jobInstance instanceof Callable) {
            return ((Callable)jobInstance).call();
        }
        ((Runnable)jobInstance).run();
        return null;
    }

    public Class<?> getJobClass() {
        return this.jobClass;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public boolean isConcurrent() {
        return this.concurrent;
    }

    public String getParamsString() {
        return this.paramsString;
    }

    public ParameterMap getParams() {
        return this.params;
    }

    public long getVersion() {
        return this.version;
    }
}

