/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean;

import bitel.billing.server.contract.bean.ContractGroup;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ContractGroupManager {
    private static final String TABLE_NAME = "contract_group";
    protected Connection con;

    public ContractGroupManager(Connection con) {
        this.con = con;
    }

    public List<ContractGroup> getGroupList() throws SQLException {
        return this.getGroupList(true);
    }

    public List<ContractGroup> getGroupList(long groupMask) throws SQLException {
        ArrayList<ContractGroup> list = new ArrayList<ContractGroup>();
        for (ContractGroup contractGroup : this.getGroupList(false)) {
            if ((groupMask & 1L << contractGroup.getId()) <= 0L) continue;
            list.add(contractGroup);
        }
        return list;
    }

    public List<ContractGroup> getEnableGroupList() throws SQLException {
        ArrayList<ContractGroup> list = new ArrayList<ContractGroup>();
        for (ContractGroup contractGroup : this.getGroupList(false)) {
            if (!contractGroup.isEnabled()) continue;
            list.add(contractGroup);
        }
        return list;
    }

    public List<ContractGroup> getGroupList(boolean all) throws SQLException {
        ArrayList<ContractGroup> list = new ArrayList<ContractGroup>();
        ContractGroup[] contractGroups = new ContractGroup[63];
        String query = "SELECT * FROM contract_group ORDER BY title";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                ContractGroup contractGroup = new ContractGroup().setId(rs.getInt("id")).setTitle(rs.getString("title")).setEnabled(rs.getBoolean("enable")).setEditable(rs.getBoolean("editable")).setComment(rs.getString("comment"));
                if (all) {
                    contractGroups[contractGroup.getId()] = contractGroup;
                    continue;
                }
                list.add(contractGroup);
            }
        }
        if (all) {
            for (int index = 0; index < 63; ++index) {
                ContractGroup contractGroup = contractGroups[index];
                if (contractGroup != null) continue;
                contractGroups[index] = contractGroup = new ContractGroup().setId(index).setTitle("\u0413\u0440\u0443\u043f\u043f\u0430 " + String.format("%1$02d", index)).setEnabled(false).setEditable(false).setComment("");
            }
            for (ContractGroup contractGroup : contractGroups) {
                if (contractGroup == null) continue;
                list.add(contractGroup);
            }
            Collections.sort(list);
        }
        return list;
    }

    public boolean isEditable(int id) throws SQLException {
        boolean result = true;
        String query = "SELECT editable FROM contract_group WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result = rs.getBoolean(1);
                }
            }
        }
        return result;
    }

    public void updateGroup(ContractGroup contractGroup) throws SQLException {
        int index;
        Objects.requireNonNull(contractGroup);
        boolean updateRow = false;
        int groupId = contractGroup.getId();
        String query = "UPDATE contract_group SET title=?, enable=?, editable=?, comment=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            index = 1;
            ps.setString(index++, contractGroup.getTitle());
            ps.setInt(index++, contractGroup.isEnabled() ? 1 : 0);
            ps.setInt(index++, contractGroup.isEditable() ? 1 : 0);
            ps.setString(index++, contractGroup.getComment());
            ps.setInt(index++, groupId);
            updateRow = ps.executeUpdate() > 0;
        }
        if (!updateRow && groupId >= 0 && groupId < 64) {
            query = "INSERT INTO contract_group SET title=?, enable=?, editable=?, comment=?, id=?";
            ps = this.con.prepareStatement(query);
            try {
                index = 1;
                ps.setString(index++, contractGroup.getTitle());
                ps.setInt(index++, contractGroup.isEnabled() ? 1 : 0);
                ps.setInt(index++, contractGroup.isEditable() ? 1 : 0);
                ps.setString(index++, contractGroup.getComment());
                ps.setInt(index++, groupId);
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }

    public Map<Integer, Integer> getStatMap() throws SQLException {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        String query = "SELECT gr, COUNT(*) FROM contract GROUP BY gr";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                int count = rs.getInt(2);
                int index = 0;
                for (long gr = rs.getLong(1); gr > 0L; gr >>= 1) {
                    if ((gr & 1L) > 0L) {
                        Integer grCount = (Integer)map.get(index);
                        if (grCount == null) {
                            grCount = 0;
                        }
                        grCount = grCount + count;
                        map.put(index, grCount);
                    }
                    ++index;
                }
            }
        }
        return map;
    }
}

