/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.common.util.DelayedAdapter;

public class TimeoutMap<K, V> {
    private static final Logger logger = LogManager.getLogger();
    private final ConcurrentMap<K, V> map = new ConcurrentHashMap();
    private final DelayQueue<Entry> queue = new DelayQueue();
    private final Runnable worker;
    private volatile boolean working = true;
    private final ScheduledFuture<?> future;

    public TimeoutMap(ScheduledExecutorService scheduledExecutorService, long initialDelay, long period, TimeUnit unit) {
        this.worker = new Worker();
        this.future = scheduledExecutorService.scheduleWithFixedDelay(this.worker, initialDelay, period, unit);
    }

    protected void afterRemoveOnTimeout(K key, V value) {
    }

    public TimeoutMap(String workerName) {
        this.worker = new ThreadWorker();
        this.future = null;
        new Thread(this.worker, workerName).start();
    }

    public void put(K key, V value, long expire) {
        this.map.put(key, value);
        this.queue.add(new Entry(this, key, value, expire));
    }

    public V putIfAbsent(K key, V value, long expire) {
        V result = this.map.putIfAbsent(key, value);
        if (result == null) {
            this.queue.add(new Entry(this, key, value, expire));
        }
        return result;
    }

    public V remove(K key) {
        return this.map.remove(key);
    }

    public boolean remove(K key, V value) {
        return this.map.remove(key, value);
    }

    public V get(K key) {
        return this.map.get(key);
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public void clear() {
        this.map.clear();
    }

    public void shutdown() {
        this.working = false;
        if (this.future != null) {
            this.future.cancel(false);
        }
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        @Override
        public void run() {
            try {
                Entry k;
                DelayQueue<Entry> queue = TimeoutMap.this.queue;
                while ((k = (Entry)queue.poll()) != null) {
                    if (!TimeoutMap.this.map.remove(k.key, k.value)) continue;
                    TimeoutMap.this.afterRemoveOnTimeout(k.key, k.value);
                }
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
            }
        }
    }

    private class ThreadWorker
    implements Runnable {
        private ThreadWorker() {
        }

        @Override
        public void run() {
            DelayQueue<Entry> queue = TimeoutMap.this.queue;
            while (TimeoutMap.this.working) {
                try {
                    Entry k = (Entry)queue.poll(3L, TimeUnit.SECONDS);
                    if (k == null || !TimeoutMap.this.map.remove(k.key, k.value)) continue;
                    TimeoutMap.this.afterRemoveOnTimeout(k.key, k.value);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    logger.error((Object)ex);
                }
                catch (Throwable e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
    }

    private class Entry
    extends DelayedAdapter {
        final K key;
        final V value;

        public Entry(TimeoutMap timeoutMap, K key, V value, long expire) {
            super(expire);
            this.key = key;
            this.value = value;
        }
    }
}

