/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.directory.address;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.CalendarPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGIntTextField;
import ru.bitel.bgbilling.client.common.field.BGTextArea;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.directory.address.AddressParamTableModel;
import ru.bitel.bgbilling.client.directory.address.AddressPodTableModel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.directories.address.common.bean.AddressEntityData;
import ru.bitel.oss.kernel.directories.address.common.bean.AddressEntityParam;
import ru.bitel.oss.kernel.directories.address.common.bean.AddressEntityType;
import ru.bitel.oss.kernel.directories.address.common.bean.HouseCoordinates;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;

public class AddressHouseEditor
extends BGEditorDialog<AddressEntityData> {
    private AddressService addressService;
    private Street street;
    private String podDataHash = "";
    private String floorDataHash = "";
    private JTabbedPane tabbedPane = new JTabbedPane();
    private BGTextField parentTitle = new BGTextField(50);
    private BGUComboBox<IdTitle> area = new BGUComboBox();
    private BGUComboBox<IdTitle> quarter = new BGUComboBox();
    private BGIntTextField postIndex = new BGIntTextField(12);
    private BGIntTextField amount = new BGIntTextField(12);
    private BGIntTextField podCount = new BGIntTextField(12);
    private JTextField entityTitle = new JTextField(10);
    private BGTextArea comment = new BGTextArea(2, 70);
    private final CoordinatesPanel coordinatesPanel = new CoordinatesPanel();
    private AddressParamTableModel paramTableModel = new AddressParamTableModel();
    private AddressPodTableModel podTableModel = new AddressPodTableModel();
    private BGUTable paramTable = new BGUTable(this.paramTableModel);
    private BGUTable podTable = new BGUTable(this.podTableModel);

    public AddressHouseEditor(String title, AddressEntityData data, ClientContext clientContext) {
        super(title, data, clientContext);
    }

    private AddressService getAddressService() {
        if (this.addressService == null) {
            this.addressService = this.clientContext.getPort(AddressService.class, 0);
        }
        return this.addressService;
    }

    @Override
    public void doDialogPanel() {
        this.tabbedPane.add("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b", this.getParamPanel());
        this.tabbedPane.add("\u041f\u043e\u0434\u044a\u0435\u0437\u0434\u044b, \u044d\u0442\u0430\u0436\u0438", this.getPodPanel());
        this.panel.add((Component)this.getTitlePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panel.add((Component)this.getHouseDataPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.panel.add((Component)this.tabbedPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        try {
            AddressService addressService = this.getAddressService();
            Async<List> areaItemsAsync = Async.of(() -> addressService.addressEntityItems(AddressEntityType.AREA, this.street.getCityId()));
            Async<List> quarterItemsAsync = Async.of(() -> addressService.addressEntityItems(AddressEntityType.QUARTER, this.street.getCityId()));
            this.data = addressService.addressEntityDataGet(((AddressEntityData)this.data).getAddressEntityType(), ((AddressEntityData)this.data).getRecordId());
            this.entityTitle.setText(((AddressEntityData)this.data).getTitle());
            this.postIndex.setText(((AddressEntityData)this.data).getEntityParameter("postIndex"));
            this.amount.setText(((AddressEntityData)this.data).getEntityParameter("amount"));
            this.podCount.setText(((AddressEntityData)this.data).getEntityParameter("podCount"));
            this.comment.setText(((AddressEntityData)this.data).getEntityParameter("comment"));
            this.coordinatesPanel.setCoordinates((AddressEntityData)this.data);
            int areaId = Utils.parseInt(((AddressEntityData)this.data).getEntityParameter("areaId"));
            List areaItems = areaItemsAsync.get();
            areaItems.add(0, IdTitle.NO_SELECT);
            this.area.setData(areaItems);
            this.area.setSelectedItem(areaItems.stream().filter(a -> a.getId() == areaId).findFirst().orElse((IdTitle)areaItems.get(0)));
            int quarterId = Utils.parseInt(((AddressEntityData)this.data).getEntityParameter("quarterId"));
            List quarterItems = quarterItemsAsync.get();
            quarterItems.add(0, IdTitle.NO_SELECT);
            this.quarter.setData(quarterItems);
            this.quarter.setSelectedItem(quarterItems.stream().filter(a -> a.getId() == quarterId).findFirst().orElse((IdTitle)quarterItems.get(0)));
            this.amount.addActionListener(e -> this.setPodData(null, null));
            this.podCount.addActionListener(e -> this.setPodData(null, null));
            this.paramTableModel.setData(((AddressEntityData)this.data).getConfigParams());
            String entranceRange = ((AddressEntityData)this.data).getConfigParams().stream().filter(a -> a.getId().equals("entranceRange")).findFirst().map(a -> a.getValue()).orElse(null);
            String floorRange = ((AddressEntityData)this.data).getConfigParams().stream().filter(a -> a.getId().equals("floorRange")).findFirst().map(a -> a.getValue()).orElse(null);
            this.setPodData(entranceRange, floorRange);
            this.podDataHash = this.checkPodRanges();
            this.floorDataHash = this.checkFloorRanges();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void setPodData(String entranceRange, String floorRange) {
        ArrayList podDatas = new ArrayList();
        int pod = Utils.parseInt(this.podCount.getText());
        if (pod > 0) {
            HashMap<Integer, int[]> podRangeMap = new HashMap<Integer, int[]>();
            if (entranceRange != null) {
                String[] ranges;
                for (String range : ranges = entranceRange.split(";")) {
                    String[] podFlats;
                    String[] rangeData = range.trim().split("/");
                    if (rangeData.length != 3 || (podFlats = rangeData[0].split("-")).length != 2) continue;
                    int podFlatF = Utils.parseInt(podFlats[0]);
                    int podFlatT = Utils.parseInt(podFlats[1]);
                    int podCount = Utils.parseInt(rangeData[1]);
                    int podStart = Utils.parseInt(rangeData[2]);
                    while (podFlatF + podCount - 1 <= podFlatT) {
                        podRangeMap.put(podStart++, new int[]{podFlatF, podCount});
                        podFlatF += podCount;
                    }
                }
            }
            HashMap podFlatRangeMap = new HashMap();
            if (floorRange != null) {
                // empty if block
            }
            IntStream.range(1, pod + 1).forEach(a -> {
                int podFlatCount = Optional.ofNullable((int[])podRangeMap.get(a)).map(p -> p[1]).orElse(0);
                int[] flats = Optional.ofNullable((int[])podFlatRangeMap.get(a)).orElse(new int[]{podFlatCount});
                podDatas.add(new AddressPodTableModel.PodData().setPodNumber(a).setFlatRangeFrom(Optional.ofNullable((int[])podRangeMap.get(a)).map(p -> p[0]).orElse(0)).setFlatRangeCount(podFlatCount).setFloorCount(Optional.ofNullable((int[])podFlatRangeMap.get(a)).map(p -> ((int[])p).length).orElse(1)).setFloorFlatRange(Arrays.stream(flats).mapToObj(Integer::toString).collect(Collectors.joining(","))));
            });
        }
        this.podTableModel.setData(podDatas);
        this.calcPodRange();
    }

    private String checkPodRanges() {
        StringBuilder str = new StringBuilder();
        for (AddressPodTableModel.PodData podData : this.podTableModel.getRows()) {
            str.append(str.length() > 0 ? ";" : "").append(podData.getPodNumber()).append(":").append(podData.getFlatRangeFrom()).append(":").append(podData.getFlatRangeCount());
        }
        return Utils.getDigest(str.toString(), "UTF-8", "SHA-256");
    }

    private String checkFloorRanges() {
        StringBuilder str = new StringBuilder();
        for (AddressPodTableModel.PodData podData : this.podTableModel.getRows()) {
            str.append(str.length() > 0 ? ";" : "").append(podData.getFloorCount()).append(":").append(podData.getFloorFlatRange());
        }
        return Utils.getDigest(str.toString(), "UTF-8", "SHA-256");
    }

    @Override
    public boolean doApply() throws Exception {
        if (this.entityTitle.getText().trim().length() == 0) {
            ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435");
            return false;
        }
        try {
            Stack<int[]> stack;
            if (!this.podDataHash.equals(this.checkPodRanges())) {
                int[] a2;
                stack = new Stack<int[]>();
                for (AddressPodTableModel.PodData podData : this.podTableModel.getRows()) {
                    if (podData.getFlatRangeFrom() <= 0 || podData.getFlatRangeCount() <= 0) continue;
                    if (!stack.empty() && (a2 = (int[])stack.peek())[2] == podData.getFlatRangeCount()) {
                        a2[1] = a2[1] + a2[2];
                        continue;
                    }
                    stack.push(new int[]{podData.getFlatRangeFrom(), podData.getFlatRangeFrom() + podData.getFlatRangeCount() - 1, podData.getFlatRangeCount(), podData.getPodNumber()});
                }
                Stack rstack = new Stack();
                while (!stack.empty()) {
                    rstack.push((int[])stack.pop());
                }
                StringBuilder entranceRange = new StringBuilder();
                while (!rstack.empty()) {
                    a2 = (int[])rstack.pop();
                    entranceRange.append(entranceRange.length() > 0 ? ";" : "").append(a2[0]).append("-").append(a2[1]).append("/").append(a2[2]).append("/").append(a2[3]);
                }
                AddressEntityParam addressEntityParam = this.paramTableModel.getRows().stream().filter(a -> a.getId().equals("entranceRange")).findFirst().orElse(null);
                if (addressEntityParam == null) {
                    this.paramTableModel.getRows().add(new AddressEntityParam().setId("entranceRange").setType("string").setTitle("\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u043f\u043e\u0434\u044a\u0435\u0437\u0434\u043e\u0432").setValue(entranceRange.toString()));
                } else {
                    addressEntityParam.setValue(entranceRange.toString());
                }
            }
            if (!this.floorDataHash.equals(this.checkFloorRanges())) {
                stack = new Stack();
                for (AddressPodTableModel.PodData podData : this.podTableModel.getRows()) {
                    if (podData.getFlatRangeFrom() > 0 && podData.getFlatRangeCount() <= 0) continue;
                }
                StringBuilder floorRange = new StringBuilder();
                AddressEntityParam addressEntityParam = this.paramTableModel.getRows().stream().filter(a -> a.getId().equals("floorRange")).findFirst().orElse(null);
                if (addressEntityParam == null) {
                    this.paramTableModel.getRows().add(new AddressEntityParam().setId("floorRange").setType("string").setTitle("\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u044d\u0442\u0430\u0436\u0435\u0439").setValue(floorRange.toString()));
                } else {
                    addressEntityParam.setValue(floorRange.toString());
                }
            }
            ((AddressEntityData)this.data).getEntityParams().clear();
            ((AddressEntityData)this.data).setParentId(this.street.getId());
            ((AddressEntityData)this.data).setTitle(this.entityTitle.getText());
            ((AddressEntityData)this.data).addEntityParameter("postIndex", this.postIndex.getText());
            ((AddressEntityData)this.data).addEntityParameter("areaId", String.valueOf(((IdTitle)this.area.getSelectedItem()).getId()));
            ((AddressEntityData)this.data).addEntityParameter("quarterId", String.valueOf(((IdTitle)this.quarter.getSelectedItem()).getId()));
            ((AddressEntityData)this.data).addEntityParameter("amount", this.amount.getText());
            ((AddressEntityData)this.data).addEntityParameter("podCount", this.podCount.getText());
            ((AddressEntityData)this.data).addEntityParameter("comment", this.comment.getText());
            ((AddressEntityData)this.data).addEntityParameter("latitude", this.coordinatesPanel.getLatitude());
            ((AddressEntityData)this.data).addEntityParameter("longitude", this.coordinatesPanel.getLongitude());
            ((AddressEntityData)this.data).setConfigParams(this.paramTableModel.getRows());
            this.getAddressService().addressEntityDataUpdate((AddressEntityData)this.data);
            return true;
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
            return false;
        }
    }

    public void setTitleLabelText(String text) {
        this.parentTitle.setText(text);
    }

    public void setStreet(Street street) {
        this.street = street;
    }

    private JPanel getTitlePanel() {
        Color bgColor = this.parentTitle.getBackground();
        Font font = this.parentTitle.getFont();
        this.parentTitle.setEditable(false);
        this.parentTitle.setBackground(bgColor);
        this.parentTitle.setFont(font.deriveFont(font.getSize2D() * 1.3f).deriveFont(1));
        this.parentTitle.setHorizontalAlignment(0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.parentTitle, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getHouseDataPanel() {
        this.postIndex.setMaxValue(999999L);
        this.entityTitle.setHorizontalAlignment(0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getHousePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getAreaAndQuarterPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        panel.add((Component)this.coordinatesPanel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getHousePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0414\u043e\u043c/\u0434\u0440\u043e\u0431\u044c:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u0418\u043d\u0434\u0435\u043a\u0441:"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041a\u0432\u0430\u0440\u0442\u0438\u0440:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041f\u043e\u0434\u044a\u0435\u0437\u0434\u043e\u0432:"), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.entityTitle, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.postIndex, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.amount, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.podCount, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getAreaAndQuarterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0420\u0430\u0439\u043e\u043d:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041a\u0432\u0430\u0440\u0442\u0430\u043b:"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add(this.area, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(this.quarter, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getParamPanel() {
        this.paramTable.setRowHeight(18);
        this.paramTable.setFont(new Font("Dialog", 0, 13));
        this.paramTable.setSelectionMode(0);
        BGSwingUtilites.handleMouseClicked(this.paramTable, e -> this.paramTableMouseClicked((MouseEvent)e));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)BGSwingUtilites.wrapScrollPane(this.paramTable, 800, 200), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getPodPanel() {
        BGSwingUtilites.handleRMouseClicked(this.podTable, e -> this.getPopupMenuPodTable().show(this.podTable, e.getX(), e.getY()));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)BGSwingUtilites.wrapScrollPane(this.podTable, 800, 200), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        return panel;
    }

    private int[] calcFloorFlats(int floorCount, int flatCount) {
        int[] qq = new int[floorCount];
        if (floorCount > 0) {
            int floorIndex = floorCount;
            int c = flatCount;
            for (int index = 0; index < floorCount; ++index) {
                int bb = c / floorIndex;
                int cc = c % floorIndex;
                int dd = bb + (cc > 0 ? 1 : 0);
                c -= dd;
                --floorIndex;
                qq[index] = dd;
            }
        }
        return qq;
    }

    private JPopupMenu getPopupMenuPodTable() {
        ActionListener floorActionListener = e -> {
            int floorCount = Utils.parseInt(((JMenuItem)e.getSource()).getText());
            this.podTableModel.getSelectedRows().forEach(a -> {
                a.setFloorCount(floorCount);
                int[] qq = this.calcFloorFlats(floorCount, a.getFlatRangeCount());
                a.setFloorFlatRange(Utils.toString(IntStream.of(qq).boxed().toList()));
            });
            this.calcPodRange();
        };
        JMenu floorMenu = new JMenu("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u044d\u0442\u0430\u0436\u0435\u0439");
        for (int i = 1; i < 13; ++i) {
            floorMenu.add(String.valueOf(i)).addActionListener(floorActionListener);
        }
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c").addActionListener(e -> {
            List<AddressPodTableModel.PodData> datas = this.podTableModel.getSelectedRows();
            if (datas.isEmpty()) {
                ClientUtils.showMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043e\u0434\u044a\u0435\u0437\u0434(\u044b)");
            } else {
                new PodFlatEditor("\u0420\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0435 \u043a\u0432\u0430\u0440\u0442\u0438\u0440 \u043f\u043e \u044d\u0442\u0430\u0436\u0430\u043c", datas).open();
            }
        });
        popupMenu.add(floorMenu);
        popupMenu.add("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043a\u0432\u0430\u0440\u0442\u0438\u0440 \u0432 \u043f\u043e\u0434\u044a\u0435\u0437\u0434\u0435 (\u0430\u0432\u0442\u043e)").addActionListener(e -> {
            this.podTableModel.getSelectedRows().forEach(a -> a.setFlatRangeCount(0));
            this.calcPodRange();
        });
        return popupMenu;
    }

    private void calcPodRange() {
        int flatCount = Utils.parseInt(this.amount.getText());
        int pod = Utils.parseInt(this.podCount.getText());
        if (flatCount > 0 && pod > 0) {
            int c = 0;
            for (AddressPodTableModel.PodData podData : this.podTableModel.getRows()) {
                if (c >= flatCount) {
                    podData.setFlatRangeFrom(0);
                    podData.setFlatRangeCount(0);
                } else {
                    podData.setFlatRangeFrom(c + 1);
                    if (c + podData.getFlatRangeCount() > flatCount) {
                        podData.setFlatRangeCount(flatCount - c);
                    } else if (podData.getFlatRangeCount() < 1 || podData.getPodNumber() == pod) {
                        int b;
                        int a;
                        int pc = 0;
                        int f = flatCount - c;
                        int p = pod - podData.getPodNumber() + 1;
                        if (f > 0 && p > 0 && (c + (pc = (a = f / p) + ((b = f % p) > 0 ? 1 : 0)) > flatCount || c + pc < flatCount && podData.getPodNumber() == pod)) {
                            pc = flatCount - c;
                        }
                        podData.setFlatRangeCount(pc);
                    }
                    c += podData.getFlatRangeCount();
                }
                if (podData.getFlatRangeCount() == Utils.toIntegerList(podData.getFloorFlatRange()).stream().reduce(0, Integer::sum).intValue()) continue;
                int[] qq = this.calcFloorFlats(podData.getFloorCount(), podData.getFlatRangeCount());
                podData.setFloorFlatRange(Utils.toString(IntStream.of(qq).boxed().toList()));
            }
        }
        this.podTableModel.fireTableDataChanged();
    }

    private void paramTableMouseClicked(MouseEvent event) {
        AddressEntityParam entityParam = (AddressEntityParam)this.paramTableModel.getSelectedRow();
        int col = this.paramTable.convertColumnIndexToModel(this.paramTable.columnAtPoint(event.getPoint()));
        if (entityParam != null && "date".equals(entityParam.getType()) && col == 3 && event.getClickCount() == 2) {
            JPopupMenu popupMenu = new JPopupMenu();
            CalendarPanel calendarPanel = new CalendarPanel();
            calendarPanel.setCalendar(TimeUtils.parseCalendar(entityParam.getValue(), "dd.MM.yyyy"));
            calendarPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            calendarPanel.addPropertyChangeListener(ce -> {
                if ("updateCalendar".equals(ce.getPropertyName())) {
                    entityParam.setValue(TimeUtils.format(calendarPanel.getCalendar(), "dd.MM.yyyy"));
                    popupMenu.setVisible(false);
                }
            });
            popupMenu.add(calendarPanel);
            popupMenu.show(event.getComponent(), event.getX(), event.getY());
        } else if (entityParam != null && "boolean".equals(entityParam.getType()) && col == 3 && event.getClickCount() == 2) {
            entityParam.setValue(String.valueOf(Boolean.valueOf(entityParam.getValue()) == false));
            this.paramTableModel.fireTableCellUpdated(this.paramTable.convertRowIndexToModel(this.paramTable.rowAtPoint(event.getPoint())), col);
        }
    }

    private final class CoordinatesPanel
    extends JPanel {
        private final JTextField latitude = new JTextField();
        private final JTextField longitude = new JTextField();

        private CoordinatesPanel() {
            this.setLayout(new GridBagLayout());
            this.add((Component)this.latitude, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
            this.add((Component)new JLabel("/"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
            this.add((Component)this.longitude, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
            JButton searchCoordinates = new JButton("\u041d\u0430\u0439\u0442\u0438 \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u044b");
            this.add((Component)searchCoordinates, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
            BGSwingUtilites.wrapBorder(this, "\u041a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u044b");
            AddressHouseEditor.this.tryCall(() -> searchCoordinates.setEnabled(AddressHouseEditor.this.getAddressService().checkGarPluginInstalled()));
            searchCoordinates.addActionListener(e -> {
                try {
                    HouseCoordinates coordinates = AddressHouseEditor.this.getAddressService().searchCoordinatesByHouseId(((AddressEntityData)AddressHouseEditor.this.data).getRecordId());
                    if (coordinates != null) {
                        this.latitude.setText(String.valueOf(coordinates.getLatitude()));
                        this.longitude.setText(String.valueOf(coordinates.getLongitude()));
                    }
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            });
        }

        void setCoordinates(AddressEntityData addressEntityData) {
            this.latitude.setText(Utils.maskNull(addressEntityData.getEntityParameter("latitude")));
            this.longitude.setText(Utils.maskNull(addressEntityData.getEntityParameter("longitude")));
        }

        String getLatitude() {
            return Utils.maskNull(this.latitude.getText());
        }

        String getLongitude() {
            return Utils.maskNull(this.longitude.getText());
        }
    }

    class PodFlatEditor
    extends BGEditorDialog<List<AddressPodTableModel.PodData>> {
        private BGIntTextField podFlatFrom;
        private BGIntTextField podFlatTo;
        private BGIntTextField podCount;
        private BGIntTextField podFloorCount;
        private PodFloorTableModel floorTableModel;

        public PodFlatEditor(String title, List<AddressPodTableModel.PodData> data) {
            super(title, data);
            this.podFlatFrom = new BGIntTextField(13);
            this.podFlatTo = new BGIntTextField(13);
            this.podCount = new BGIntTextField(30);
            this.podFloorCount = new BGIntTextField(30);
            this.floorTableModel = new PodFloorTableModel();
        }

        @Override
        public void doDialogPanel() {
            if (((List)this.data).size() == 1) {
                this.addFieldV("\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u043a\u0432\u0430\u0440\u0442\u0438\u0440 \u0432 \u043f\u043e\u0434\u044a\u0435\u0437\u0434\u0435:", this.getFlatRangePanel());
                AddressPodTableModel.PodData podData = (AddressPodTableModel.PodData)((List)this.data).get(0);
                this.podFlatFrom.setText(String.valueOf(podData.getFlatRangeFrom()));
                this.podFlatFrom.setEditable(false);
                this.podFlatTo.setText(String.valueOf(podData.getFlatRangeFrom() + podData.getFlatRangeCount() - 1));
                this.podFloorCount.setText(String.valueOf(((AddressPodTableModel.PodData)((List)this.data).get(0)).getFloorCount()));
            } else {
                this.addFieldV("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043a\u0432\u0430\u0440\u0442\u0438\u0440 \u0432 \u043f\u043e\u0434\u044a\u0435\u0437\u0434\u0435:", this.podCount);
                int count1 = ((AddressPodTableModel.PodData)((List)this.data).get(0)).getFlatRangeCount();
                boolean flag = ((List)this.data).stream().filter(a -> count1 != a.getFlatRangeCount()).findFirst().isEmpty();
                this.podCount.setText(flag ? String.valueOf(count1) : "");
                int count2 = ((AddressPodTableModel.PodData)((List)this.data).get(0)).getFloorCount();
                flag = ((List)this.data).stream().filter(a -> count2 != a.getFloorCount()).findFirst().isEmpty();
                this.podFloorCount.setText(flag ? String.valueOf(count2) : "");
            }
            this.addFieldV("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u044d\u0442\u0430\u0436\u0435\u0439 \u0432 \u043f\u043e\u0434\u044a\u0435\u0437\u0434\u0435:", this.podFloorCount);
            this.addFieldV("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043a\u0432\u0430\u0440\u0442\u0438\u0440 \u043d\u0430 \u044d\u0442\u0430\u0436\u0430\u0445:", this.getFloorsPanel());
            ActionListener actionListener = e -> this.setFloorData(null);
            this.podCount.addActionListener(actionListener);
            this.podFlatTo.addActionListener(actionListener);
            this.podFloorCount.addActionListener(actionListener);
            this.setFloorData(((AddressPodTableModel.PodData)((List)this.data).get(0)).getFloorFlatRange());
        }

        private void setFloorData(String range) {
            ArrayList<String[]> list = new ArrayList<String[]>();
            int floorCount = Utils.parseInt(this.podFloorCount.getText());
            if (floorCount > 0) {
                int[] aa = Utils.toIntArray(range);
                int c = ((List)this.data).size() == 1 ? Utils.parseInt(this.podFlatTo.getText()) - Utils.parseInt(this.podFlatFrom.getText()) + 1 : Utils.parseInt(this.podCount.getText());
                for (int index = 0; index < Utils.parseInt(this.podFloorCount.getText(), 1); ++index) {
                    int bb = c / floorCount;
                    int cc = c % floorCount;
                    int dd = bb + (cc > 0 ? 1 : 0);
                    c -= dd;
                    --floorCount;
                    list.add(new String[]{String.valueOf(index + 1), String.valueOf(aa.length > index ? aa[index] : dd)});
                }
            }
            this.floorTableModel.setData(list);
        }

        private JPanel getFlatRangePanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0441"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.podFlatFrom, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u043f\u043e"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.podFlatTo, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getFloorsPanel() {
            BGUTable table = new BGUTable(this.floorTableModel);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)BGSwingUtilites.wrapScrollPane(table, 300, 300), "Center");
            panel.add((Component)this.getButtonsPanel(), "South");
            return panel;
        }

        private JPanel getButtonsPanel() {
            ActionListener actionListener = e -> {
                String flatCount = e.getActionCommand();
                this.floorTableModel.getSelectedRows().forEach(a -> {
                    a[1] = flatCount;
                });
                this.floorTableModel.fireTableDataChanged();
            };
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041a\u0432\u0430\u0440\u0442\u0438\u0440 \u043d\u0430 \u044d\u0442\u0430\u0436\u0435: "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            for (int index = 0; index < 11; ++index) {
                JButton button = new JButton(String.valueOf(index));
                button.setMargin(new Insets(3, 5, 3, 5));
                button.addActionListener(actionListener);
                panel.add((Component)button, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            }
            return panel;
        }

        @Override
        public boolean doApply() throws Exception {
            int podFlatCount = 0;
            int floorCount = Utils.parseInt(this.podFloorCount.getText());
            if (((List)this.data).size() == 1) {
                int from = Utils.parseInt(this.podFlatFrom.getText());
                if (from < 1) {
                    BGToolTip.showErrorMessage(this.podFlatFrom, "\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u043e\u043c\u0435\u0440 \u043a\u0432\u0430\u0440\u0442\u0438\u0440\u044b");
                    return false;
                }
                int to = Utils.parseInt(this.podFlatTo.getText());
                if (to < 1) {
                    BGToolTip.showErrorMessage(this.podFlatTo, "\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u043e\u043c\u0435\u0440 \u043a\u0432\u0430\u0440\u0442\u0438\u0440\u044b");
                    return false;
                }
                if (from > to) {
                    BGToolTip.showErrorMessage(this.podFlatTo, "\u043d\u043e\u043c\u0435\u0440 \u043a\u0432\u0430\u0440\u0442\u0438\u0440\u044b \u043c\u0435\u043d\u044c\u0448\u0435 \u043d\u0430\u0447\u0430\u043b\u044c\u043d\u043e\u0433\u043e");
                    return false;
                }
                podFlatCount = to - from + 1;
                ((AddressPodTableModel.PodData)((List)this.data).get(0)).setFlatRangeFrom(from);
                ((AddressPodTableModel.PodData)((List)this.data).get(0)).setFlatRangeCount(to - from + 1);
                ((AddressPodTableModel.PodData)((List)this.data).get(0)).setFloorCount(floorCount > 0 ? floorCount : 1);
                ((AddressPodTableModel.PodData)((List)this.data).get(0)).setFloorFlatRange(this.floorTableModel.getRows().stream().map(a -> a[1]).collect(Collectors.joining(",")));
            } else {
                int count = Utils.parseInt(this.podCount.getText());
                ((List)this.data).forEach(a -> {
                    a.setFlatRangeCount(count);
                    a.setFloorCount(floorCount > 0 ? floorCount : 1);
                    a.setFloorFlatRange(this.floorTableModel.getRows().stream().map(r -> r[1]).collect(Collectors.joining(",")));
                });
                podFlatCount = count;
            }
            int floorFlatSum = this.floorTableModel.getRows().stream().map(a -> Utils.parseInt(a[1])).reduce(0, Integer::sum);
            if (floorFlatSum != podFlatCount) {
                ClientUtils.showErrorMessageDialog("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043a\u0432\u0430\u0440\u0442\u0438\u0440 \u0432 \u043f\u043e\u0434\u044a\u0435\u0437\u0434\u0435 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0441 \u0441\u0443\u043c\u043c\u043e\u0439 \u043a\u0432\u0430\u0440\u0442\u0438\u0440 \u043f\u043e \u044d\u0442\u0430\u0436\u0430\u043c");
                return false;
            }
            AddressHouseEditor.this.calcPodRange();
            AddressHouseEditor.this.podTableModel.fireTableDataChanged();
            return super.doApply();
        }
    }

    class PodFloorTableModel
    extends BGTableModel<String[]> {
        public PodFloorTableModel() {
            super(PodFloorTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u042d\u0442\u0430\u0436", 150, 150, 150, "floor", false, DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043a\u0432\u0430\u0440\u0442\u0438\u0440", 100, 100, -1, "count", false, DecimalTableCellRenderer.INTEGER());
        }

        @Override
        public Object getValue(String[] val, int columnIndex) throws Exception {
            String identifier = this.getIdentifier(columnIndex);
            if ("floor".equals(identifier)) {
                return Utils.parseInt(val[0]);
            }
            if ("count".equals(identifier)) {
                return Utils.parseInt(val[1]);
            }
            return super.getValue(val, columnIndex);
        }
    }
}

