/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius;

import bitel.billing.server.util.RequestCounter;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.system.ModuleConfigModifiedEvent;
import ru.bitel.bgbilling.kernel.network.processor.Processor;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusSession;
import ru.bitel.bgbilling.kernel.network.radius.RadiusUtils;
import ru.bitel.bgbilling.kernel.network.radius.eap.EAPTLSAuthenticator;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasList;
import ru.bitel.bgbilling.kernel.network.tlv.Tlv;
import ru.bitel.bgbilling.modules.call.server.event.NasListModifiedEvent;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.jmx.MBeanAttribute;
import ru.bitel.common.logging.BGNestedContext;
import ru.bitel.common.sql.ConnectionSet;

public abstract class RadiusProcessor<C extends NasConnection<?>, N extends Nas<C, ?, ?>, P>
extends Processor {
    public final RequestCounter accountingStartCounter = new RequestCounter(60);
    public final RequestCounter accountingStopCounter = new RequestCounter(60);
    public final RequestCounter accountingUpdateCounter = new RequestCounter(60);
    public final RequestCounter authenticationAcceptCounter = new RequestCounter(60);
    public final RequestCounter authenticationRejectCounter = new RequestCounter(60);
    public final RequestCounter authenticationIgnoreCount = new RequestCounter(60);
    public final RequestCounter accountingIgnoreCount = new RequestCounter(60);
    public final RequestCounter accountingUpdateIgnoreCount = new RequestCounter(60);
    public final RequestCounter antispamIgnoreCount = new RequestCounter(60);
    private final Map<RadiusSession.State, RadiusSession<N, P>> sessionMap = new ConcurrentHashMap<RadiusSession.State, RadiusSession<N, P>>();
    protected final Setup setup;
    protected final String module;
    protected final NasList<C, N> nasList;
    protected volatile boolean forwardAfterPreprocess;
    protected volatile boolean forwardAfterProcess;
    protected volatile boolean forwardAccessRequest;
    protected volatile boolean forwardAccessAnswer;
    protected volatile boolean forwardAccountingResponse;

    @Deprecated
    public RadiusProcessor(Setup setup, String module, int mid, NasList<C, N> nasList) throws BGException {
        this(setup, module, mid, nasList, true, true);
    }

    public RadiusProcessor(Setup setup, String module, final int moduleId, NasList<C, N> nasList, boolean loadNasList, boolean linkReload) throws BGException {
        super(SetupParam.getApplicationId((ParameterMap)setup), setup, moduleId);
        this.setup = setup;
        this.module = module;
        this.nasList = nasList;
        EAPTLSAuthenticator.init(setup);
        if (loadNasList) {
            this.reloadNasList();
        }
        setup.getScheduledExecutorService().scheduleAtFixedRate(new RadiusSessionCleaner(), 105L, 105L, TimeUnit.SECONDS);
        if (linkReload) {
            EventProcessor.getInstance().addListener(new EventListener<ModuleConfigModifiedEvent>(){

                @Override
                public void notify(ModuleConfigModifiedEvent e, EventListenerContext ctx) {
                    if (e.getModuleId() == 0 || e.getModuleId() == moduleId) {
                        RadiusProcessor.this.reloadConfig();
                        RadiusProcessor.this.reloadNasList();
                        RadiusProcessor.this.afterNasListReload();
                    }
                }
            }, ModuleConfigModifiedEvent.class);
            EventProcessor.getInstance().addListener(new EventListener<NasListModifiedEvent>(){

                @Override
                public void notify(NasListModifiedEvent e, EventListenerContext ctx) {
                    if (e.getModuleId() == moduleId) {
                        RadiusProcessor.this.reloadNasList();
                        RadiusProcessor.this.afterNasListReload();
                    }
                }
            }, NasListModifiedEvent.class, moduleId, null);
        }
        this.initOptions(setup, moduleId);
    }

    private void initOptions(Setup setup, int moduleId) {
        ModuleSetup moduleSetup = setup.getModuleSetup(moduleId);
        if (moduleSetup != null) {
            this.forwardAfterPreprocess = moduleSetup.getBoolean("radius.forward.after.preprocess", setup.getBoolean("radius.forward.after.preprocess", false));
            this.forwardAfterProcess = moduleSetup.getBoolean("radius.forward.after.process", setup.getBoolean("radius.forward.after.process", false));
            this.forwardAccessRequest = moduleSetup.getBoolean("radius.forward.access.request", setup.getBoolean("radius.forward.access.request", false));
            this.forwardAccessAnswer = moduleSetup.getBoolean("radius.forward.access.answer", setup.getBoolean("radius.forward.access.answer", false));
            this.forwardAccountingResponse = moduleSetup.getBoolean("radius.forward.accounting.response", setup.getBoolean("radius.forward.accounting.response", false));
        } else {
            this.forwardAfterPreprocess = setup.getBoolean("radius.forward.after.preprocess", false);
            this.forwardAfterProcess = setup.getBoolean("radius.forward.after.process", false);
            this.forwardAccessRequest = setup.getBoolean("radius.forward.access.request", false);
            this.forwardAccessAnswer = setup.getBoolean("radius.forward.access.answer", false);
            this.forwardAccountingResponse = setup.getBoolean("radius.forward.accounting.response", false);
        }
        this.getLogger().info(String.format("forwardAfterPreprocess = %s \nforwardAfterProcess = %s \n forwardAccessRequest = %s \nforwardAccessAnswer = %s \n forwardAccountingResponse = %s", this.forwardAfterPreprocess, this.forwardAfterProcess, this.forwardAccessRequest, this.forwardAccessAnswer, this.forwardAccountingResponse));
    }

    protected void reloadConfig() {
        BGNestedContext.push((String)"processor");
        try {
            this.getLogger().info("Reloading config");
            Setup.getSetup().reloadConfig(this.moduleId);
            this.initOptions(this.setup, this.moduleId);
        }
        finally {
            BGNestedContext.pop();
        }
    }

    protected void reloadNasList() {
        BGNestedContext.push((String)"processor");
        try {
            this.getLogger().info("Reloading nas list");
            Connection con = this.setup.getDBConnectionFromPool();
            try {
                this.nasList.load(this.setup, this, con, this.moduleId);
            }
            finally {
                ServerUtils.closeConnection(con);
            }
        }
        finally {
            BGNestedContext.pop();
        }
    }

    protected void afterNasListReload() {
    }

    protected N getNas(SocketAddress clientAddress, RadiusPacket packet) {
        Object nasIP;
        N nas = null;
        RadiusAttribute.RadiusAttributeString nasIdentifier = (RadiusAttribute.RadiusAttributeString)packet.getAttribute(-1, 32);
        if (nasIdentifier != null) {
            nas = this.nasList.get((String)nasIdentifier.getValue());
        }
        if (nas == null && (nasIP = packet.getAttribute(-1, 4)) != null) {
            try {
                nas = this.nasList.get(InetAddress.getByAddress(((Tlv)nasIP).getDataAsByteArray()));
            }
            catch (UnknownHostException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
        }
        if (nas == null && (nasIP = packet.getAttribute(-1, 95)) != null) {
            try {
                nas = this.nasList.get(InetAddress.getByAddress(((Tlv)nasIP).getDataAsByteArray()));
            }
            catch (UnknownHostException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
        }
        if (nas == null && clientAddress instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)clientAddress;
            nas = this.nasList.get(address.getAddress());
        }
        return nas;
    }

    public NasList<C, N> getNasList() {
        return this.nasList;
    }

    public final Iterable<C> connections() {
        return this.nasList.connections();
    }

    public abstract String executeCommand(String var1, String var2);

    public void processConnections(ConnectionIterator<C, N> iterator) {
        block0: for (Nas nas : this.nasList.nases()) {
            for (NasConnection con : nas.connections()) {
                if (iterator.processConnection(nas, con)) continue;
                break block0;
            }
        }
    }

    protected void preprocessAccessRequest(N nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet) {
        ((Nas)nas).getScript().preprocessAccessRequest.processRequest(request, response, connectionSet.getConnection(), connectionSet.getSlaveConnection(), this.setup);
    }

    protected void preprocessAccountingRequest(N nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet) {
        ((Nas)nas).getScript().preprocessAccountingRequest.processRequest(request, response, connectionSet.getConnection(), connectionSet.getSlaveConnection(), this.setup);
    }

    protected void postprocessAccessRequest(N nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet) {
        ((Nas)nas).getScript().postprocessAccessRequest.processRequest(request, response, connectionSet.getConnection(), connectionSet.getSlaveConnection(), this.setup);
    }

    protected void postprocessAccountingRequest(N nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet) {
        ((Nas)nas).getScript().postprocessAccountingRequest.processRequest(request, response, connectionSet.getConnection(), connectionSet.getSlaveConnection(), this.setup);
    }

    protected int insertToLog(Date date, RadiusPacket packet) {
        return RadiusUtils.insertToLog(this.setup, this.moduleId, packet, date);
    }

    protected void addToLog(Date date, RadiusPacket packet, int recordId) {
        RadiusUtils.addToLog(this.setup, this.moduleId, packet, date, recordId);
    }

    public void accessRequest(RadiusListenerWorker<N> req, N nas, int logRecordId, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet) throws BGException {
        RadiusSession<N, P> radiusSession;
        this.preprocessAccessRequest(nas, request, response, connectionSet);
        Object stateAttribute = request.getAttribute(-1, 24);
        RadiusSession.State state = stateAttribute != null ? new RadiusSession.State(((Tlv)stateAttribute).getDataAsByteArray()) : null;
        Date date = new Date();
        if (logRecordId <= 0) {
            logRecordId = this.insertToLog(date, request);
        }
        if ((radiusSession = this.getRadiusSession(request, state)) == null) {
            this.getLogger().debug("Create new radius session.");
            radiusSession = this.newRadiusSession(connectionSet.getConnection(), nas, request, state);
            radiusSession.killTime = System.currentTimeMillis() + 8000L;
            if (radiusSession.stateAttribute != null) {
                this.sessionMap.put(new RadiusSession.State(radiusSession.stateAttribute), radiusSession);
            }
        } else {
            radiusSession.killTime = System.currentTimeMillis() + 8000L;
        }
        req.radiusSession = radiusSession;
        this.accessRequestImpl(req, nas, request, response, date, radiusSession, logRecordId, connectionSet);
        if (radiusSession.stateAttribute != null) {
            response.setAttribute(new RadiusAttribute(-1, 24, ByteBuffer.wrap(radiusSession.stateAttribute)));
        }
        if (this.forwardAfterProcess && this.forwardAccessRequest) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Forward access request after processing. Packet: " + request.toString());
            }
            ((Nas)nas).fanoutPacket(req, request);
        }
        if (this.forwardAfterProcess && this.forwardAccessAnswer) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Forward access answer after processing. Packet: " + response.toString());
            }
            ((Nas)nas).fanoutPacket(req, response);
        }
        this.postprocessAccessRequest(nas, request, response, connectionSet);
        this.addToLog(date, response, logRecordId);
    }

    protected void accessRequestImpl(RadiusListenerWorker<N> req, N nas, RadiusPacket request, RadiusPacket response, Date date, RadiusSession<N, P> radiusSession, int logRecordId, ConnectionSet connectionSet) {
        radiusSession.accessRequest(this, req, nas, request, response, connectionSet, logRecordId);
    }

    private RadiusSession<N, P> getRadiusSession(RadiusPacket request, RadiusSession.State state) {
        Object uName;
        RadiusSession<N, P> session = null;
        if (state != null && (session = this.sessionMap.get(state)) != null && (uName = request.getAttribute(-1, 1)) == null) {
            request.setAttribute(session.userNameAttribute.clone());
        }
        return session;
    }

    protected abstract RadiusSession<N, P> newRadiusSession(Connection var1, N var2, RadiusPacket var3, RadiusSession.State var4);

    public C accountingRequest(RadiusListenerWorker<N> req, N nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, Date time) {
        if (!this.forwardAfterProcess && !this.forwardAfterPreprocess) {
            ((Nas)nas).fanoutPacket(req, request);
        }
        this.preprocessAccountingRequest(nas, request, response, connectionSet);
        if (req.isSkip()) {
            this.getLogger().info("Skip flag is true. Skip packet");
            return null;
        }
        if (!this.forwardAfterProcess && this.forwardAfterPreprocess) {
            ((Nas)nas).fanoutPacket(req, request);
        }
        C result = this.accounting(req, nas, request, response, connectionSet, time);
        if (this.forwardAfterProcess) {
            ((Nas)nas).fanoutPacket(req, request);
        }
        if (this.forwardAfterProcess && this.forwardAccountingResponse) {
            this.getLogger().info("Add accounting response packet to queue for forwarding");
            ((Nas)nas).fanoutPacket(req, response);
        }
        this.postprocessAccountingRequest(nas, request, response, connectionSet);
        return result;
    }

    protected abstract int authentication(RadiusListenerWorker<?> var1, N var2, RadiusSession<N, P> var3, RadiusPacket var4, RadiusPacket var5, ConnectionSet var6, int var7);

    protected abstract int authorization(RadiusListenerWorker<?> var1, N var2, RadiusSession<N, P> var3, RadiusPacket var4, RadiusPacket var5, ConnectionSet var6, int var7, Contract var8, Object var9, String var10);

    protected C accounting(RadiusListenerWorker<N> req, N nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, Date time) {
        int acctStatusType = request.getIntAttribute(-1, 40, 0);
        C result = switch (acctStatusType) {
            case 1 -> ((Nas)nas).startConnection(req, request, response, connectionSet, time);
            case 2 -> ((Nas)nas).stopConnection(req, request, response, connectionSet);
            case 3 -> ((Nas)nas).updateConnection(req, request, response, connectionSet);
            default -> null;
        };
        response.setCode((byte)5);
        return result;
    }

    public static RadiusProcessor<?, Nas<?, ?, ?>, ?> newInstance(Class<? extends RadiusProcessor> clazz, Setup setup, int moduleId) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return clazz.getConstructor(Setup.class, Integer.TYPE).newInstance(new Object[]{setup, moduleId});
    }

    protected List<C> getConnectionList() {
        ArrayList<NasConnection> result = new ArrayList<NasConnection>();
        for (Nas nas : this.nasList.nases()) {
            for (NasConnection con : nas.connections()) {
                result.add(con);
            }
        }
        return result;
    }

    public abstract String getStatus();

    private int getConnectionsCount(NasConnection.Status status) {
        int result = 0;
        for (Nas nas : this.nasList.nases()) {
            for (NasConnection con : nas.connections()) {
                if (con.getStatus() != status) continue;
                ++result;
            }
        }
        return result;
    }

    @MBeanAttribute
    public int getActiveConnectionsCount() {
        return this.getConnectionsCount(NasConnection.Status.working);
    }

    @MBeanAttribute
    public int getSuspendedConnectionCount() {
        return this.getConnectionsCount(NasConnection.Status.suspended);
    }

    @MBeanAttribute
    public int getStoppedConnectionCount() {
        return this.getConnectionsCount(NasConnection.Status.stopped);
    }

    @MBeanAttribute
    public int getAccountingStartPerMinute() {
        return this.accountingStartCounter.getCount();
    }

    @MBeanAttribute
    public int getAccountingStopPerMinute() {
        return this.accountingStopCounter.getCount();
    }

    @MBeanAttribute
    public int getAccountingUpdatePerMinute() {
        return this.accountingUpdateCounter.getCount();
    }

    @MBeanAttribute
    public int getAccessAcceptPerMinute() {
        return this.authenticationAcceptCounter.getCount();
    }

    @MBeanAttribute
    public int getAccessRejectPerMinute() {
        return this.authenticationRejectCounter.getCount();
    }

    @MBeanAttribute
    public int getAccessRequestIgnorePerMinute() {
        return this.authenticationIgnoreCount.getCount();
    }

    @MBeanAttribute
    public int getAccountingUpdateIgnorePerMinute() {
        return this.accountingUpdateIgnoreCount.getCount();
    }

    @MBeanAttribute
    public int getAntispamIgnorePerMinute() {
        return this.antispamIgnoreCount.getCount();
    }

    class RadiusSessionCleaner
    implements Runnable {
        RadiusSessionCleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BGNestedContext.push((String)"radius");
            try {
                long time = System.currentTimeMillis();
                Iterator i = RadiusProcessor.this.sessionMap.entrySet().iterator();
                while (i.hasNext()) {
                    if (time <= i.next().getValue().killTime) continue;
                    i.remove();
                }
                if (RadiusProcessor.this.getLogger().isDebugEnabled()) {
                    RadiusProcessor.this.getLogger().debug("After clean old rad sessions: " + RadiusProcessor.this.sessionMap.size());
                }
            }
            finally {
                BGNestedContext.pop();
            }
        }
    }

    public static interface ConnectionIterator<C extends NasConnection<?>, N extends Nas<C, ?, ?>> {
        public boolean processConnection(N var1, C var2);
    }
}

