/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.admin.resource;

import bitel.billing.module.admin.resource.NumberResourceCategoriesTreePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.LocalDate;
import java.util.Calendar;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGControlPanelDateNoB;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class NumberResourceSelectPanel
extends BGPanel {
    private NumberResourceCategoriesTreePanel categoriesTree = new NumberResourceCategoriesTreePanel(false);
    private BGTextField fromNumber = new BGTextField();
    private BGTextField toNumber = new BGTextField();
    private BGControlPanelDateNoB date = new BGControlPanelDateNoB();
    private DefaultListModel<BGUListItem> resultModel = new DefaultListModel();
    private JList<BGUListItem> result = new JList<BGUListItem>(this.resultModel);
    private JLabel countLabel = new JLabel();
    private ActionListener actionListener;

    public NumberResourceSelectPanel() {
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        JPanel numRangePanel = new JPanel(new GridBagLayout());
        numRangePanel.add((Component)new JLabel("\u0421"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        numRangePanel.add((Component)this.fromNumber, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        numRangePanel.add((Component)new JLabel("\u041f\u041e"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        numRangePanel.add((Component)this.toNumber, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        JButton goButton = new JButton("\u0412\u044b\u0432\u0435\u0441\u0442\u0438");
        goButton.addActionListener(e -> this.trySetData());
        JPanel goPanel = new JPanel(new GridBagLayout());
        goPanel.add((Component)new JLabel("\u041d\u0430 \u0434\u0430\u0442\u0443:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        goPanel.add((Component)this.date, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        goPanel.add((Component)goButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        JPanel countPanel = new JPanel(new GridBagLayout());
        JLabel countText = new JLabel("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u043e \u043d\u043e\u043c\u0435\u0440\u043e\u0432: ");
        countPanel.add((Component)countText, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        countPanel.add((Component)this.countLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.addActionListener(e -> this.stopSelect(e.getActionCommand().equals("ok")));
        this.date.setLocalDate(LocalDate.now());
        this.add((Component)this.categoriesTree, new GridBagConstraints(0, 0, 1, 5, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)numRangePanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)goPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)new JScrollPane(this.result), new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)countPanel, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)okCancel, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
    }

    public void init(int mid) {
        super.init("admin.resource", mid);
        this.categoriesTree.init("admin.resource", mid);
        this.categoriesTree.setData();
    }

    @Override
    public void setData() throws Exception {
        String date = this.date.getDateString();
        if (Utils.isBlankString(date)) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0430\u0442\u0443");
            return;
        }
        String categoryId = this.categoriesTree.getSelectedId();
        if (Utils.isBlankString(categoryId)) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e");
            return;
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("FreeNumberResourceList");
        request.setModuleId(this.getModuleId());
        request.setAttribute("date", date);
        request.setAttribute("category_id", categoryId);
        request.setAttribute("from_number", this.fromNumber.getText());
        request.setAttribute("to_number", this.toNumber.getText());
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            ClientUtils.buildList(this.result, this.resultModel, XMLUtils.selectElement(doc, "//list"));
            this.countLabel.setText(String.valueOf(this.resultModel.getSize()));
        }
    }

    public void setDate(Calendar date) {
        this.date.setDateCalendar(date);
    }

    public Calendar getDate() {
        return this.date.getDateCalendar();
    }

    public String getNumber() {
        return ClientUtils.getIdFromList(this.result);
    }

    public void setActionListener(ActionListener value) {
        this.actionListener = value;
    }

    private void stopSelect(boolean ok) {
        if (ok) {
            if (this.date.getDateCalendar() == null) {
                ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u0434\u0430\u0442\u0430");
                return;
            }
            if (this.result.getSelectedIndex() < 0) {
                ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u043d\u043e\u043c\u0435\u0440");
                return;
            }
            this.actionListener.actionPerformed(new ActionEvent(this, 0, "ok"));
        } else {
            this.actionListener.actionPerformed(new ActionEvent(this, 0, "cancel"));
        }
    }
}

