/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.security.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.GroupRight;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.RightType;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserRightRule;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserRightRuleAction;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserRightRuleService;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.GroupRightDao;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.UserRightRuleDao;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.bean.ModuleManager;
import ru.bitel.common.XMLUtils;

public class SynchronizeXmlActionWithDatabase {
    private final Logger logger = LogManager.getLogger();

    protected SynchronizeXmlActionWithDatabase(Connection connection) {
        this.sync(connection);
    }

    private void sync(Connection con) {
        this.logger.info("Synchronization xml actions with database");
        File actionsCatalog = new File("actions");
        if (!actionsCatalog.exists() || !actionsCatalog.isDirectory()) {
            this.logger.error("Catalog BGBillingServer/actions not found!");
            return;
        }
        GroupRightDao groupRightDao = new GroupRightDao(con);
        UserRightRuleDao userRightRuleDao = new UserRightRuleDao(con);
        File kernelActions = new File(actionsCatalog, "kernel.xml");
        try {
            GroupRight groupRight = new GroupRight();
            groupRight.setParentId(0);
            groupRight.setTitle("\u042f\u0434\u0440\u043e");
            groupRight.setModuleId(0);
            groupRight.setType(RightType.SYSTEM);
            groupRightDao.update((Object)groupRight);
            Document doc = XMLUtils.parseDocument((InputSource)new InputSource(new FileInputStream(kernelActions)));
            for (Element groupElement : XMLUtils.selectElements((Node)doc, (String)"/actions/group")) {
                this.syncGroup(groupRight.getId(), 0, groupElement, groupRightDao, userRightRuleDao);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        ModuleManager moduleManager = new ModuleManager(con);
        try {
            for (BGModule module : moduleManager.getModules(null)) {
                File moduleActions = new File(actionsCatalog, module.getName() + ".xml");
                if (!moduleActions.exists()) {
                    this.logger.error(moduleActions.getPath() + " - \u0444\u0430\u0439\u043b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!!!");
                    continue;
                }
                try {
                    GroupRight groupRight = new GroupRight();
                    groupRight.setParentId(0);
                    groupRight.setTitle("\u041c\u043e\u0434\u0443\u043b\u044c " + module.getTitle());
                    groupRight.setModuleId(module.getId());
                    groupRight.setType(RightType.SYSTEM);
                    groupRightDao.update((Object)groupRight);
                    Document doc = XMLUtils.parseDocument((InputSource)new InputSource(new FileInputStream(moduleActions)));
                    for (Element groupElement : XMLUtils.selectElements((Node)doc, (String)"/actions/group")) {
                        this.syncGroup(groupRight.getId(), module.getId(), groupElement, groupRightDao, userRightRuleDao);
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)e);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    private void syncGroup(int parentId, int moduleId, Element element, GroupRightDao groupRightDao, UserRightRuleDao userRightRuleDao) throws Exception {
        String title = element.getAttribute("title");
        GroupRight groupRight = new GroupRight();
        groupRight.setParentId(parentId);
        groupRight.setTitle(title);
        groupRight.setModuleId(moduleId);
        groupRight.setType(RightType.SYSTEM);
        groupRightDao.update((Object)groupRight);
        for (Element serviceElement : XMLUtils.selectElements((Node)element, (String)"service")) {
            this.syncRule(groupRight.getId(), moduleId, serviceElement, userRightRuleDao);
        }
        for (Element actionElement : XMLUtils.selectElements((Node)element, (String)"action")) {
            this.syncRule(groupRight.getId(), moduleId, actionElement, userRightRuleDao);
        }
        for (Element groupElement : XMLUtils.selectElements((Node)element, (String)"group")) {
            this.syncGroup(groupRight.getId(), moduleId, groupElement, groupRightDao, userRightRuleDao);
        }
    }

    private void syncRule(int groupId, int moduleId, Element element, UserRightRuleDao userRightRuleDao) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        UserRightRule userRightRule = new UserRightRule().setModuleId(moduleId).setRightGroupId(groupId).setTitle(element.getAttribute("title"));
        if ("service".equals(element.getNodeName())) {
            UserRightRuleService rightRuleService = new UserRightRuleService();
            rightRuleService.setName(element.getAttribute("name"));
            rightRuleService.setOperation(element.getAttribute("operation"));
            userRightRule.setRule(mapper.writeValueAsString((Object)rightRuleService));
        } else if ("action".equals(element.getNodeName())) {
            UserRightRuleAction rightRuleAction = new UserRightRuleAction();
            rightRuleAction.setMask(element.getAttribute("mask"));
            userRightRule.setRule(mapper.writeValueAsString((Object)rightRuleAction));
        }
        userRightRuleDao.update(userRightRule);
    }
}

