/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.base.ActionBase;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffGroup;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.ContractTariffDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.ContractTariffGroupDao;
import ru.bitel.bgbilling.kernel.contract.label.server.bean.ContractLabelManager;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffGroup;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffGroupTariff;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffGroupDao;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffPlanDao;
import ru.bitel.common.TimeUtils;

public class ActionContractTariffPlan
extends ActionBase {
    @Override
    public void doAction() throws Exception {
        int id = this.getIntParameter("id", -1);
        if (id < -1) {
            throw new BGIllegalArgumentException();
        }
        int tpid = 0;
        if (id > 0) {
            ContractTariffDao contractTariffDao = new ContractTariffDao(this.con);
            ContractTariff contractPlan = (ContractTariff)contractTariffDao.get(id);
            tpid = contractPlan.getTariffPlanId();
            Element tariffPlan = this.createElement(this.rootNode, "tariffPlan");
            tariffPlan.setAttribute("tpid", String.valueOf(tpid));
            tariffPlan.setAttribute("date1", TimeUtils.formatDate((Date)contractPlan.getPeriod().getDateFrom()));
            tariffPlan.setAttribute("date2", TimeUtils.formatDate((Date)contractPlan.getPeriod().getDateTo()));
            tariffPlan.setAttribute("comment", contractPlan.getComment());
            tariffPlan.setAttribute("pos", String.valueOf(contractPlan.getPosition()));
        }
        int moduleId = this.getIntParameter("mid", -1);
        boolean showUsed = this.getIntParameter("showUsed", 0) == 1;
        boolean useFilter = this.getIntParameter("useFilter", 0) == 1;
        boolean tariffGroupFilter = this.getIntParameter("tariffGroupFilter", 0) == 1;
        Element plansElement = this.createElement(this.rootNode, "tariffPlans");
        if (!useFilter) {
            this.listAvaliableTariffPlans(plansElement, tpid, showUsed, tariffGroupFilter, moduleId);
        } else {
            if (this.cid < 0) {
                return;
            }
            Contract contract = ContractDao.getContract(this.con, this.cid);
            List<Integer> contractLabelIds = new ContractLabelManager(this.con).getContractLabelIds(this.cid);
            this.listAvaliableTariffPlans(plansElement, tpid, showUsed, moduleId, contractLabelIds, contract.getPersonType(), contract.getTitle(), tariffGroupFilter);
        }
    }

    private void listAvaliableTariffPlans(Element element, int defaultID, boolean getUsed, boolean tariffGroupFilter, int mid) throws Exception {
        try (TariffPlanDao planManager = new TariffPlanDao(this.con);
             TariffGroupDao tariffGroupDao = new TariffGroupDao(this.con);){
            for (TariffPlan plan : planManager.list()) {
                if (plan.getId() != defaultID && (getUsed && !plan.isUsed() || !planManager.usesModule(plan.getId(), mid) && mid >= 0 || tariffGroupFilter && !this.isPlanInContractTariffGroup(plan, tariffGroupDao))) continue;
                this.addListItem((Node)element, plan.getId(), plan.getTitle());
            }
        }
    }

    private void listAvaliableTariffPlans(Element element, int defaultID, boolean getUsed, int moduleId, List<Integer> contracLabelIds, int face, String title, boolean tariffGroupFilter) throws Exception {
        try (TariffPlanDao planManager = new TariffPlanDao(this.con);
             TariffGroupDao tariffGroupDao = new TariffGroupDao(this.con);){
            for (TariffPlan plan : planManager.getTariffPlanList(defaultID, contracLabelIds, face, title)) {
                if (plan.getId() != defaultID && (getUsed && !plan.isUsed() || !planManager.usesModule(plan.getId(), moduleId) && moduleId >= 0 || tariffGroupFilter && !this.isPlanInContractTariffGroup(plan, tariffGroupDao))) continue;
                this.addListItem((Node)element, plan.getId(), plan.getTitle());
            }
        }
    }

    private boolean isPlanInContractTariffGroup(TariffPlan plan, TariffGroupDao tariffGroupDao) throws Exception {
        boolean result = false;
        Date dt = new Date();
        ContractTariffGroup contractTariffGroup = (ContractTariffGroup)new ContractTariffGroupDao(this.con).get(this.cid);
        if (contractTariffGroup != null) {
            TariffGroup tariffGroup = tariffGroupDao.getTariffGroupById(contractTariffGroup.getTariffGroupId());
            List<TariffGroupTariff> tariffGroupItems = tariffGroup.getPlanList();
            for (TariffGroupTariff tariffItem : tariffGroupItems) {
                if (!TimeUtils.dateInRange((Date)dt, (Date)tariffItem.getDate1(), (Date)tariffItem.getDate2()) || tariffItem.getId() != plan.getId()) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

