/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.client.runner.BGClientRunnerUtil;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class ClientSetup
extends Preferences {
    private static ClientSetup setup;
    private static Object mutex;
    private int userId = 0;
    protected Preferences userProperties = new Preferences();
    private Map<String, Preferences> modulesParametrs;
    private Map<String, Preferences> pluginsParametrs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initSetup(URL url) {
        Object object = mutex;
        synchronized (object) {
            if (setup == null) {
                setup = new ClientSetup(url);
                setup.loadUserConfig();
                int configId = setup.getUserConfig().getInt("local.config.id", 0);
                if (configId > 0) {
                    String config = ClientSetup.getLocalConfig(configId);
                    try {
                        setup.loadData(config, "\n");
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog(ex);
                    }
                }
            }
        }
    }

    public static ClientSetup getInstance() {
        return setup;
    }

    private ClientSetup(URL url) {
        super(url);
    }

    @Override
    public String get(String key, String def) {
        String result;
        if (this.userProperties != null && (result = this.userProperties.get(key, null)) != null) {
            return result;
        }
        return super.get(key, def);
    }

    public void loadUserConfig() {
        Preferences properties = new Preferences();
        File file = BGClientRunnerUtil.getLocalSettingsFile();
        if (file != null) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    int pos = line.indexOf(61);
                    if (pos < 0 && pos >= line.length()) continue;
                    String key = line.substring(0, pos);
                    String value = line.substring(pos + 1);
                    properties.set(key, value);
                }
                reader.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.userProperties = properties;
    }

    public void saveUserConfig() {
        Preferences properties = this.getUserConfig();
        try {
            File file = BGClientRunnerUtil.getLocalSettingsFile();
            if (file != null && file.canWrite()) {
                OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
                if (properties != null) {
                    ArrayList<String> keys = new ArrayList<String>();
                    for (Map.Entry<String, String> e : properties.entrySet()) {
                        keys.add(e.getKey());
                    }
                    Collections.sort(keys);
                    for (String key : keys) {
                        fileWriter.write(key);
                        fileWriter.write("=");
                        fileWriter.write(properties.get(key));
                        fileWriter.write("\n");
                    }
                }
                fileWriter.flush();
                fileWriter.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void putAll(Map<String, String> map) {
        this.data.putAll(map);
    }

    public void removeAllWithPrefix(String prefix) {
        Iterator iter = this.data.keySet().iterator();
        while (iter.hasNext()) {
            if (!((String)iter.next()).startsWith(prefix)) continue;
            iter.remove();
        }
    }

    public void removeAllWithPrefixFromUserConfig(String prefix) {
        Preferences props = this.getUserConfig();
        Iterator<Map.Entry<String, String>> it = props.entrySet().iterator();
        while (it.hasNext()) {
            if (!it.next().getKey().startsWith(prefix)) continue;
            it.remove();
        }
    }

    public Preferences getUserConfig() {
        return this.userProperties;
    }

    public List<String> getUserEmail(String key) {
        String userEmailOther = this.get(key + ".email", "");
        String userEmail = this.get("user.email", null);
        ArrayList<String> emailList = new ArrayList<String>();
        List<String> list = null;
        if (Utils.notBlankString(userEmailOther)) {
            list = Utils.toList(userEmailOther);
        }
        if (Utils.notBlankString(userEmail)) {
            emailList.add(userEmail);
            if (list != null && list.size() > 0) {
                for (String email : list) {
                    if (email.equals(userEmail)) continue;
                    emailList.add(email);
                }
            }
        } else if (list != null && list.size() > 0) {
            emailList.addAll(list);
        }
        return emailList;
    }

    public void saveUserEmail(String key, List<String> emailList) {
        String userEmail = this.get("user.email", null);
        StringBuilder sb = new StringBuilder();
        for (String email : emailList) {
            if (email.equals(userEmail)) continue;
            sb.append(email);
        }
        this.getUserConfig().set(key + ".email", sb.toString());
        this.saveUserConfig();
    }

    @Override
    public ParameterMap sub(String prefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> e : super.sub(prefix).entrySet()) {
            result.put(e.getKey(), e.getValue());
        }
        for (Map.Entry<String, String> e : this.userProperties.entrySet()) {
            String param_name = e.getKey();
            if (!param_name.startsWith(prefix)) continue;
            String param_value = e.getValue();
            String suffix = param_name.substring(prefix.length(), param_name.length());
            result.put(suffix, param_value);
        }
        return new ParameterMap.DefaultParameterMap(result);
    }

    public void setModulesParametrs(Map<String, Preferences> modulesParametrs) {
        this.modulesParametrs = modulesParametrs;
    }

    public void setPluginsParametrs(Map<String, Preferences> pluginsParametrs) {
        this.pluginsParametrs = pluginsParametrs;
    }

    public Preferences getModuleParameterPreferences(int mid) {
        return this.modulesParametrs.get(String.valueOf(mid));
    }

    public Preferences getPluginParameterPreferences(String mid) {
        return this.pluginsParametrs.get(mid);
    }

    public String getModuleParameterValue(int mid, String key) {
        Preferences moduleParameters = this.modulesParametrs.get(String.valueOf(mid));
        return moduleParameters == null ? null : moduleParameters.get(key);
    }

    public String getPluginParameterValue(String mid, String key) {
        Preferences pluginParameters = this.pluginsParametrs.get(mid);
        return pluginParameters == null ? null : pluginParameters.get(key);
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public static File getLocalConfigFile(int id) {
        DecimalFormat decimalFormat = new DecimalFormat("000");
        File configDir = ClientUtils.getLocalSettingFolder();
        return new File(configDir, "local_" + decimalFormat.format(id) + ".config");
    }

    public static String getLocalConfig(int id) {
        StringBuffer config = new StringBuffer();
        File file = ClientSetup.getLocalConfigFile(id);
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            String line = reader.readLine();
            while ((line = reader.readLine()) != null) {
                config.append(line).append("\n");
            }
            reader.close();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        return config.toString();
    }

    static {
        mutex = new Object();
    }
}

