/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.common.bean;

import java.util.Arrays;
import java.util.Optional;

public enum AddressEntityType {
    COUNTRY(20, "address_country", "country"),
    CITY(5, "address_city", "city"),
    STREET(7, "address_street", "street"),
    AREA(6, "address_area", "area"),
    QUARTER(8, "address_quarter", "quarter"),
    HOUSE(9, "address_house", "house");

    private int code;
    private String tableName;
    private String type;

    private AddressEntityType(int code, String tableName, String type) {
        this.code = code;
        this.tableName = tableName;
        this.type = type;
    }

    public int getCode() {
        return this.code;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getType() {
        return this.type;
    }

    public static Optional<AddressEntityType> getAddressEntityTypeByCode(int code) {
        return Optional.ofNullable(Arrays.asList(AddressEntityType.values()).stream().filter(a -> a.getCode() == code).findFirst().orElse(null));
    }
}

