/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.pattern.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.List;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.contract.pattern.common.service.ContractPatternService;
import ru.bitel.bgbilling.kernel.sequence.common.bean.BGSequence;
import ru.bitel.bgbilling.kernel.sequence.common.bean.enums.BGSequenceMode;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;

public class PatternSequenceTab
extends BGUPanel {
    private PatternSequenceTableModel tableModel = new PatternSequenceTableModel();

    @Override
    protected void jbInit() throws Exception {
        BGUTable table = new BGUTable(this.tableModel);
        table.setSelectionMode(0);
        BGSwingUtilites.handleEdit(table, this);
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> {
            if ("refreshTab".equals(e.getActionCommand()) && !this.tableModel.getRows().isEmpty()) {
                return;
            }
            this.tableModel.setData(((ClientContext)this.getContext()).getWebService(ContractPatternService.class, 0).patternSequenceList());
        });
        new AbstractBGUPanel.BGActionNew(e -> new PatternSequenceEditor("\u041d\u043e\u0432\u0430\u044f \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c", new BGSequence()).open());
        new AbstractBGUPanel.BGActionEdit(e -> this.tableModel.optSelectedRow().ifPresentOrElse(s -> new PatternSequenceEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438", (BGSequence)s).open(), () -> ClientUtils.showMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f")));
        new AbstractBGUPanel.BGActionDelete(e -> {
            BGSequence sequence = (BGSequence)this.tableModel.getSelectedRow();
            if (sequence == null) {
                ClientUtils.showMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
                return;
            }
            if (ClientUtils.confirmDelete(sequence.getTitle())) {
                ((ClientContext)this.getContext()).getWebService(ContractPatternService.class, 0).patternSequenceDelete(sequence.getId());
            }
        });
    }

    class PatternSequenceTableModel
    extends BGTableModel<BGSequence> {
        public PatternSequenceTableModel() {
            super(PatternSequenceTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u0447\u0435\u0442\u0447\u0438\u043a", 150, 150, 150, "counter", true, DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u0420\u0435\u0436\u0438\u043c \u0441\u0431\u0440\u043e\u0441\u0430", 150, 150, 150, "sequenceMode", true, DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u0412\u0440\u0435\u043c\u044f \u0441\u0431\u0440\u043e\u0441\u0430", 150, 150, 150, "resetDate", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
        }
    }

    class PatternSequenceEditor
    extends BGEditorDialog<BGSequence> {
        private BGTextField title;
        private BGTextField counter;
        private BGUComboBox<KeyValue> mode;
        private BGTextField resetDate;

        public PatternSequenceEditor(String title, BGSequence data) {
            super(title, data);
            this.title = new BGTextField(40);
            this.counter = new BGTextField(40);
            this.mode = new BGUComboBox();
            this.resetDate = new BGTextField(40);
        }

        @Override
        public void doDialogPanel() {
            this.addFieldV("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:", this.title);
            this.addFieldV("\u0421\u0447\u0435\u0442\u0447\u0438\u043a:", this.counter);
            this.addFieldV("\u0420\u0435\u0436\u0438\u043c \u0441\u0431\u0440\u043e\u0441\u0430:", this.mode);
            this.addFieldV("\u0412\u0440\u0435\u043c\u044f \u0441\u0431\u0440\u043e\u0441\u0430:", this.resetDate);
            if (((BGSequence)this.data).getId() > 0) {
                try {
                    this.data = ((ClientContext)PatternSequenceTab.this.getContext()).getWebService(ContractPatternService.class, 0).patternSequenceGet(((BGSequence)this.data).getId());
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
            List<KeyValue> modeItems = Arrays.asList(BGSequenceMode.values()).stream().map(a -> new KeyValue(a.name(), a.name())).toList();
            this.mode.setData(modeItems);
            this.counter.setHorizontalAlignment(0);
            this.counter.setEditable(((BGSequence)this.data).getId() < 1);
            this.resetDate.setHorizontalAlignment(0);
            this.resetDate.setEditable(false);
            this.title.setText(((BGSequence)this.data).getTitle());
            this.counter.setText(String.valueOf(((BGSequence)this.data).getCounter()));
            this.mode.setSelectedItem(modeItems.stream().filter(a -> a.getKey().equals(((BGSequence)this.data).getSequenceMode().name())).findFirst().orElse(null));
            this.resetDate.setText(TimeUtils.format(((BGSequence)this.data).getResetDate(), "dd.MM.yyyy HH:mm:ss"));
        }

        @Override
        public boolean doApply() throws Exception {
            if (!this.counter.getText().matches("^\\d+$")) {
                ClientUtils.showErrorMessageDialog("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0447\u0438\u043a\u0430 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0447\u0438\u0441\u043b\u043e\u043c");
                return false;
            }
            ((BGSequence)this.data).setTitle(this.title.getText());
            ((BGSequence)this.data).setCounter(Utils.parseLong(this.counter.getText()));
            ((BGSequence)this.data).setSequenceMode(BGSequenceMode.valueOf(((KeyValue)this.mode.getSelectedItem()).getKey()));
            ((ClientContext)PatternSequenceTab.this.getContext()).getWebService(ContractPatternService.class, 0).patternSequenceUpdate((BGSequence)this.data);
            PatternSequenceTab.this.performAction("refresh");
            return true;
        }
    }
}

