/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.xsl.server.bean;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.oss.kernel.xsl.common.event.XslModifiedEvent;
import ru.bitel.oss.kernel.xsl.server.bean.XslPatternDao;
import ru.bitel.oss.kernel.xsl.server.bean.XslPatternRuntime;

public class XslPatternRuntimeMap
extends BGLogger
implements EventListener<XslModifiedEvent> {
    private static XslPatternRuntimeMap xslRuntimeMap = null;
    private volatile Map<String, XslPatternRuntime> nameMap;

    public static XslPatternRuntimeMap getInstance() throws Exception {
        try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
            XslPatternRuntimeMap xslPatternRuntimeMap = XslPatternRuntimeMap.getInstance0(con);
            return xslPatternRuntimeMap;
        }
    }

    public static XslPatternRuntimeMap getInstance(ServerContext context) throws Exception {
        return XslPatternRuntimeMap.getInstance(context.getConnectionSet());
    }

    public static XslPatternRuntimeMap getInstance(ConnectionSet connectionSet) throws Exception {
        return XslPatternRuntimeMap.getInstance0(connectionSet);
    }

    public static XslPatternRuntimeMap getInstance(Connection con) throws Exception {
        return XslPatternRuntimeMap.getInstance0(con);
    }

    private static XslPatternRuntimeMap getInstance0(Object con) throws Exception {
        if (xslRuntimeMap == null) {
            XslPatternRuntimeMap newResult = new XslPatternRuntimeMap();
            EventProcessor.getInstance().addListener(newResult, XslModifiedEvent.class);
            if (con instanceof ConnectionSet) {
                newResult.load(((ConnectionSet)con).getConnection());
            } else {
                newResult.load((Connection)con);
            }
            xslRuntimeMap = newResult;
        }
        return xslRuntimeMap;
    }

    @Override
    public void notify(XslModifiedEvent event, EventListenerContext ctx) throws Exception {
        this.load(ctx.getConnection());
    }

    public XslPatternRuntime get(String name) {
        return this.nameMap.get(name);
    }

    public Map<String, XslPatternRuntime> getMap() {
        return this.nameMap;
    }

    private synchronized void load(Connection con) throws Exception {
        HashMap<String, XslPatternRuntime> nameMap = new HashMap<String, XslPatternRuntime>();
        this.getLogger().info("Loading XslPatternRuntimeMap");
        new XslPatternDao(con).list().stream().forEach(a -> nameMap.put(a.getName(), XslPatternRuntime.of(a)));
        this.nameMap = nameMap;
    }
}

