/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.config.server.service;

import jakarta.jws.WebService;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.config.common.service.DialogConfigService;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.config.common.service.DialogConfigService")
public class DialogConfigServiceImpl
extends AbstractService
implements DialogConfigService {
    @Override
    public List<KeyValue> dialogConfigList(int moduleId) throws Exception {
        BGModule bgModule = ModuleCache.getInstance().getModule(moduleId);
        URL url = DialogConfigServiceImpl.class.getResource("/" + (bgModule.getInstalledModule().getPackageServer() + ".editor").replace(".", "/"));
        return this.getFileList(this.getPath(url));
    }

    @Override
    public String dialogConfigGet(int moduleId, String key, boolean system) throws Exception {
        BGModule bgModule = ModuleCache.getInstance().getModule(moduleId);
        String data = null;
        File file = new File("conf/editor/" + bgModule.getInstalledModule().getName() + "/" + key + ".json");
        if (!system && file.exists()) {
            data = new String(Files.readAllBytes(Paths.get(file.toURI())), "utf-8");
        }
        if (data == null) {
            String fileName = bgModule.getInstalledModule().getPackageServer() + ".editor." + key;
            data = new String(Utils.readByBlock(DialogConfigServiceImpl.class.getResourceAsStream("/" + fileName.replace(".", "/") + ".json")), "utf-8");
        }
        return data == null ? null : data;
    }

    @Override
    public void dialogConfigUpdate(int moduleId, String key, String config) throws Exception {
        File file = new File("conf");
        File confEditor = new File(file, "editor");
        BGModule bgModule = ModuleCache.getInstance().getModule(moduleId);
        File moduleDir = new File(confEditor, bgModule.getInstalledModule().getName());
        if (!(file.exists() && confEditor.exists() && moduleDir.exists())) {
            moduleDir.mkdirs();
        }
        Files.write(Paths.get(moduleDir.getPath().toString(), key + ".json"), config.getBytes("utf-8"), new OpenOption[0]);
    }

    public Path getPath(URL url) throws Exception {
        if (url != null) {
            URI uri = url.toURI();
            if ("jar".equals(uri.getScheme())) {
                FileSystem fs = null;
                try {
                    fs = FileSystems.getFileSystem(uri);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (fs == null) {
                    fs = FileSystems.newFileSystem(uri, Collections.emptyMap());
                }
                String urlString = url.toString();
                return fs.getPath(urlString.substring(urlString.indexOf(33) + 1), new String[0]);
            }
            if ("file".equals(uri.getScheme())) {
                return Paths.get(uri);
            }
        }
        return null;
    }

    private List<KeyValue> getFileList(Path dirPath) throws Exception {
        ArrayList<KeyValue> files = new ArrayList<KeyValue>();
        try (Stream<Path> stream = Files.walk(dirPath, new FileVisitOption[0]);){
            int dirPathLen = dirPath.toString().length();
            stream.forEach(path -> {
                if (Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".json")) {
                    String key = path.toString().substring(dirPathLen + 1);
                    files.add(new KeyValue(key.replace('/', '.').substring(0, key.length() - 5), key.replaceFirst("\\/", ": ")));
                }
            });
        }
        return files;
    }
}

