/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client;

import bitel.billing.module.admin.DBInfo;
import bitel.billing.module.common.Updater;
import javax.swing.JOptionPane;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.BGClientInit;
import ru.bitel.bgbilling.client.runner.BGClientRunnerUtil;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginManagerClient;
import ru.bitel.bgbilling.kernel.plugin.client.inpoint.OnStart;
import ru.bitel.bgbilling.kernel.plugin.client.inpoint.OnStop;
import ru.bitel.common.client.UserAuth;

public class BGClient
extends BGClientBase {
    public BGClient() {
        this.init1(true);
        DBInfo dbInfo = null;
        while ((dbInfo = this.auth(dbInfo)) != null) {
        }
        this.init2();
    }

    @Override
    public DBInfo auth(DBInfo dbInfo) {
        super.auth(dbInfo);
        UserAuth userAuthDialog = new UserAuth();
        if (dbInfo != null) {
            userAuthDialog.setDbInfo(dbInfo);
            userAuthDialog.setSelectedDB(dbInfo.getDbServerKey());
        } else if (this.dbInfoManager.getDefaultServerKey() != null) {
            userAuthDialog.setSelectedDB(this.dbInfoManager.getDefaultServerKey());
        }
        userAuthDialog.setData();
        if (dbInfo != null && this.dbInfoManager.isAutorized(dbInfo)) {
            this.switchServer(dbInfo);
            return null;
        }
        if (userAuthDialog.showDialog().equals("cancel")) {
            DBInfo dbActive = this.dbInfoManager.getActiveDBInfo();
            if (dbActive == null) {
                BGClient.close();
            } else {
                try {
                    this.setBarData(dbActive);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
            return null;
        }
        if (this.dbInfoManager.getActiveDBInfo() != null) {
            for (OnStop p : BGPluginManagerClient.getManager().getInvokeables(OnStop.class, false)) {
                p.onStop();
            }
        }
        dbInfo = userAuthDialog.getDbInfo();
        try {
            if (!this.dbInfoManager.connect(dbInfo)) {
                return dbInfo;
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
            return dbInfo;
        }
        this.getTabbedPane().removeAll();
        this.dbInfoManager.setActiveDBInfo(dbInfo);
        BGClient.loadUserEmail(dbInfo);
        BGClientRunnerUtil.saveServersConfig(this.dbInfoManager.getInfoLists(), this.dbInfoManager.getDefaultServerKey(), this.dbInfoManager.getServersListMode(), this.dbInfoManager.isAnySSL());
        try {
            return this.auth5(dbInfo);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
            return null;
        }
    }

    @Override
    public void switchServer(DBInfo dbInfo) {
        DBInfo active = this.dbInfoManager.getActiveDBInfo();
        if (active != null && active.getDbServerKey().equals(dbInfo.getDbServerKey())) {
            try {
                this.setBarData(dbInfo);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        } else {
            if (this.dbInfoManager.getActiveDBInfo() != null) {
                for (OnStop onStop : BGPluginManagerClient.getManager().getInvokeables(OnStop.class, false)) {
                    onStop.onStop();
                }
            }
            BGPluginManagerClient.getManager().setPluginsOnServer(this.dbInfoManager.getServerPluginSet());
            this.getTabbedPane().removeAll();
            this.dbInfoManager.setActiveDBInfo(dbInfo);
            try {
                this.addjustFrame(this.dbInfoManager, dbInfo);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
            for (OnStart onStart : BGPluginManagerClient.getManager().getInvokeables(OnStart.class, false)) {
                onStart.onStart();
            }
        }
    }

    public static void main(String[] args) {
        BGClientInit.mainInit(args);
        new BGClient();
    }

    @Override
    protected void jbInit() throws Exception {
        super.jbInit(false);
    }

    public void performUpdate(boolean force) {
        if (Updater.updateModules(force)) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u044b, \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435.", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
            BGClient.close(true);
        } else if (force) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u043d\u0435 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u043e.");
        }
    }
}

