/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffVar;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.ContractTariffDao;
import ru.bitel.bgbilling.kernel.contract.status.server.ContractStatusList;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionList;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffVarRuntimeMap;
import ru.bitel.bgbilling.kernel.tariff.server.tree.ServiceCost;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSet;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.oss.systems.inventory.product.server.ProductPeriodRuntimeList;

public abstract class AbstractTariffRequest<S extends ServiceCost> {
    protected ConnectionSet connectionSet;
    public final int moduleId;
    public final int contractId;
    public final long sessionId;
    protected int objectId = 0;
    private List<ContractTariffVar> contractTariffVars = Collections.emptyList();
    protected Map<Integer, List<S>> serviceCostMap = new HashMap<Integer, List<S>>(8);
    public S serviceCost = null;
    private int accountingMonthDays;
    private Calendar time;
    private int timeRangeId;
    private boolean accepted;
    private boolean infoEnable = true;
    private StringBuilder errors = null;
    private StringBuilder info = null;
    public final List<Integer> contractLabelIds;
    private final int domainId;
    protected ProductPeriodRuntimeList contractProductPeriodRuntimeList;
    protected ProductPeriodRuntimeList productPeriodRuntimeList;
    public final int accountingPeriodId;
    public final long accountingPeriodMillisFrom;
    public final long accountingPeriodMillisTo;
    public final ContractStatusList suspendedPeriodList;
    private ContractTariffOptionList contractTariffOptions;
    private Map<Integer, ContractTariffOptionList.OptionItem> currentTariffOptionMap = null;
    private long currentTariffOptionMapMillis;
    @Deprecated
    public Map<Integer, ContractTariffOptionList.OptionItem> tariffOptionMap = null;
    private TariffModuleTreeSet.Entry tariffTreeSetEntry;
    private long activeProductIdsMillis;
    private Set<Integer> activeProductIds;
    private Map<Class<?>, Set<Long>> acceptedSetMap;

    public AbstractTariffRequest(int moduleId, int contractId, long sessionId) {
        this(0, moduleId, contractId, new ArrayList<Integer>(), sessionId, null, 0, 0L, 0L, null);
    }

    public AbstractTariffRequest(int domainId, int moduleId, int contractId, List<Integer> contractLabelIds) {
        this(domainId, moduleId, contractId, contractLabelIds, 0L, null, 0, 0L, 0L, null);
    }

    public AbstractTariffRequest(int domainId, int moduleId, int contractId, List<Integer> contractLabelIds, long sessionId, ProductPeriodRuntimeList productPeriodRuntimeList) {
        this(domainId, moduleId, contractId, contractLabelIds, sessionId, productPeriodRuntimeList, 0, 0L, 0L, null);
    }

    public AbstractTariffRequest(int domainId, int moduleId, int contractId, List<Integer> contractLabelIds, long sessionId, ProductPeriodRuntimeList productPeriodRuntimeList, int accountingPeriodId, long accountingPeriodMillisFrom, long accountingPeriodMillisTo, ContractStatusList suspendedPeriodList) {
        this.domainId = domainId;
        this.moduleId = moduleId;
        this.contractId = contractId;
        this.contractLabelIds = contractLabelIds;
        this.sessionId = sessionId;
        this.productPeriodRuntimeList = productPeriodRuntimeList;
        this.suspendedPeriodList = suspendedPeriodList;
        this.accountingPeriodId = accountingPeriodId;
        this.accountingPeriodMillisFrom = accountingPeriodMillisFrom;
        this.accountingPeriodMillisTo = accountingPeriodMillisTo;
    }

    public AbstractTariffRequest<S> setServiceCost(Integer serviceId, List<S> serviceCostList) {
        this.serviceCostMap.put(serviceId, serviceCostList);
        return this;
    }

    public void addServiceCost(S serviceCost) {
        List<S> serviceCostList = this.getServiceCost().get(((ServiceCost)serviceCost).serviceId);
        if (serviceCostList == null) {
            serviceCostList = new ArrayList<S>();
            this.setServiceCost(((ServiceCost)serviceCost).serviceId, serviceCostList);
        }
        serviceCostList.add(serviceCost);
    }

    public Map<Integer, List<S>> getServiceCost() {
        return this.serviceCostMap;
    }

    public Collection<S> getServiceCostList() {
        ArrayList<S> result = new ArrayList<S>();
        for (List<S> me : this.serviceCostMap.values()) {
            result.addAll(me);
        }
        return result;
    }

    public Connection getConnection() {
        return this.connectionSet.getConnection();
    }

    public ConnectionSet getConnectionSet() {
        return this.connectionSet;
    }

    public AbstractTariffRequest<S> setConnectionSet(ConnectionSet connectionSet) {
        this.connectionSet = connectionSet;
        return this;
    }

    public int getAccountingMonthDays() {
        return this.accountingMonthDays;
    }

    public AbstractTariffRequest<S> setAccountingMonthDays(int accountingMonthDays) {
        this.accountingMonthDays = accountingMonthDays;
        return this;
    }

    public Calendar getTime() {
        return this.time;
    }

    public LocalDate getLocalTime() {
        return TimeUtils.convertDateToLocalDate((Date)this.time.getTime());
    }

    public AbstractTariffRequest<S> setTime(Calendar time) {
        this.time = time;
        return this;
    }

    public int getTimeRangeId() {
        return this.timeRangeId;
    }

    public AbstractTariffRequest<S> setTimeRangeId(int timeRangeId) {
        this.timeRangeId = timeRangeId;
        return this;
    }

    private Set<Integer> getActiveProductSpecIds() {
        long time = this.getTime().getTimeInMillis();
        if (this.activeProductIdsMillis != time) {
            HashSet<Integer> result = new HashSet<Integer>();
            if (this.contractProductPeriodRuntimeList != null) {
                this.contractProductPeriodRuntimeList.activeProductSpecIds(time, result, null);
            }
            if (this.productPeriodRuntimeList != null) {
                this.productPeriodRuntimeList.activeProductSpecIds(time, result, null);
            }
            this.activeProductIds = result.size() > 0 ? result : Collections.emptySet();
            this.activeProductIdsMillis = time;
        }
        return this.activeProductIds;
    }

    public Set<Integer> getActiveProductSpecIds(long millis, Predicate<ProductPeriodRuntimeList.ProductPeriodItem> predicate) {
        if (predicate == null) {
            return this.getActiveProductSpecIds();
        }
        HashSet<Integer> result = new HashSet<Integer>();
        if (this.contractProductPeriodRuntimeList != null) {
            this.contractProductPeriodRuntimeList.activeProductSpecIds(millis, result, predicate);
        }
        if (this.productPeriodRuntimeList != null) {
            this.productPeriodRuntimeList.activeProductSpecIds(millis, result, predicate);
        }
        return result;
    }

    public void addError(String error) {
        if (this.errors == null) {
            this.errors = new StringBuilder();
        }
        this.errors.append(error).append("; ");
    }

    public AbstractTariffRequest<S> setInfoEnable(boolean value) {
        this.infoEnable = value;
        return this;
    }

    public boolean isInfoEnabled() {
        return this.infoEnable;
    }

    public void addInfo(String info) {
        if (this.info == null) {
            this.info = new StringBuilder();
        }
        this.info.append(info).append("\n");
    }

    public String getErrors() {
        if (this.errors != null && this.errors.length() > 0) {
            return this.errors.substring(0, this.errors.length() - 2);
        }
        return "";
    }

    private CharSequence getInfo() {
        if (this.info != null && this.info.length() > 0) {
            return this.info.subSequence(0, this.info.length() - 1);
        }
        return "";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PARAMS: ");
        sb.append(this.toStringRequestParams());
        sb.append("HIST: ");
        sb.append(this.getInfo());
        return sb.toString();
    }

    protected CharSequence toStringRequestParams() {
        StringBuilder result = new StringBuilder(200);
        result.append("moduleId: ");
        result.append(this.moduleId);
        result.append("; contractId: ");
        result.append(this.contractId);
        result.append("\n");
        for (List<S> me : this.serviceCostMap.values()) {
            for (ServiceCost serviceCost : me) {
                result.append(serviceCost.toString());
                result.append("\n");
            }
        }
        return result.toString();
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public AbstractTariffRequest<S> setAccepted(boolean accepted) {
        this.accepted = accepted;
        return this;
    }

    public final Set<Long> getAcceptedSet(Class<?> clazz) {
        Map<Class<?>, Set<Long>> acceptedSetMap;
        Set<Long> acceptedSet;
        if (this.acceptedSetMap == null) {
            this.acceptedSetMap = new HashMap(8);
        }
        if ((acceptedSet = (acceptedSetMap = this.acceptedSetMap).get(clazz)) == null) {
            acceptedSet = new HashSet<Long>(8);
            acceptedSetMap.put(clazz, acceptedSet);
        }
        return acceptedSet;
    }

    public final Map<Class<?>, Set<Long>> acceptedSetPush() {
        Map<Class<?>, Set<Long>> result = this.acceptedSetMap;
        this.acceptedSetMap = null;
        return result;
    }

    public final void acceptedSetClear() {
        if (this.acceptedSetMap != null) {
            for (Set<Long> set : this.acceptedSetMap.values()) {
                set.clear();
            }
        }
    }

    public final void acceptedSetPop(Map<Class<?>, Set<Long>> pushed) {
        this.acceptedSetMap = pushed;
    }

    public TariffModuleTreeSet.Entry getTariffTreeSetEntry() {
        return this.tariffTreeSetEntry;
    }

    public void setTariffTreeSetEntry(TariffModuleTreeSet.Entry tariffTreeSetEntry) throws SQLException {
        this.tariffTreeSetEntry = tariffTreeSetEntry;
        if (this.connectionSet != null && tariffTreeSetEntry != null) {
            ContractTariffDao contractTariffDao = new ContractTariffDao(this.connectionSet.getConnection());
            this.contractTariffVars = contractTariffDao.getContractTariffVars(tariffTreeSetEntry.getContractTariffId());
        }
    }

    public int getDomainId() {
        return this.domainId;
    }

    public AbstractTariffRequest<S> setContractTariffOptions(ContractTariffOptionList contractTariffOptions) {
        this.contractTariffOptions = contractTariffOptions;
        return this;
    }

    public Map<Integer, ContractTariffOptionList.OptionItem> getTariffOptionMap() {
        return this.getTariffOptionMap(this.time.getTimeInMillis());
    }

    public Map<Integer, ContractTariffOptionList.OptionItem> getTariffOptionMap(long millis) {
        if (this.currentTariffOptionMapMillis != millis) {
            Map result;
            this.currentTariffOptionMap = this.contractTariffOptions != null ? ((result = this.contractTariffOptions.map(millis, millis)) != null && result.size() > 0 ? result : Collections.emptyMap()) : Collections.emptyMap();
            this.currentTariffOptionMapMillis = millis;
        }
        return this.currentTariffOptionMap;
    }

    public ContractTariffOptionList getContractTariffOptions() {
        return this.contractTariffOptions;
    }

    public AbstractTariffRequest<S> setContractTariffVars(List<ContractTariffVar> contractTariffVars) {
        this.contractTariffVars = contractTariffVars;
        return this;
    }

    public List<ContractTariffVar> getContractTariffVars() {
        return this.contractTariffVars;
    }

    public String getContractTariffVarValue(int tariffVarId) {
        ContractTariffVar contractTariffVar = null;
        if (this.contractTariffVars != null) {
            contractTariffVar = this.contractTariffVars.stream().filter(a -> a.getTariffVar().getId() == tariffVarId).findFirst().orElse(null);
        }
        if (contractTariffVar == null || contractTariffVar.getValue() == null) {
            return TariffVarRuntimeMap.getInstance().opt(tariffVarId, this.getLocalTime()).map(a -> a.getDefaultValue()).orElse(null);
        }
        return contractTariffVar.getValue();
    }

    public int getObjectId() {
        return this.objectId;
    }

    public <T> T to(Class<T> clazz) {
        return (T)this;
    }
}

