/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.customer.client.parameter;

import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.contract.api.common.service.CustomerParameterProviderService;
import ru.bitel.bgbilling.kernel.customer.client.parameter.CompanyDataResultDialog;
import ru.bitel.common.Utils;
import ru.bitel.common.client.list.BGUList;

public final class FillParametersByINNDialog
extends BGEditorDialog<JSONObject> {
    private final JTextField inputField = new JTextField(40);
    private final CustomerParameterProviderService parametersSearchService;
    private final BGUList<BGUListItem> searchImplList = new BGUList();
    private final JSONObject filledContractParameters;

    public FillParametersByINNDialog(ClientContext context, String innOrOgrn, JSONObject filledContractParameters) {
        super("\u0417\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432", null, context);
        this.parametersSearchService = (CustomerParameterProviderService)context.getPort(CustomerParameterProviderService.class, 0);
        this.filledContractParameters = filledContractParameters;
        ((AbstractDocument)this.inputField.getDocument()).setDocumentFilter(new DigitDocumentFilter(this));
        this.inputField.setText(Utils.maskNull((String)innOrOgrn));
    }

    public void doDialogPanel() {
        this.addFieldV("\u0418\u041d\u041d \u0438\u043b\u0438 \u041e\u0413\u0420\u041d:", this.inputField);
        this.addFieldV("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445:", new JScrollPane((Component)this.searchImplList));
        this.tryCall(() -> {
            List<String> searchImplementation = this.parametersSearchService.getParametersSearchImplementation();
            if (searchImplementation.size() > 1) {
                this.searchImplList.setData(searchImplementation.stream().map(searchTitle -> new BGUListItem(0, searchTitle)).toList());
                this.searchImplList.setSelectedIndex(0);
            }
        });
    }

    public boolean doApply() throws Exception {
        String input = this.inputField.getText();
        if (Utils.notBlankString((String)input)) {
            if (input.length() != 10 && input.length() != 13) {
                BGToolTip.showErrorMessage((JComponent)this.inputField, (String)"\u041d\u0435 \u0432\u0435\u0440\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d\u044b \u0418\u041d\u041d \u0438\u043b\u0438 \u041e\u0413\u0420\u041d!");
                return false;
            }
            return this.tryCallBoolean(() -> {
                String selected = this.searchImplList.getSelectedValue() != null ? ((BGUListItem)this.searchImplList.getSelectedValue()).getGuiTitle() : null;
                JSONObject data = new JSONObject(this.parametersSearchService.searchParameters(input, selected));
                new CompanyDataResultDialog(this.clientContext, data, this.filledContractParameters).open();
            });
        }
        BGToolTip.showErrorMessage((JComponent)this.inputField, (String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0418\u041d\u041d \u0438\u043b\u0438 \u041e\u0413\u0420\u041d!");
        return false;
    }

    private final class DigitDocumentFilter
    extends DocumentFilter {
        private DigitDocumentFilter(FillParametersByINNDialog fillParametersByINNDialog) {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            if (string == null) {
                return;
            }
            if (string.matches("\\d+") && string.length() <= 13) {
                super.insertString(fb, offset, string, attr);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (text == null) {
                return;
            }
            if (text.matches("\\d*") && text.length() <= 13) {
                super.replace(fb, offset, length, text, attrs);
            }
        }
    }
}

