/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.config.client;

import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGConfigEditorPane;
import ru.bitel.bgbilling.client.common.BGServiceConfigModulePatternPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGToggleButton;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.config.common.bean.ConfigData;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.TryCall;

public class LocalServiceConfig
extends ServiceConfigTabbedPanel {
    private static final String BUTTON_SAVE = "save";
    private static final String BUTTON_CANCEL = "cancel";
    private static final String BUTTON_SET = "set";
    private static final String BUTTON_PATTERN = "pattern";
    private boolean edited = false;
    private String module = "service";
    private ConfigData configData = null;
    private Map<String, AbstractButton> buttonMap = new HashMap<String, AbstractButton>();
    private CardLayout tableCardLayout = new CardLayout();
    private BGConfigEditorPane configEditorPane = new BGConfigEditorPane();
    protected ConfigTableModel configTableModel = new ConfigTableModel(ConfigTableModel.class.getName());
    private JPanel tablePanel = new JPanel();
    private BGServiceConfigModulePatternPanel patternPanel = new BGServiceConfigModulePatternPanel();
    private JPanel infoPanel = new JPanel();
    private JPanel notePanel = new JPanel();
    private JPanel valueEditorPanel = new JPanel();
    private JTextField configTitle = new JTextField();
    private Directory<UserInfo> userDirectory;
    private ClientSetup clientSetup = ClientSetup.getInstance();
    private static int defaultView = 0;

    public LocalServiceConfig() {
        this.jbInit();
        this.tryCall(() -> {
            this.userDirectory = this.getContext().getDirectory(UserInfo.class, 0);
        });
    }

    private void jbInit() {
        this.configEditorPane.setText("");
        this.infoPanel.setLayout(new GridBagLayout());
        this.notePanel.setLayout(new GridBagLayout());
        this.valueEditorPanel.setLayout(new GridBagLayout());
        this.configTitle.setMinimumSize(new Dimension(4, 24));
        this.configTitle.setPreferredSize(new Dimension(67, 24));
        this.configTitle.setText("");
        BGUTable table = new BGUTable((TableModel)((Object)this.configTableModel));
        table.setSelectionMode(0);
        this.infoPanel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.notePanel.add((Component)new JScrollPane((Component)this.configEditorPane), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.notePanel.add((Component)new JLabel("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.notePanel.add((Component)this.configTitle, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(" \u041f\u043e\u0438\u0441\u043a \u043f\u043e \u043f\u043e\u0434\u0441\u0442\u0440\u043e\u043a\u0435 "));
        JTextField findText = new JTextField();
        BGButton find = new BGButton("\u041d\u0430\u0439\u0442\u0438", "find", e -> this.find(findText.getText(), 0));
        ActionListener findListener = e -> this.find(findText.getText(), this.configEditorPane.getSelectionEnd());
        BGButton findNext = new BGButton("\u041d\u0430\u0439\u0442\u0438 \u0434\u0430\u043b\u0435\u0435", "findNext", findListener);
        findText.addActionListener(findListener);
        panel.add((Component)findText, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)find, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)findNext, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.notePanel.add((Component)panel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 3, 4, 3), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(this.getMainPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        BGSwingUtilites.handleMouseClicked((Component)table, e -> this.handleMouseClicked((MouseEvent)e));
    }

    private void handleMouseClicked(MouseEvent event) {
        if (SwingUtilities.isLeftMouseButton(event) && event.getClickCount() > 1) {
            this.editItem();
        }
    }

    private JPanel getMainPanel() {
        this.tablePanel.setLayout(this.tableCardLayout);
        this.tablePanel.add((Component)this.infoPanel, "table");
        this.tablePanel.add((Component)this.patternPanel, BUTTON_PATTERN);
        this.tablePanel.add((Component)this.notePanel, "editor");
        ActionListener actionListener = e -> {
            String actionCommand = e.getActionCommand();
            if (BUTTON_SAVE.equals(actionCommand)) {
                this.saveConfigButton_actionPerformed(e);
            } else if (BUTTON_SET.equals(actionCommand)) {
                this.setConfigButton_actionPerformed(e);
            } else if (BUTTON_CANCEL.equals(actionCommand)) {
                this.cancelConfigButton_actionPerformed(e);
            } else if (BUTTON_PATTERN.equals(actionCommand)) {
                this.patternConfigButton_actionPerformed(e);
            }
        };
        ConfigButton saveConfigButton = new ConfigButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", false, BUTTON_SAVE, actionListener);
        ConfigButton cancelConfigButton = new ConfigButton("\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c", false, BUTTON_CANCEL, actionListener);
        ConfigButton setConfigButton = new ConfigButton("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c", BUTTON_SET, actionListener);
        BGToggleButton patternConfigButton = new BGToggleButton();
        patternConfigButton.setMargin(new Insets(2, 4, 2, 2));
        patternConfigButton.setText("\u0428\u0430\u0431\u043b\u043e\u043d");
        patternConfigButton.setEnabled(false);
        patternConfigButton.setActionCommand(BUTTON_PATTERN);
        patternConfigButton.addActionListener(actionListener);
        this.buttonMap.put(BUTTON_PATTERN, (AbstractButton)patternConfigButton);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add((Component)((Object)saveConfigButton), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 10, 5, 5), 0, 0));
        buttonPanel.add((Component)((Object)cancelConfigButton), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 10), 0, 0));
        buttonPanel.add((Component)((Object)setConfigButton), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 10, 5, 10), 0, 0));
        buttonPanel.add((Component)patternConfigButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 10, 5, 10), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(" \u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f "));
        panel.add((Component)this.tablePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)buttonPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private void find(String str, int offset) {
        int index;
        String data = this.configEditorPane.getText().toLowerCase();
        str = str.toLowerCase();
        if (offset == data.length()) {
            offset = 0;
        }
        if ((index = data.indexOf(str, offset)) != -1) {
            this.configEditorPane.select(index, index + str.length());
            this.configEditorPane.getCaret().setSelectionVisible(true);
        } else if (offset > 0 && (index = data.indexOf(str, 0)) != -1) {
            this.configEditorPane.select(index, index + str.length());
            this.configEditorPane.getCaret().setSelectionVisible(true);
        }
    }

    public void setData() {
        int moduleId = this.getModuleId();
        this.tryCall(() -> {
            File configDir = ClientUtils.getLocalSettingFolder();
            if (configDir.exists() && configDir.isDirectory()) {
                ArrayList<ConfigData> configDatas = new ArrayList<ConfigData>();
                FileFilter fileFilter = new FileFilter(this){

                    @Override
                    public boolean accept(File pathname) {
                        return !pathname.isDirectory() && pathname.canRead() && pathname.getName().matches("^local_\\d{3}\\.config$");
                    }
                };
                int configId = this.clientSetup.getUserConfig().getInt("local.config.id", 0);
                for (File file : configDir.listFiles(fileFilter)) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                    String[] headerField = reader.readLine().split("\t");
                    reader.close();
                    if (headerField.length != 3) continue;
                    int id = Utils.parseInt((String)file.getName().substring(6, 9));
                    int userId = Utils.parseInt((String)headerField[2], (int)0);
                    UserInfo userInfo = this.userDirectory.get(userId);
                    configDatas.add(ConfigData.builder().setId(id).setTitle(headerField[0]).setLastEdited(new Date(Utils.parseLong((String)headerField[1], (long)file.lastModified()))).setUserId(userId).setUserName(userInfo != null ? userInfo.getName() : "???").setActive(id == configId).build());
                }
                this.configTableModel.setData(configDatas);
                this.edited = false;
            }
        });
        this.patternPanel.init(this.module, moduleId);
    }

    void tableConfig_mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
            this.editItem();
        }
    }

    void saveConfigButton_actionPerformed(ActionEvent actionEvent) {
        if (this.configTitle.getText().trim().length() == 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
            return;
        }
        if (this.buttonMap.get(BUTTON_PATTERN).isSelected()) {
            this.configEditorPane.setText(this.patternPanel.getTextConfig());
        }
        if (this.configData.getId() == 0) {
            File file;
            int index = 1;
            while ((file = ClientSetup.getLocalConfigFile((int)index)).exists()) {
                ++index;
            }
            if (index > 999) {
                ClientUtils.showErrorMessageDialog((String)"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0439 \u043f\u0440\u0435\u0432\u044b\u0441\u0438\u043b\u043e \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (999).\n\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e.");
                return;
            }
            this.configData.setId(index);
        }
        this.configData.setModuleId(this.getModuleId());
        this.configData.setLastEdited(new Date());
        this.configData.setTitle(this.configTitle.getText().trim());
        this.configData.setConfig(this.configEditorPane.getText().trim());
        this.configData.setUserId(this.clientSetup.getUserId());
        TryCall.call(() -> {
            File file = ClientSetup.getLocalConfigFile((int)this.configData.getId());
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            writer.write(this.configData.getTitle());
            writer.write("\t");
            writer.write(String.valueOf(this.configData.getLastEdited().getTime()));
            writer.write("\t");
            writer.write(String.valueOf(this.configData.getUserId()));
            writer.write("\n");
            writer.write(this.configData.getConfig());
            ((Writer)writer).flush();
            ((Writer)writer).close();
            this.setData();
            this.edited = false;
            this.buttonMap.get(BUTTON_SAVE).setEnabled(false);
            this.buttonMap.get(BUTTON_CANCEL).setEnabled(false);
            this.buttonMap.get(BUTTON_SET).setEnabled(true);
            this.buttonMap.get(BUTTON_PATTERN).setEnabled(false);
            this.saveLastUsedView();
            this.tableCardLayout.show(this.tablePanel, "table");
        });
    }

    void cancelConfigButton_actionPerformed(ActionEvent e) {
        this.edited = false;
        this.buttonMap.get(BUTTON_SAVE).setEnabled(false);
        this.buttonMap.get(BUTTON_CANCEL).setEnabled(false);
        this.buttonMap.get(BUTTON_SET).setEnabled(true);
        this.buttonMap.get(BUTTON_PATTERN).setEnabled(false);
        this.tableCardLayout.show(this.tablePanel, "table");
        this.saveLastUsedView();
    }

    void setConfigButton_actionPerformed(ActionEvent e) {
        this.configData = (ConfigData)((Object)this.configTableModel.getSelectedRow());
        if (this.configData == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u043e\u043d\u0444\u0438\u0433");
        } else {
            this.tryCall(() -> {
                this.clientSetup.getUserConfig().set("local.config.id", String.valueOf(this.configData.getId()));
                this.clientSetup.saveUserConfig();
            });
            this.setData();
        }
    }

    void patternConfigButton_actionPerformed(ActionEvent e) {
        if (this.buttonMap.get(BUTTON_PATTERN).isSelected()) {
            this.patternPanel.setDataPatternTable(this.configEditorPane.getText(), true);
            this.tableCardLayout.show(this.tablePanel, BUTTON_PATTERN);
        } else {
            this.configEditorPane.setText(this.patternPanel.getTextConfig());
            this.tableCardLayout.show(this.tablePanel, "editor");
        }
    }

    private void saveLastUsedView() {
        int sel;
        int n = sel = this.buttonMap.get(BUTTON_PATTERN).isSelected() ? 1 : 0;
        if (sel != defaultView) {
            this.clientSetup.getUserConfig().set("isPattern", String.valueOf(sel));
        } else {
            this.clientSetup.getUserConfig().set("isPattern", "default");
        }
        this.buttonMap.get(BUTTON_PATTERN).setSelected(false);
    }

    public void newItem() {
        if (!this.edited) {
            this.edited = true;
            this.buttonMap.get(BUTTON_SAVE).setEnabled(true);
            this.buttonMap.get(BUTTON_CANCEL).setEnabled(true);
            this.buttonMap.get(BUTTON_SET).setEnabled(false);
            this.buttonMap.get(BUTTON_PATTERN).setEnabled(true);
            this.configData = new ConfigData();
            this.configTitle.setText("");
            this.configEditorPane.setText("");
            this.tableCardLayout.show(this.tablePanel, "editor");
        }
    }

    public void editItem() {
        if (!this.edited) {
            this.configData = (ConfigData)((Object)this.configTableModel.getSelectedRow());
            if (this.configData == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u043e\u043d\u0444\u0438\u0433");
            } else {
                this.configData.setConfig(ClientSetup.getLocalConfig((int)this.configData.getId()));
                this.configTitle.setText(this.configData.getTitle());
                this.configEditorPane.setText(this.configData.getConfig());
                this.edited = true;
                this.buttonMap.get(BUTTON_SAVE).setEnabled(true);
                this.buttonMap.get(BUTTON_CANCEL).setEnabled(true);
                this.buttonMap.get(BUTTON_SET).setEnabled(false);
                this.buttonMap.get(BUTTON_PATTERN).setEnabled(true);
                this.patternPanel.setDataPatternTable(this.configEditorPane.getText(), true);
                switch (this.clientSetup.getUserConfig().getInt("isPattern", defaultView)) {
                    case 1: {
                        this.tableCardLayout.show(this.tablePanel, BUTTON_PATTERN);
                        this.buttonMap.get(BUTTON_PATTERN).setSelected(true);
                        break;
                    }
                    case 0: {
                        this.tableCardLayout.show(this.tablePanel, "editor");
                    }
                }
            }
        }
    }

    public void deleteItem() {
        if (!this.edited) {
            this.configData = (ConfigData)((Object)this.configTableModel.getSelectedRow());
            if (this.configData == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u043e\u043d\u0444\u0438\u0433");
            } else if (this.configData.isActive()) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0439 \u043a\u043e\u043d\u0444\u0438\u0433");
            } else if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                this.tryCall(() -> {
                    ClientSetup.getLocalConfigFile((int)this.configData.getId()).delete();
                    this.configTableModel.deleteRow((Object)((ConfigData)((Object)((Object)this.configTableModel.getSelectedRow()))));
                });
            }
        }
    }

    class ConfigTableModel
    extends BGTableModel<ConfigData> {
        public ConfigTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0410\u043a\u0442\u0438\u0432\u043d\u0430\u044f", 80, 80, 80, "active", true);
            this.addColumn("\u0414\u0430\u0442\u0430", 150, 160, 170, "lastEdited", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", 200, 250, 300, "userName", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }
    }

    class ConfigButton
    extends BGButton {
        ConfigButton(String text, String actionCommand, ActionListener actionListener) {
            this(text, true, actionCommand, actionListener);
        }

        ConfigButton(String text, boolean enabled, String actionCommand, ActionListener actionListener) {
            this.setText(text);
            this.setEnabled(enabled);
            this.setActionCommand(actionCommand);
            this.setMargin(new Insets(2, 4, 2, 4));
            this.addActionListener(actionListener);
            LocalServiceConfig.this.buttonMap.put(actionCommand, (AbstractButton)((Object)this));
        }
    }
}

