/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.kernel.directory.api.common.DirectoryItem;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.util.MacrosFormat;
import ru.bitel.oss.kernel.entity.common.bean.AbstractSpecAttr;
import ru.bitel.oss.kernel.entity.common.bean.Entity;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.dto.EntitySpecDTO;
import ru.bitel.oss.kernel.entity.common.event.EntitySpecModifiedEvent;

@DirectoryItem(eventClass=EntitySpecModifiedEvent.class)
public class EntitySpec
extends IdTitle {
    private static Pattern macrosPattern = Pattern.compile("\\$\\{([\\w:]+)\\}");
    private final transient ThreadLocal<SoftReference<EntityMacrosFormat>> macrosFormat = new ThreadLocal();
    private Set<Integer> moduleIds;
    private String entityTitleMacros = "";
    private int entitySpecTypeId;
    private String comment;
    private boolean hidden;
    private List<? extends AbstractSpecAttr> attributeList;

    public EntitySpec() {
    }

    public EntitySpec(String title) {
        this.title = title;
    }

    @XmlAttribute
    public Set<Integer> getModuleIds() {
        return this.moduleIds;
    }

    @XmlAttribute
    public int getEntitySpecTypeId() {
        return this.entitySpecTypeId;
    }

    @XmlAttribute
    public String getEntityTitleMacros() {
        return this.entityTitleMacros;
    }

    @XmlElement
    public String getComment() {
        return this.comment;
    }

    @XmlAttribute
    public boolean isHidden() {
        return this.hidden;
    }

    @XmlElementWrapper
    public List<? extends AbstractSpecAttr> getAttributeList() {
        return this.attributeList;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setModuleIds(Set<Integer> moduleIds) {
        this.moduleIds = moduleIds;
    }

    public void setEntitySpecTypeId(int entitySpecTypeId) {
        this.entitySpecTypeId = entitySpecTypeId;
    }

    public void setEntityTitleMacros(String entityTitleMakros) {
        this.entityTitleMacros = entityTitleMakros;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setAttributeList(List<? extends AbstractSpecAttr> attributes) {
        this.attributeList = attributes;
    }

    private MacrosFormat getMacrosFormat() {
        EntityMacrosFormat result;
        SoftReference<EntityMacrosFormat> ref = this.macrosFormat.get();
        if (ref != null && (result = ref.get()) != null) {
            return result;
        }
        result = new EntityMacrosFormat(this);
        result.setPattern(this.entityTitleMacros);
        this.macrosFormat.set(new SoftReference<EntityMacrosFormat>(result));
        return result;
    }

    public String createEntityTitle(Entity entity) {
        if (Utils.isBlankString(this.entityTitleMacros)) {
            return entity.getTitle();
        }
        try {
            return this.getMacrosFormat().format(new StringBuffer(20), entity).toString();
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
    }

    public EntitySpecDTO toEntitySpecDTO() {
        return EntitySpecDTO.builder().setId(this.id).setTitle(this.title).setComment(this.comment).setEntityTitleMacros(this.entityTitleMacros).build();
    }

    public static String createEntityTitle(int entityId, String title, EntitySpec spec, Map<Integer, EntityAttr> attributes) {
        String macros = spec.getEntityTitleMacros();
        if (Utils.isBlankString(macros)) {
            return title;
        }
        Matcher m = macrosPattern.matcher(macros);
        StringBuffer result = new StringBuffer();
        int end = 0;
        while (m.find()) {
            int start = m.start();
            result.append(macros.substring(end, start));
            result.append(EntitySpec.processTitleMacros(m.group(1), entityId, title, spec, attributes));
            end = m.end();
        }
        result.append(macros.substring(end, macros.length()));
        title = result.toString();
        return title;
    }

    private static int getMacrosParamId(String str) {
        int pos = str.indexOf(58);
        if (pos > 0 && pos < str.length() - 2) {
            return Utils.parseInt(str.substring(pos + 1), 0);
        }
        pos = str.indexOf(95);
        if (pos > 0 && pos < str.length() - 2) {
            return Utils.parseInt(str.substring(pos + 1), 0);
        }
        return 0;
    }

    private static String processTitleMacros(String macros, int entityId, String title, EntitySpec spec, Map<Integer, EntityAttr> attributes) {
        EntityAttr attr;
        if (macros.equals("type")) {
            return spec.getTitle();
        }
        if (macros.equals("id")) {
            return String.valueOf(entityId);
        }
        if (macros.equals("title")) {
            return spec.getTitle();
        }
        if ((macros.startsWith("address:") || macros.startsWith("date:") || macros.startsWith("text:") || macros.startsWith("list:")) && (attr = attributes.get(EntitySpec.getMacrosParamId(macros))) != null) {
            return attr.toString();
        }
        return "";
    }

    public static Builder<EntitySpec> builderEntitySpec() {
        EntitySpec entitySpec;
        EntitySpec entitySpec2 = entitySpec = new EntitySpec();
        Objects.requireNonNull(entitySpec2);
        return new Builder(entitySpec2, entitySpec);
    }

    class EntityMacrosFormat
    extends MacrosFormat {
        EntityMacrosFormat(EntitySpec this$0) {
        }

        @Override
        protected Object invoke(String macros, Object[] args, Object[] globalArgs) {
            Object id;
            EntityAttr attr;
            Map<Integer, EntityAttr> entityAttributes;
            Entity entity = (Entity)globalArgs[0];
            if ("title".equals(macros)) {
                return entity.getTitle();
            }
            if ("attr".equals(macros) && (entityAttributes = entity.getEntityAttributes()) != null && (attr = (id = args[0]) instanceof Integer ? entityAttributes.get((Integer)id) : entityAttributes.get(Utils.parseInt(id.toString()))) != null) {
                return attr.toString();
            }
            return "";
        }
    }

    public class Builder<T extends EntitySpec> {
        private T spec;

        /*
         * WARNING - Possible parameter corruption
         */
        protected Builder(T spec) {
            this.spec = spec;
        }

        public Builder<T> setId(int id) {
            ((EntitySpec)this.spec).id = id;
            return this;
        }

        public Builder<T> setTitle(String title) {
            ((EntitySpec)this.spec).title = title;
            return this;
        }

        public Builder<T> setHidden(boolean hidden) {
            ((EntitySpec)this.spec).setHidden(hidden);
            return this;
        }

        public Builder<T> setModuleIds(Set<Integer> moduleIds) {
            ((EntitySpec)this.spec).setModuleIds(moduleIds);
            return this;
        }

        public Builder<T> setEntitySpecTypeId(int entitySpecTypeId) {
            ((EntitySpec)this.spec).setEntitySpecTypeId(entitySpecTypeId);
            return this;
        }

        public Builder<T> setEntityTitleMacros(String entityTitleMakros) {
            ((EntitySpec)this.spec).setEntityTitleMacros(entityTitleMakros);
            return this;
        }

        public Builder<T> setComment(String comment) {
            ((EntitySpec)this.spec).setComment(comment);
            return this;
        }

        public Builder<T> setAttributeList(List<? extends AbstractSpecAttr> attributes) {
            ((EntitySpec)this.spec).setAttributeList(attributes);
            return this;
        }

        public T build() {
            try {
                T t = this.spec;
                return t;
            }
            finally {
                this.spec = null;
            }
        }
    }
}

