/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.installer;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ModuleInstaller {
    private static String host;
    private static final FilesData LOCAL_FILES_DATA;
    private static final FilesData REMOTE_FILES_DATA;
    private static final String SERVER_DIRECTORY;
    private static List<String> downloadHosts;

    private static <T> HttpResponse<T> request(HttpClient httpClient, String url, HttpResponse.BodyHandler<T> responseBodyHandler, boolean checkStatusCode) throws IOException {
        try {
            System.out.println("\u0417\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u043c " + url);
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).build();
            HttpResponse<T> response = httpClient.send(request, responseBodyHandler);
            if (checkStatusCode && response.statusCode() >= 300) {
                System.err.println("[!] \u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 " + url + ": http code " + response.statusCode());
            }
            return response;
        }
        catch (Exception e) {
            System.err.println("[!] \u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 " + url + ": " + e.toString());
            throw new IOException("error request " + url);
        }
    }

    public static void main(String[] args) {
        downloadHosts = Arrays.asList(System.getProperty("bgbilling.server.url", "https://bgbilling.ru/download,https://download2.bgbilling.ru").split(","));
        Path filesDatPath = Paths.get(SERVER_DIRECTORY, "/data/files.dat");
        boolean newInstall = Files.notExists(Paths.get(SERVER_DIRECTORY, "lib", "server", "kernel-server.jar"), new LinkOption[0]);
        HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
        try {
            ModuleInstaller.parseFilesData(LOCAL_FILES_DATA, Files.readAllLines(filesDatPath));
            ModuleInstaller.selectDownloadHost();
            if ("current".equals(ModuleInstaller.LOCAL_FILES_DATA.set)) {
                ModuleInstaller.LOCAL_FILES_DATA.set = ModuleInstaller.request(httpClient, host + "/" + ModuleInstaller.LOCAL_FILES_DATA.version + "/current", HttpResponse.BodyHandlers.ofString(), true).body();
            }
            System.out.println("\u0412\u0435\u0440\u0441\u0438\u044f (version): " + ModuleInstaller.LOCAL_FILES_DATA.version);
            System.out.println("\u0421\u0431\u043e\u0440\u043a\u0430 (set): " + ModuleInstaller.LOCAL_FILES_DATA.set);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (newInstall) {
            System.out.println("\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u0430 \u043d\u043e\u0432\u0430\u044f \u0438\u043d\u0441\u0442\u0430\u043b\u043b\u044f\u0446\u0438\u044f...");
            try {
                if (!ModuleInstaller.checkVersionSet(httpClient)) {
                    System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0441\u043f\u0438\u0441\u043a\u0430 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u0441 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430...");
                    System.exit(1);
                }
                ModuleInstaller.downloadAndInstall(ModuleInstaller.LOCAL_FILES_DATA.set, ModuleInstaller.REMOTE_FILES_DATA.filesData.get("kernel"), httpClient, SERVER_DIRECTORY);
                ModuleInstaller.downloadAndInstall(ModuleInstaller.LOCAL_FILES_DATA.set, ModuleInstaller.REMOTE_FILES_DATA.filesData.get("updateLib"), httpClient, SERVER_DIRECTORY);
                System.out.println("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0432\u0441\u0435 \u043c\u043e\u0434\u0443\u043b\u0438 \u0438 \u043f\u043b\u0430\u0433\u0438\u043d\u044b \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0435 \u0432 \u0444\u0430\u0439\u043b\u0435 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0439 (yes/no)");
                System.out.print("=> ");
                String result = new BufferedReader(new InputStreamReader(System.in)).readLine();
                if ("yes".equals(result.toLowerCase())) {
                    Path licPath = Paths.get(SERVER_DIRECTORY, "/data/lic.properties");
                    if (Files.exists(licPath, new LinkOption[0]) && Files.isRegularFile(licPath, new LinkOption[0])) {
                        for (String line : Files.readAllLines(licPath)) {
                            if (!line.startsWith("licence.")) continue;
                            String name = line.split("=")[0];
                            name = name.substring(name.lastIndexOf(46) + 1);
                            System.out.println("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 -> " + name);
                            ModuleInstaller.downloadAndInstall(ModuleInstaller.LOCAL_FILES_DATA.set, ModuleInstaller.REMOTE_FILES_DATA.filesData.get(name), httpClient, SERVER_DIRECTORY);
                        }
                    } else {
                        System.out.println("\u0424\u0430\u0439\u043b \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0439 " + licPath.toString() + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d...");
                    }
                }
                ModuleInstaller.saveFilesData(filesDatPath);
            }
            catch (Exception e) {
                System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043d\u043e\u0432\u043e\u0439 \u0438\u043d\u0441\u0442\u0430\u043b\u043b\u044f\u0446\u0438\u0438:");
                e.printStackTrace();
            }
        }
        block21: while (true) {
            try {
                block22: while (true) {
                    switch (ModuleInstaller.selectMenu(List.of("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u044b\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b", "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b", "\u041f\u0435\u0440\u0435\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0442\u0435\u043a\u0443\u0449\u0438\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0432\u0435\u0440\u0441\u0438\u044e"), "\u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044e")) {
                        case "1": {
                            if (ModuleInstaller.checkVersionSet(httpClient)) {
                                ArrayList<String> menus = new ArrayList<String>();
                                for (FileData fileData : ModuleInstaller.REMOTE_FILES_DATA.filesData.values()) {
                                    if (fileData.name.startsWith("BG")) continue;
                                    boolean result = true;
                                    for (FileData localFileData : ModuleInstaller.LOCAL_FILES_DATA.filesData.values()) {
                                        if (!fileData.name.equals(localFileData.name)) continue;
                                        result = false;
                                        break;
                                    }
                                    if (!result) continue;
                                    menus.add(fileData.name);
                                }
                                String name = (String)menus.get(Integer.valueOf(ModuleInstaller.selectMenu(menus, "\u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442")) - 1);
                                ModuleInstaller.downloadAndInstall(ModuleInstaller.LOCAL_FILES_DATA.set, ModuleInstaller.REMOTE_FILES_DATA.filesData.get(name), httpClient, SERVER_DIRECTORY);
                                ModuleInstaller.saveFilesData(filesDatPath);
                                break;
                            }
                            System.out.println("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u043d\u043e\u0432\u044b\u0445 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u0434\u043b\u044f \u0432\u0430\u0448\u0435\u0439 \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0441\u043d\u0430\u0447\u0430\u043b\u0430 \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0434\u043e \u0431\u043e\u043b\u0435\u0435 \u043d\u043e\u0432\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438/\u0441\u0431\u043e\u0440\u043a\u0438");
                            break;
                        }
                        case "2": {
                            String listDat = ModuleInstaller.request(httpClient, host + "/" + ModuleInstaller.LOCAL_FILES_DATA.version + "/sets/list.dat", HttpResponse.BodyHandlers.ofString(), true).body();
                            if (listDat != null && !listDat.isEmpty()) {
                                ArrayList<String> sets = new ArrayList<String>();
                                long b = Long.valueOf(ModuleInstaller.LOCAL_FILES_DATA.set);
                                Stream.of(listDat.split("\n")).filter(a -> Long.valueOf(a) > b).sorted(Comparator.reverseOrder()).forEach(a -> sets.add((String)a));
                                if (!sets.isEmpty()) {
                                    ModuleInstaller.LOCAL_FILES_DATA.set = (String)sets.get(Integer.valueOf(ModuleInstaller.selectMenu(sets, "c\u0431\u043e\u0440\u043a\u0443")) - 1);
                                    ModuleInstaller.parseFilesData(REMOTE_FILES_DATA, Arrays.asList(ModuleInstaller.request(httpClient, host + "/" + ModuleInstaller.LOCAL_FILES_DATA.version + "/sets/" + ModuleInstaller.LOCAL_FILES_DATA.set + "/files.dat", HttpResponse.BodyHandlers.ofString(), true).body().split("\n")));
                                    Iterator<FileData> iterator = ModuleInstaller.LOCAL_FILES_DATA.filesData.values().iterator();
                                    while (true) {
                                        if (!iterator.hasNext()) continue block21;
                                        FileData fileData = iterator.next();
                                        if (fileData.name.startsWith("BG")) continue;
                                        ModuleInstaller.downloadAndInstall(ModuleInstaller.LOCAL_FILES_DATA.set, ModuleInstaller.REMOTE_FILES_DATA.filesData.get(fileData.name), httpClient, SERVER_DIRECTORY);
                                        ModuleInstaller.saveFilesData(filesDatPath);
                                    }
                                }
                                System.out.printf("\n\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0439 \u0434\u043b\u044f [%s] \u043d\u0435\u0442 (\u0432\u0430\u0448\u0430 %s \u0441\u0430\u043c\u0430\u044f \u0441\u0432\u0435\u0436\u0430\u044f)...\n", ModuleInstaller.LOCAL_FILES_DATA.version, ModuleInstaller.LOCAL_FILES_DATA.set);
                                break;
                            }
                            System.out.printf("\n\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c, \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u0441\u043f\u0438\u0441\u043e\u043a \u0441\u0431\u043e\u0440\u043e\u043a \u0434\u043b\u044f \u0432\u0430\u0448\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 [%s]\n", ModuleInstaller.LOCAL_FILES_DATA.version);
                            break;
                        }
                        case "3": {
                            Object fileData;
                            int pos = 1;
                            System.out.println("\n\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b:");
                            Iterator<FileData> b = ModuleInstaller.LOCAL_FILES_DATA.filesData.values().iterator();
                            while (true) {
                                if (!b.hasNext()) continue block21;
                                fileData = b.next();
                                System.out.println(String.format("%2d) %-20s [checkSum: %s  zip: %s]", pos, ((FileData)fileData).name, ((FileData)fileData).checkSum, ((FileData)fileData).zipName));
                                ++pos;
                            }
                        }
                        case "4": {
                            Object fileData;
                            String listDat = ModuleInstaller.request(httpClient, host + "/" + ModuleInstaller.LOCAL_FILES_DATA.version + "/sets/list.dat", HttpResponse.BodyHandlers.ofString(), true).body();
                            if (listDat != null && !listDat.isEmpty()) {
                                List<String> sets = Arrays.asList(listDat.split("\n"));
                                if (sets.contains(ModuleInstaller.LOCAL_FILES_DATA.set)) {
                                    ModuleInstaller.parseFilesData(REMOTE_FILES_DATA, Arrays.asList(ModuleInstaller.request(httpClient, host + "/" + ModuleInstaller.LOCAL_FILES_DATA.version + "/sets/" + ModuleInstaller.LOCAL_FILES_DATA.set + "/files.dat", HttpResponse.BodyHandlers.ofString(), true).body().split("\n")));
                                    fileData = ModuleInstaller.LOCAL_FILES_DATA.filesData.values().iterator();
                                    while (true) {
                                        if (!fileData.hasNext()) continue block21;
                                        FileData fileData2 = (FileData)fileData.next();
                                        if (fileData2.name.startsWith("BG")) continue;
                                        ModuleInstaller.downloadAndInstall(ModuleInstaller.LOCAL_FILES_DATA.set, ModuleInstaller.REMOTE_FILES_DATA.filesData.get(fileData2.name), httpClient, SERVER_DIRECTORY);
                                        ModuleInstaller.saveFilesData(filesDatPath);
                                    }
                                }
                                System.out.printf("\n\u041f\u0435\u0440\u0435\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c, \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b \u0432\u0430\u0448\u0435\u0439 \u0441\u0431\u043e\u0440\u043a\u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b \u0434\u043b\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 [%s-%s]\n", ModuleInstaller.LOCAL_FILES_DATA.version, ModuleInstaller.LOCAL_FILES_DATA.set);
                                break;
                            }
                            System.out.printf("\n\u041f\u0435\u0440\u0435\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c, \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u0441\u043f\u0438\u0441\u043e\u043a \u0441\u0431\u043e\u0440\u043e\u043a \u0434\u043b\u044f \u0432\u0430\u0448\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 [%s]\n", ModuleInstaller.LOCAL_FILES_DATA.version);
                            break;
                        }
                        case "5": {
                            String versions = ModuleInstaller.request(httpClient, host + "/versions.dat", HttpResponse.BodyHandlers.ofString(), true).body();
                            if (versions.isEmpty() || "beta".equals(ModuleInstaller.LOCAL_FILES_DATA.version)) continue block22;
                            BigDecimal ver = new BigDecimal(ModuleInstaller.LOCAL_FILES_DATA.version);
                            List<String> versionList = List.of(versions.split("\n")).stream().filter(a -> new BigDecimal((String)a).compareTo(ver) > 0).toList();
                            String selNum = ModuleInstaller.selectMenu(versionList, "\u0432\u0435\u0440\u0441\u0438\u044e");
                            if ("0".equals(selNum)) break;
                            ModuleInstaller.LOCAL_FILES_DATA.version = versionList.get(Integer.valueOf(selNum) - 1);
                            ModuleInstaller.LOCAL_FILES_DATA.set = ModuleInstaller.request(httpClient, host + "/" + ModuleInstaller.LOCAL_FILES_DATA.version + "/current", HttpResponse.BodyHandlers.ofString(), true).body();
                            String listDat = ModuleInstaller.request(httpClient, host + "/" + ModuleInstaller.LOCAL_FILES_DATA.version + "/sets/list.dat", HttpResponse.BodyHandlers.ofString(), true).body();
                            if (listDat != null && !listDat.isEmpty()) {
                                List<String> sets = Arrays.asList(listDat.split("\n"));
                                if (sets.contains(ModuleInstaller.LOCAL_FILES_DATA.set)) {
                                    ModuleInstaller.parseFilesData(REMOTE_FILES_DATA, Arrays.asList(ModuleInstaller.request(httpClient, host + "/" + ModuleInstaller.LOCAL_FILES_DATA.version + "/sets/" + ModuleInstaller.LOCAL_FILES_DATA.set + "/files.dat", HttpResponse.BodyHandlers.ofString(), true).body().split("\n")));
                                    for (FileData fileData : ModuleInstaller.LOCAL_FILES_DATA.filesData.values()) {
                                        if (fileData.name.startsWith("BG")) continue;
                                        ModuleInstaller.downloadAndInstall(ModuleInstaller.LOCAL_FILES_DATA.set, ModuleInstaller.REMOTE_FILES_DATA.filesData.get(fileData.name), httpClient, SERVER_DIRECTORY);
                                        ModuleInstaller.saveFilesData(filesDatPath);
                                    }
                                } else {
                                    System.out.printf("\n\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c, \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b \u0432\u0430\u0448\u0435\u0439 \u0441\u0431\u043e\u0440\u043a\u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b \u0434\u043b\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 [%s-%s]\n", ModuleInstaller.LOCAL_FILES_DATA.version, ModuleInstaller.LOCAL_FILES_DATA.set);
                                }
                            } else {
                                System.out.printf("\n\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c, \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u0441\u043f\u0438\u0441\u043e\u043a \u0441\u0431\u043e\u0440\u043e\u043a \u0434\u043b\u044f \u0432\u0430\u0448\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 [%s]\n", ModuleInstaller.LOCAL_FILES_DATA.version);
                            }
                            ModuleInstaller.saveFilesData(filesDatPath);
                        }
                    }
                }
            }
            catch (Exception ex) {
                System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438/\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438:");
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static String selectMenu(List<String> list, String selectText) throws IOException {
        String result;
        int max = list.isEmpty() ? 0 : list.stream().map(String::length).max(Integer::compare).get();
        int allCol = 80 / (max + 5);
        System.out.println("\n\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435" + (String)(selectText != null ? " " + selectText : "") + ":");
        while (true) {
            int allRow = list.size() / allCol + (list.size() % allCol > 0 ? 1 : 0);
            for (int row = 0; row < allRow; ++row) {
                int pos;
                for (int col = 0; col < allCol && (pos = col * allRow + row + 1) <= list.size(); ++col) {
                    System.out.printf("%2d) %-" + (max + 1) + "s", pos, list.get(pos - 1));
                }
                System.out.println();
            }
            System.out.println(" 0) \u0412\u044b\u0445\u043e\u0434");
            System.out.print("=> ");
            result = new BufferedReader(new InputStreamReader(System.in)).readLine();
            if (result.matches("^[0-9]+$") && Integer.valueOf(result) <= list.size()) break;
            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0432\u043e\u0434\u0430, \u043f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u0435...\n");
        }
        if ("0".equals(result)) {
            ModuleInstaller.processExit();
        }
        return result;
    }

    private static void processExit() throws IOException {
        ModuleInstaller.updateDynIgnoreFile();
        ModuleInstaller.buildLibs();
        System.exit(0);
    }

    private static void updateDynIgnoreFile() throws IOException {
        ArrayList<String> installedModules = new ArrayList<String>();
        Path componentsDir = Paths.get(SERVER_DIRECTORY, "/components");
        if (!Files.exists(componentsDir, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> components = Files.list(componentsDir);){
            installedModules.addAll(components.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(Path::getFileName).map(Path::toString).toList());
        }
        ArrayList excludedClasses = new ArrayList();
        Path dynDir = Paths.get(SERVER_DIRECTORY, "/dyn");
        if (!Files.exists(dynDir, new LinkOption[0])) {
            System.out.println("Not found: " + String.valueOf(dynDir));
            return;
        }
        try (Stream<Path> dynCodeFiles = Files.walk(dynDir, new FileVisitOption[0]);){
            dynCodeFiles.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(f -> {
                try (Stream<String> lines = Files.lines(f, StandardCharsets.ISO_8859_1);){
                    String[] requiredModules;
                    String firstLine = lines.findFirst().orElse("");
                    if (firstLine.contains("//@bg_required=") && Arrays.stream(requiredModules = firstLine.substring(firstLine.indexOf("=") + 1).split(",")).anyMatch(m -> !installedModules.contains(m))) {
                        excludedClasses.add(f.getFileName().toString());
                    }
                }
                catch (Exception ex) {
                    System.out.println(f.toString() + " => " + ex.getMessage());
                    ex.printStackTrace();
                }
            });
        }
        Path dynIgnoreFile = Paths.get(SERVER_DIRECTORY, "/data/dyn_ignore");
        if (!Files.exists(dynIgnoreFile, new LinkOption[0])) {
            Files.createFile(dynIgnoreFile, new FileAttribute[0]);
        }
        Files.write(dynIgnoreFile, new byte[0], new OpenOption[0]);
        Files.write(dynIgnoreFile, excludedClasses, new OpenOption[0]);
    }

    private static void buildLibs() {
        System.out.println("\n\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\n");
        Path libConfPath = Paths.get(SERVER_DIRECTORY, "/lib.conf.d");
        if (Files.isDirectory(libConfPath, new LinkOption[0])) {
            HashSet libInfos = new HashSet();
            try (Stream<Path> libConfigs = Files.list(libConfPath);){
                libConfigs.forEach(libConfigPath -> {
                    if (Files.isRegularFile(libConfigPath, new LinkOption[0])) {
                        try (Stream<String> lines = Files.lines(libConfigPath);){
                            lines.forEach(libInfos::add);
                        }
                        catch (IOException e) {
                            System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f " + libConfigPath.toString() + ":");
                            e.printStackTrace();
                        }
                    }
                });
                ArrayList<String> mavenUrls = new ArrayList<String>();
                Path mavenUrlPath = Paths.get(SERVER_DIRECTORY, "/data/maven.url");
                if (Files.isRegularFile(mavenUrlPath, new LinkOption[0])) {
                    mavenUrls.addAll(Files.readAllLines(mavenUrlPath));
                }
                if (Files.isRegularFile(mavenUrlPath = Paths.get(SERVER_DIRECTORY, "/data/maven.url.custom"), new LinkOption[0])) {
                    mavenUrls.addAll(Files.readAllLines(mavenUrlPath));
                }
                if (mavenUrls.isEmpty()) {
                    System.out.println("\u0421\u043f\u0438\u0441\u043e\u043a maven.url \u043f\u0443\u0441\u0442\u043e\u0439....");
                    return;
                }
                Path cachePath = Paths.get(SERVER_DIRECTORY, "/.cache");
                if (!Files.exists(cachePath, new LinkOption[0])) {
                    Files.createDirectory(cachePath, new FileAttribute[0]);
                }
                if (!Files.isDirectory(cachePath, new LinkOption[0])) {
                    System.out.println(String.valueOf(cachePath) + " \u043d\u0435 \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044f...");
                    return;
                }
                HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(3L)).build();
                HashMap<String, List> libs = new HashMap<String, List>();
                for (String libInfo : libInfos) {
                    String[] data = libInfo.split("\t");
                    if (data.length <= 1) continue;
                    String[] libData = data[0].split(":");
                    if (libData.length != 3) {
                        System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0441\u0438\u043d\u0433\u0430 \u0441\u0442\u0440\u043e\u043a\u0438 - " + libInfo);
                        continue;
                    }
                    Path libPath = Paths.get(cachePath.toString(), "/", libData[0], "/", libData[1] + "-" + libData[2] + ".jar");
                    if (Files.notExists(libPath, new LinkOption[0])) {
                        if (Files.notExists(libPath.getParent(), new LinkOption[0])) {
                            Files.createDirectories(libPath.getParent(), new FileAttribute[0]);
                        }
                        for (String mavenUrl : mavenUrls) {
                            String libUrl = mavenUrl + libData[0].replace('.', '/') + "/" + libData[1] + "/" + libData[2] + "/" + libData[1] + "-" + libData[2] + ".jar";
                            try {
                                HttpResponse<byte[]> response = ModuleInstaller.request(httpClient, libUrl, HttpResponse.BodyHandlers.ofByteArray(), false);
                                if (response.statusCode() != 200) continue;
                                Files.write(libPath, response.body(), new OpenOption[0]);
                                break;
                            }
                            catch (IOException e) {
                                System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 - " + e.toString());
                            }
                        }
                        if (Files.notExists(libPath, new LinkOption[0])) {
                            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 - \u0444\u0430\u0439\u043b \u043d\u0435 \u0441\u043a\u0430\u0447\u0430\u043b\u0441\u044f? - " + String.valueOf(libPath));
                            return;
                        }
                    }
                    List paths = libs.getOrDefault(data[1], new ArrayList());
                    paths.add(libPath);
                    libs.put(data[1], paths);
                }
                for (String libDir : libs.keySet()) {
                    if (!libDir.startsWith("lib/")) continue;
                    Path libDirPath = Paths.get(SERVER_DIRECTORY, libDir);
                    if (Files.isDirectory(libDirPath, new LinkOption[0])) {
                        try (Stream<Path> libDirPaths = Files.list(libDirPath);){
                            libDirPaths.forEach(dir -> {
                                try {
                                    Files.delete(dir);
                                }
                                catch (IOException e) {
                                    System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f " + String.valueOf(dir) + ":");
                                    e.printStackTrace();
                                }
                            });
                        }
                    }
                    for (Path libPath : (List)libs.get(libDir)) {
                        Path toPath = Paths.get(libDirPath.toString(), libPath.getFileName().toString());
                        if (Files.notExists(toPath.getParent(), new LinkOption[0])) {
                            Files.createDirectories(toPath.getParent(), new FileAttribute[0]);
                        }
                        Files.copy(libPath, toPath, new CopyOption[0]);
                    }
                }
            }
            catch (IOException e) {
                System.err.println("\u041e\u0431\u0449\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438:");
                e.printStackTrace();
            }
        } else {
            System.out.println("\u041a\u0430\u0442\u0430\u043b\u043e\u0433 " + String.valueOf(libConfPath) + " \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442...");
        }
    }

    private static void saveFilesData(Path filesDatPath) throws IOException {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("version:" + ModuleInstaller.LOCAL_FILES_DATA.version + "\n");
        stringWriter.write("set:" + ModuleInstaller.LOCAL_FILES_DATA.set + "\n");
        ModuleInstaller.LOCAL_FILES_DATA.filesData.values().forEach(fd -> stringWriter.write(String.format("name:%s\tzipName:%s\tcheckSum:%s\tsize:%s\n", fd.name, fd.zipName, fd.checkSum, fd.size)));
        Files.writeString(filesDatPath, (CharSequence)stringWriter.toString(), new OpenOption[0]);
    }

    private static void downloadAndInstall(String set, FileData fileData, HttpClient httpClient, String serverDirectory) throws IOException, InterruptedException {
        if (fileData == null) {
            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430 fileData = null");
            return;
        }
        HttpResponse<InputStream> fileResponse = ModuleInstaller.request(httpClient, host + "/" + ModuleInstaller.LOCAL_FILES_DATA.version + "/sets/" + set + "/" + fileData.zipName, HttpResponse.BodyHandlers.ofInputStream(), true);
        ZipInputStream zipInputStream = new ZipInputStream(fileResponse.body());
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            Path path = Paths.get(serverDirectory, zipEntry.getName());
            if (zipEntry.isDirectory()) {
                if (zipEntry.getName().matches(".*lib[\\\\/]+ext[/\\\\]+(client|server|common)[\\\\/]+") && Files.exists(path, new LinkOption[0])) {
                    try (Stream<Path> s = Files.walk(path, new FileVisitOption[0]);){
                        s.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                    }
                }
                Files.createDirectories(path, new FileAttribute[0]);
            } else {
                byte[] oldBytes;
                if (!zipEntry.getName().endsWith(".jar")) {
                    Path origPath = Paths.get(String.valueOf(path) + ".orig", new String[0]);
                    path = Files.exists(origPath, new LinkOption[0]) ? origPath : path;
                }
                byte[] newBytes = zipInputStream.readAllBytes();
                byte[] byArray = oldBytes = Files.exists(path, new LinkOption[0]) ? Files.readAllBytes(path) : null;
                if (oldBytes == null || newBytes.length != oldBytes.length || !Arrays.equals(newBytes, oldBytes)) {
                    Files.write(path, newBytes, new OpenOption[0]);
                    System.out.println("\t" + zipEntry.getName() + " to " + String.valueOf(path));
                }
            }
            zipEntry = zipInputStream.getNextEntry();
        }
        ModuleInstaller.LOCAL_FILES_DATA.filesData.put(fileData.name, fileData);
    }

    private static void parseFilesData(FilesData localFilesData, List<String> lines) {
        LinkedHashMap<String, FileData> map = new LinkedHashMap<String, FileData>();
        if (lines != null && !lines.isEmpty()) {
            for (String line : lines) {
                if (line.startsWith("version:")) {
                    localFilesData.version = line.substring(8);
                    continue;
                }
                if (line.startsWith("set:")) {
                    localFilesData.set = line.substring(4);
                    continue;
                }
                FileData fileData = new FileData();
                for (String name : line.split("\t")) {
                    if (name.startsWith("name:")) {
                        fileData.name = name.substring(5);
                        continue;
                    }
                    if (name.startsWith("zipName:")) {
                        fileData.zipName = name.substring(8);
                        continue;
                    }
                    if (name.startsWith("checkSum:")) {
                        fileData.checkSum = name.substring(9);
                        continue;
                    }
                    if (!name.startsWith("size:")) continue;
                    fileData.size = Long.valueOf(name.substring(5));
                }
                map.put(fileData.name, fileData);
            }
        }
        localFilesData.filesData = map;
    }

    private static boolean checkVersionSet(HttpClient httpClient) {
        try {
            HttpResponse<String> response = ModuleInstaller.request(httpClient, host + "/" + ModuleInstaller.LOCAL_FILES_DATA.version + "/sets/" + ModuleInstaller.LOCAL_FILES_DATA.set + "/files.dat", HttpResponse.BodyHandlers.ofString(), true);
            if (response.statusCode() != 200) {
                return false;
            }
            ModuleInstaller.parseFilesData(REMOTE_FILES_DATA, Arrays.asList(response.body().split("\n")));
        }
        catch (Exception ex) {
            System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 checkVersionSet:");
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    private static void selectDownloadHost() {
        HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(2L)).build();
        for (String testHost : downloadHosts) {
            try {
                ModuleInstaller.request(httpClient, testHost + "/" + ModuleInstaller.LOCAL_FILES_DATA.version + "/current", HttpResponse.BodyHandlers.ofString(), true).body();
                host = testHost;
                break;
            }
            catch (Exception ex) {
                System.err.println("\u0421\u0435\u0440\u0432\u0435\u0440 " + testHost + ": " + ex.getLocalizedMessage());
            }
        }
    }

    static {
        LOCAL_FILES_DATA = new FilesData();
        REMOTE_FILES_DATA = new FilesData();
        SERVER_DIRECTORY = System.getProperty("bgbilling.server.directory", System.getProperty("bgbiling.server.directory", "."));
    }

    public static class FilesData {
        public String version = "beta";
        public String set = "current";
        public LinkedHashMap<String, FileData> filesData = null;
    }

    public static class FileData {
        public String name;
        public String zipName;
        public String checkSum;
        public long size;
    }
}

