/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common.table.renderer;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.kernel.table.client.BGDataSourceTableModel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;

public class HorizontalAlignmentTableCellRenderer
extends DefaultTableCellRenderer {
    private boolean color = false;

    public HorizontalAlignmentTableCellRenderer() {
        this(2);
    }

    public HorizontalAlignmentTableCellRenderer(int horizontalAlignment) {
        this(horizontalAlignment, false);
    }

    public HorizontalAlignmentTableCellRenderer(int horizontalAlignment, boolean color) {
        this.color = color;
        this.setHorizontalAlignment(horizontalAlignment);
    }

    public static HorizontalAlignmentTableCellRenderer LEFT() {
        return new HorizontalAlignmentTableCellRenderer(2);
    }

    public static HorizontalAlignmentTableCellRenderer CENTER() {
        return new HorizontalAlignmentTableCellRenderer(0);
    }

    public static HorizontalAlignmentTableCellRenderer RIGHT() {
        return new HorizontalAlignmentTableCellRenderer(4);
    }

    public static HorizontalAlignmentTableCellRenderer COLOR_CENTER() {
        return new HorizontalAlignmentTableCellRenderer(0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TableModel tableModel;
        Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (this.color && (tableModel = table.getModel()) instanceof BGDataSourceTableModel) {
            BGDataSourceTableModel model = (BGDataSourceTableModel)tableModel;
            try {
                String name = model.getBGUTableColumns().get(column).getName();
                ((BGUTableRowData)model.getRows().get(row)).getValues().stream().filter(a -> name.equals(a.getName())).findFirst().map(a -> a.getColor()).ifPresent(a -> ((JLabel)component).setBackground(new Color(Integer.parseInt(a, 10))));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        return this;
    }
}

