/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.admin.resource;

import bitel.billing.module.admin.resource.CategoryEditor;
import bitel.billing.module.admin.resource.IPResourceManager;
import bitel.billing.module.admin.resource.ResourceCategoriesTreePanel;
import bitel.billing.module.admin.resource.ResourceUseHistory;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JTabbedPane;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;

public class IPResourcePanel
extends ServiceConfigTabbedPanel {
    private JTabbedPane tabbedPanel = new JTabbedPane();
    private IPResourceCategoriesTreePanel categoriesEditor = new IPResourceCategoriesTreePanel(true);
    private IPResourceManager resourceManager = new IPResourceManager();

    public IPResourcePanel() {
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.tabbedPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tabbedPanel.addTab("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438", this.categoriesEditor);
        this.tabbedPanel.addTab("\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435", this.resourceManager);
        this.tabbedPanel.addChangeListener(e -> this.setData());
    }

    @Override
    public void setData() {
        ((BGPanel)this.tabbedPanel.getComponentAt(this.tabbedPanel.getSelectedIndex())).trySetData();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ((BGPanel)this.tabbedPanel.getComponentAt(this.tabbedPanel.getSelectedIndex())).actionPerformed(e);
    }

    @Override
    public void init(String module, int mid) {
        if (!this.init) {
            super.init("admin.resource", mid);
            this.categoriesEditor.init("admin.resource", mid);
            this.resourceManager.init("admin.resource", mid);
        }
    }

    public static class IPResourceCategoriesTreePanel
    extends ResourceCategoriesTreePanel {
        public IPResourceCategoriesTreePanel(boolean isEdit) {
            super(isEdit);
        }

        @Override
        protected void init() {
            this.actionPrefix = "IPResourceCategory";
            this.editorPanel = new IPCategoryEditor();
        }
    }

    public static class IPResourceUseHistory
    extends ResourceUseHistory {
        private long ip1;
        private long ip2;
        private int itemId;

        public final void setIp1(String ip1) {
            this.ip1 = IPUtils.convertStringIPtoLong(ip1, 0L);
        }

        public final void setIp2(String ip2) {
            this.ip2 = IPUtils.convertStringIPtoLong(ip2, 0L);
        }

        public final void setItemId(String itemId) {
            this.itemId = Utils.parseInt(itemId);
        }

        @Override
        protected void init() {
            this.table.setHeader(this.rb_name, this.moduleDoc, "ip_resource_history");
            this.actionName = "IPResourceUseHistory";
        }

        @Override
        protected Request getRequest() {
            Request req = super.getRequest();
            req.setAttribute("item_id", String.valueOf(this.itemId));
            req.setAttribute("ip1", String.valueOf(this.ip1));
            req.setAttribute("ip2", String.valueOf(this.ip2));
            return req;
        }
    }

    public static class IPCategoryEditor
    extends CategoryEditor {
        @Override
        protected void init() {
            this.actionPrefix = "IPResourceCategory";
        }
    }
}

