/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.bean;

import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Result;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResource;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceSubscription;
import ru.bitel.oss.systems.inventory.resource.server.bean.IpResourceDao;
import ru.bitel.oss.systems.inventory.resource.server.bean.IpResourceSubscriptionRuntime;

public class IpResourceSubscriptionDao
extends AbstractIdDao<IpResourceSubscription> {
    public IpResourceSubscriptionDao(Connection con, int moduleId) {
        this(con, "inv_ip_resource_subscription", moduleId);
    }

    protected IpResourceSubscriptionDao(Connection con, String tableName, int moduleId) {
        super(con, tableName, moduleId);
    }

    protected IpResourceSubscription getFromRS(ResultSet rs) throws SQLException {
        return this.getSubscriptionFromRS("", rs);
    }

    protected IpResourceSubscription getSubscriptionFromRS(String prefix, ResultSet rs) throws SQLException {
        return IpResourceSubscription.builder().setId(rs.getInt(prefix + "id")).setIpResourseId(rs.getInt(prefix + "ipResourceId")).setAddressFrom(rs.getBytes(prefix + "addressFrom")).setAddressTo(rs.getBytes(prefix + "addressTo")).setDateFrom(TimeUtils.convertSqlDateToDate((Date)rs.getDate(prefix + "dateFrom"))).setDateTo(TimeUtils.convertSqlDateToDate((Date)rs.getDate(prefix + "dateTo"))).setSubscriberId(rs.getInt(prefix + "subscriberId")).setSubscriberTitle(rs.getString(prefix + "subscriberTitle")).build();
    }

    public List<IpResourceSubscription> list(int ipResourceId, java.util.Date dateFrom, java.util.Date dateTo) throws SQLException {
        Date sqlDateFrom = TimeUtils.convertDateToSqlDate((java.util.Date)dateFrom);
        Date sqlDateTo = TimeUtils.convertDateToSqlDate((java.util.Date)dateTo);
        return this.list("ipResourceId=? AND (dateTo IS NULL OR ? IS NULL OR dateTo>=?) AND (dateFrom IS NULL OR ? IS NULL OR dateFrom<=?)", "addressFrom", new Object[]{ipResourceId, sqlDateFrom, sqlDateFrom, sqlDateTo, sqlDateTo});
    }

    public List<IpResourceSubscriptionRuntime> listRuntime(int ipResourceId, java.util.Date dateFrom, java.util.Date dateTo) throws SQLException {
        String query = "SELECT id, addressFrom, addressTo FROM " + this.tableName + " WHERE ipResourceId=?  AND (dateTo IS NULL OR ? IS NULL OR dateTo>=?)  AND (dateFrom IS NULL OR ? IS NULL OR dateFrom<=?) ORDER BY addressFrom";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ArrayList<IpResourceSubscriptionRuntime> result = new ArrayList<IpResourceSubscriptionRuntime>(100);
            Date dateFromSql = TimeUtils.convertDateToSqlDate((java.util.Date)dateFrom);
            Date dateToSql = TimeUtils.convertDateToSqlDate((java.util.Date)dateTo);
            ps.setInt(1, ipResourceId);
            ps.setDate(2, dateFromSql);
            ps.setDate(3, dateFromSql);
            ps.setDate(4, dateToSql);
            ps.setDate(5, dateToSql);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    IpResourceSubscriptionRuntime runtime = new IpResourceSubscriptionRuntime(rs.getInt(1), rs.getBytes(2), rs.getBytes(3));
                    result.add(runtime);
                }
            }
            ArrayList<IpResourceSubscriptionRuntime> arrayList = result;
            return arrayList;
        }
    }

    public Result<IpResourceSubscription> list(int ipResourceId, java.util.Date dateFrom, java.util.Date dateTo, Page page) throws SQLException {
        Date sqlDateFrom = TimeUtils.convertDateToSqlDate((java.util.Date)dateFrom);
        Date sqlDateTo = TimeUtils.convertDateToSqlDate((java.util.Date)dateTo);
        return this.list(page, "ipResourceId=? AND (dateTo IS NULL OR ? IS NULL OR dateTo>=?) AND (dateFrom IS NULL OR ? IS NULL OR dateFrom<=?)", "addressFrom", new Object[]{ipResourceId, sqlDateFrom, sqlDateFrom, sqlDateTo, sqlDateTo});
    }

    protected void updateImpl(IpResourceSubscription ipResourceSubscription) throws SQLException {
        String querySet = "ipResourceId=?, addressFrom=?, addressTo=?, dateFrom=?, dateTo=?, subscriberId=?, subscriberTitle=?";
        try (PreparedStatement ps = this.prepareStatement((Id)ipResourceSubscription, querySet);){
            int index = 1;
            ps.setInt(index++, ipResourceSubscription.getIpResourseId());
            ps.setBlob(index++, new ByteArrayInputStream(ipResourceSubscription.getAddressFrom()));
            ps.setBlob(index++, new ByteArrayInputStream(ipResourceSubscription.getAddressTo()));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((java.util.Date)ipResourceSubscription.getDateFrom()));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((java.util.Date)ipResourceSubscription.getDateTo()));
            ps.setInt(index++, ipResourceSubscription.getSubscriberId());
            ps.setString(index++, ipResourceSubscription.getSubscriberTitle());
            this.executeUpdate((Id)ipResourceSubscription, index, ps);
        }
    }

    public int deleteBySubsciberId(int subscriberId) throws BGException {
        try {
            return this.delete("subscriberId=?", new Object[]{subscriberId});
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public IpResourceSubscription findSubscribed(int subscriberId) throws SQLException {
        return (IpResourceSubscription)this.get("subscriberId=?", new Object[]{subscriberId});
    }

    public Object[] findFree(Collection<Integer> ipResourceCategoryIds, int ipResourceId, byte[] addressFrom, byte[] addressTo, java.util.Date dateFrom, java.util.Date dateTo, int subscriberId) throws SQLException {
        return this.find(ipResourceCategoryIds, ipResourceId, addressFrom, addressTo, dateFrom, dateTo, subscriberId, true);
    }

    public Object[] findSubscribed(Set<Integer> ipResourceCategoryIds, int ipResourceId, byte[] addressFrom, byte[] addressTo, java.util.Date dateFrom, java.util.Date dateTo, int subscriberId) throws SQLException {
        return this.find(ipResourceCategoryIds, ipResourceId, addressFrom, addressTo, dateFrom, dateTo, subscriberId, false);
    }

    private Object[] find(Collection<Integer> ipResourceCategoryIds, int ipResourceId, byte[] addressFrom, byte[] addressTo, java.util.Date dateFrom, java.util.Date dateTo, int subscriberId, boolean free) throws SQLException {
        StringBuilder sb = new StringBuilder(100);
        sb.append("SELECT resource.*, subscription.* FROM inv_ip_resource_" + this.moduleId + " as resource LEFT JOIN " + this.tableName + " as subscription ON subscription.ipResourceId=resource.id AND (subscription.dateFrom IS NULL OR ? IS NULL OR subscription.dateFrom<=?) AND (subscription.dateTo IS NULL OR subscription.dateTo>=?)");
        if (free) {
            sb.append(" AND (subscription.addressFrom IS NULL OR subscription.addressFrom<=?) AND (subscription.addressTo IS NULL OR subscription.addressTo>=?)");
        } else {
            sb.append(" AND (subscription.addressFrom=?) AND (subscription.addressTo=?)");
        }
        sb.append(" WHERE 1=1");
        if (ipResourceCategoryIds != null && ipResourceCategoryIds.size() > 0) {
            sb.append(" AND resource.categoryId IN (").append(Utils.toString(ipResourceCategoryIds)).append(")");
        }
        if (!free && subscriberId > 0) {
            sb.append(" AND subscription.subscriberId=").append(subscriberId);
        }
        if (ipResourceId > 0) {
            sb.append(" AND resource.id=").append(ipResourceId);
        }
        sb.append(" AND (resource.dateFrom IS NULL OR resource.dateFrom<=?) AND (resource.dateTo IS NULL OR (? IS NOT NULL AND resource.dateTo>=?)) AND (resource.addressFrom IS NULL OR resource.addressFrom<=?) AND (resource.addressTo IS NULL OR resource.addressTo>=?) ORDER BY resource.id");
        try (PreparedStatement ps = this.con.prepareStatement(sb.toString());){
            Date dateFromSql = TimeUtils.convertDateToSqlDate((java.util.Date)dateFrom);
            Date dateToSql = TimeUtils.convertDateToSqlDate((java.util.Date)dateTo);
            ps.setDate(1, dateToSql);
            ps.setDate(2, dateToSql);
            ps.setDate(3, dateFromSql);
            if (free) {
                ps.setBlob(4, new ByteArrayInputStream(addressTo));
                ps.setBlob(5, new ByteArrayInputStream(addressFrom));
            } else {
                ps.setBlob(4, new ByteArrayInputStream(addressFrom));
                ps.setBlob(5, new ByteArrayInputStream(addressTo));
            }
            ps.setDate(6, dateFromSql);
            ps.setDate(7, dateToSql);
            ps.setDate(8, dateToSql);
            ps.setBlob(9, new ByteArrayInputStream(addressFrom));
            ps.setBlob(10, new ByteArrayInputStream(addressTo));
            int currentIpResourceId = -1;
            boolean skip = false;
            IpResourceDao ipResourceDao = new IpResourceDao(this.con, this.moduleId);
            HashMap map = new HashMap();
            String conflictsubscriberTitle = null;
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int oldIpResourceId = rs.getInt("resource.id");
                    if (currentIpResourceId != oldIpResourceId) {
                        skip = false;
                        currentIpResourceId = oldIpResourceId;
                    } else if (skip) continue;
                    IpResource resource = ipResourceDao.getIpResourceFromRS("resource.", rs);
                    ArrayList<IpResourceSubscription> list = (ArrayList<IpResourceSubscription>)map.get(currentIpResourceId);
                    if (list == null) {
                        list = new ArrayList<IpResourceSubscription>();
                        map.put(resource, list);
                    }
                    if (rs.getInt("subscription.id") == 0) continue;
                    if (subscriberId == rs.getInt("subscription.subscriberId")) {
                        list.add(this.getSubscriptionFromRS("subscription.", rs));
                        continue;
                    }
                    conflictsubscriberTitle = rs.getString("subscription.subscriberTitle");
                    map.remove(resource);
                    skip = true;
                }
            }
            Iterator iterator = map.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry e = iterator.next();
                List list = (List)e.getValue();
                Object[] objectArray = new Object[]{e.getKey(), list.size() > 0 ? list.get(0) : null};
                return objectArray;
            }
            if (free && conflictsubscriberTitle != null) {
                throw new BGRuntimeException("\u0414\u0430\u043d\u043d\u044b\u0439 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d ip \u043f\u0435\u0440\u0435\u0441\u0435\u043a\u0430\u0435\u0442\u0441\u044f \u0441 \u043f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u043e\u043c: " + conflictsubscriberTitle);
            }
        }
        return null;
    }

    protected static IpResourceSubscription getSubscriptionFromRS(ResultSet rs) throws SQLException {
        return IpResourceSubscription.builder().setId(rs.getInt("subscription.id")).setIpResourseId(rs.getInt("subscription.ipResourceId")).setAddressFrom(rs.getBytes("subscription.addressFrom")).setAddressTo(rs.getBytes("subscription.addressTo")).setDateFrom(TimeUtils.convertSqlDateToDate((Date)rs.getDate("subscription.dateFrom"))).setDateTo(TimeUtils.convertSqlDateToDate((Date)rs.getDate("subscription.dateTo"))).setSubscriberId(rs.getInt("subscription.subscriberId")).setSubscriberTitle(rs.getString("subscription.subscriberTitle")).build();
    }
}

