/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.radius;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import ru.bitel.common.Utils;
import ru.bitel.common.io.BitArray;

public class MicrosoftVendor {
    private static boolean debug = false;
    public static final int MS_chap_response = 1;
    public static final int MS_chap_error = 2;
    public static final int MS_chap_cpw_1 = 3;
    public static final int MS_chap_cpw_2 = 4;
    public static final int MS_chap_lm_enc_pw = 5;
    public static final int MS_chap_nt_enc_pw = 6;
    public static final int MS_mppe_encryption_policy = 7;
    public static final int MS_mppe_encryption_types = 8;
    public static final int MS_ras_vendor = 9;
    public static final int MS_chap_domain = 10;
    public static final int MS_chap_challenge = 11;
    public static final int MS_chap_mppe_keys = 12;
    public static final int MS_bap_usage = 13;
    public static final int MS_link_utilization_threshold = 14;
    public static final int MS_link_drop_time_limit = 15;
    public static final int MS_mppe_send_key = 16;
    public static final int MS_mppe_recv_key = 17;
    public static final int MS_old_arap_password = 18;
    public static final int MS_ras_version = 19;
    public static final int MS_new_arap_password = 20;
    public static final int MS_arap_password_change_reason = 21;
    public static final int MS_filter = 22;
    public static final int MS_acct_auth_type = 23;
    public static final int MS_acct_eap_type = 24;
    public static final int MS_chap2_response = 25;
    public static final int MS_chap2_success = 26;
    public static final int MS_chap2_cpw = 27;
    public static final int MS_primary_dns_server = 28;
    public static final int MS_secondary_dns_server = 29;
    public static final int MS_primary_nbns_server = 30;
    public static final int MS_secondary_nbns_server = 31;
    public static final int MS_arap_challenge = 33;
    public static final int MS_framed_encryption_type = 200;
    private static final byte[] magic2 = new byte[]{79, 110, 32, 116, 104, 101, 32, 99, 108, 105, 101, 110, 116, 32, 115, 105, 100, 101, 44, 32, 116, 104, 105, 115, 32, 105, 115, 32, 116, 104, 101, 32, 115, 101, 110, 100, 32, 107, 101, 121, 59, 32, 111, 110, 32, 116, 104, 101, 32, 115, 101, 114, 118, 101, 114, 32, 115, 105, 100, 101, 44, 32, 105, 116, 32, 105, 115, 32, 116, 104, 101, 32, 114, 101, 99, 101, 105, 118, 101, 32, 107, 101, 121, 46};
    private static final byte[] magic3 = new byte[]{79, 110, 32, 116, 104, 101, 32, 99, 108, 105, 101, 110, 116, 32, 115, 105, 100, 101, 44, 32, 116, 104, 105, 115, 32, 105, 115, 32, 116, 104, 101, 32, 114, 101, 99, 101, 105, 118, 101, 32, 107, 101, 121, 59, 32, 111, 110, 32, 116, 104, 101, 32, 115, 101, 114, 118, 101, 114, 32, 115, 105, 100, 101, 44, 32, 105, 116, 32, 105, 115, 32, 116, 104, 101, 32, 115, 101, 110, 100, 32, 107, 101, 121, 46};
    private static final byte[] SHSpad1 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] SHSpad2 = new byte[]{-14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14};

    public static byte[] checkMSChap_V2Password(byte[] challenge, byte[] responseBytes, String userName, String userPassword, String welcome) {
        if (challenge != null && userName != null && responseBytes != null && responseBytes.length == 49) {
            int pos = userName.indexOf(92);
            if (pos >= 0) {
                userName = userName.substring(pos + 1);
            }
            byte[] peerChallenge = new byte[16];
            byte[] ntResponse = new byte[24];
            System.arraycopy(responseBytes, 0, peerChallenge, 0, 16);
            System.arraycopy(responseBytes, 24, ntResponse, 0, 24);
            try {
                byte[] userNameBytes = userName.getBytes("ISO-8859-1");
                byte[] userPasswBytes = userPassword.getBytes("UTF-16LE");
                byte[] myNtResponse = MicrosoftVendor.generateNTResponse(challenge, peerChallenge, userNameBytes, userPasswBytes);
                for (int i = 0; i < myNtResponse.length && i < ntResponse.length; ++i) {
                    if (myNtResponse[i] == ntResponse[i]) continue;
                    return null;
                }
                byte[] result = MicrosoftVendor.generateAuthenticatorResponse(challenge, peerChallenge, userNameBytes, userPasswBytes, ntResponse, welcome).getBytes("cp1251");
                return result;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            System.err.println("Not valid MS Chap v2 request! [" + String.valueOf(challenge) + " " + userName + " " + String.valueOf(responseBytes) + " " + (responseBytes != null ? responseBytes.length : 0) + "]");
        }
        return null;
    }

    public static byte[] mppeKey(byte[] masterKey, int startKeyLen, boolean isSend, boolean isServer) {
        byte[] magic = isSend ? (isServer ? magic3 : magic2) : (isServer ? magic2 : magic3);
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(masterKey);
            md.update(SHSpad1);
            md.update(magic);
            md.update(SHSpad2);
            byte[] digest = md.digest();
            byte[] key = new byte[startKeyLen];
            System.arraycopy(digest, 0, key, 0, startKeyLen);
            return key;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static byte[] mppeKey(byte[] masterKey, boolean isSend, byte[] requestAuth, byte[] secret) {
        byte[] result = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(masterKey);
            md.update(SHSpad1);
            if (isSend) {
                md.update(magic3);
            } else {
                md.update(magic2);
            }
            md.update(SHSpad2);
            result = new byte[16];
            System.arraycopy(md.digest(), 0, result, 0, 16);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static final byte[] cryptMppeKey(byte[] key, byte[] secret, byte[] requestAuth) {
        byte[] salt = new byte[]{(byte)(0x80 | ((byte)Math.random() & 0xF) << 3 | (byte)Math.random() & 7), (byte)Math.random()};
        int authPassLen = 16;
        int len = key.length + 1;
        len += 16 - len % 16;
        byte[] buf = new byte[len];
        buf[0] = (byte)key.length;
        System.arraycopy(key, 0, buf, 1, key.length);
        byte[] b = null;
        byte[] c = null;
        for (int i = 0; i < len; i += 16) {
            if (i == 0) {
                byte[] hashBase = new byte[secret.length + requestAuth.length + salt.length];
                System.arraycopy(secret, 0, hashBase, 0, secret.length);
                System.arraycopy(requestAuth, 0, hashBase, secret.length, requestAuth.length);
                System.arraycopy(salt, 0, hashBase, secret.length + requestAuth.length, salt.length);
                b = Utils.getDigestBytes((byte[])hashBase);
            } else {
                byte[] secretAndC = new byte[secret.length + c.length];
                System.arraycopy(secret, 0, secretAndC, 0, secret.length);
                System.arraycopy(c, 0, secretAndC, secret.length, c.length);
                b = Utils.getDigestBytes((byte[])secretAndC);
            }
            c = new byte[16];
            for (int j = 0; j < 16; ++j) {
                c[j] = (byte)(buf[i + j] ^ b[j]);
            }
            System.arraycopy(c, 0, buf, i, 16);
        }
        byte[] result = new byte[salt.length + buf.length];
        System.arraycopy(salt, 0, result, 0, salt.length);
        System.arraycopy(buf, 0, result, salt.length, buf.length);
        return result;
    }

    private static String generateAuthenticatorResponse(byte[] authenticatorChallenge, byte[] peerChallenge, byte[] userName, byte[] userPassword, byte[] ntResponse, byte ident) throws Exception {
        byte[] passwordHash = MicrosoftVendor.NTPasswordHash(userPassword);
        byte[] passwordHashHash = MicrosoftVendor.NTPasswordHash(passwordHash);
        byte[] Magic1 = new byte[]{77, 97, 103, 105, 99, 32, 115, 101, 114, 118, 101, 114, 32, 116, 111, 32, 99, 108, 105, 101, 110, 116, 32, 115, 105, 103, 110, 105, 110, 103, 32, 99, 111, 110, 115, 116, 97, 110, 116};
        byte[] Magic2 = new byte[]{80, 97, 100, 32, 116, 111, 32, 109, 97, 107, 101, 32, 105, 116, 32, 100, 111, 32, 109, 111, 114, 101, 32, 116, 104, 97, 110, 32, 111, 110, 101, 32, 105, 116, 101, 114, 97, 116, 105, 111, 110};
        MessageDigest md = MessageDigest.getInstance("SHA");
        md.update(passwordHashHash);
        md.update(ntResponse);
        md.update(Magic1);
        byte[] digest = md.digest();
        byte[] challenge = MicrosoftVendor.challengeHash(authenticatorChallenge, peerChallenge, userName);
        md.reset();
        md.update(digest);
        md.update(challenge);
        md.update(Magic2);
        digest = md.digest();
        StringBuffer result = new StringBuffer();
        result.append((char)ident);
        result.append("S=");
        result.append(Utils.bytesToString((byte[])digest).replaceAll(" ", ""));
        return result.toString();
    }

    private static String generateAuthenticatorResponse(byte[] authenticatorChallenge, byte[] peerChallenge, byte[] userName, byte[] userPassword, byte[] ntResponse, String message) throws Exception {
        byte[] passwordHash = MicrosoftVendor.NTPasswordHash(userPassword);
        byte[] passwordHashHash = MicrosoftVendor.NTPasswordHash(passwordHash);
        byte[] Magic1 = new byte[]{77, 97, 103, 105, 99, 32, 115, 101, 114, 118, 101, 114, 32, 116, 111, 32, 99, 108, 105, 101, 110, 116, 32, 115, 105, 103, 110, 105, 110, 103, 32, 99, 111, 110, 115, 116, 97, 110, 116};
        byte[] Magic2 = new byte[]{80, 97, 100, 32, 116, 111, 32, 109, 97, 107, 101, 32, 105, 116, 32, 100, 111, 32, 109, 111, 114, 101, 32, 116, 104, 97, 110, 32, 111, 110, 101, 32, 105, 116, 101, 114, 97, 116, 105, 111, 110};
        MessageDigest md = MessageDigest.getInstance("SHA");
        md.update(passwordHashHash);
        md.update(ntResponse);
        md.update(Magic1);
        byte[] digest = md.digest();
        byte[] challenge = MicrosoftVendor.challengeHash(authenticatorChallenge, peerChallenge, userName);
        md.reset();
        md.update(digest);
        md.update(challenge);
        md.update(Magic2);
        digest = md.digest();
        StringBuilder result = new StringBuilder();
        result.append("S=");
        result.append(Utils.bytesToString((byte[])digest).replaceAll(" ", ""));
        if (message != null) {
            result.append(" M=");
            result.append(message);
        }
        return result.toString();
    }

    private static byte[] generateNTResponse(byte[] authenticatorChallenge, byte[] peerChallenge, byte[] userName, byte[] userPassword) {
        byte[] response = new byte[24];
        try {
            byte[] challengeHash = MicrosoftVendor.challengeHash(authenticatorChallenge, peerChallenge, userName);
            if (debug) {
                System.out.println("challengeHash: " + Utils.bytesToString((byte[])challengeHash));
                System.out.println("need: D0 2E 43 86 BC E9 12 26");
            }
            byte[] passwordHash = MicrosoftVendor.NTPasswordHash(userPassword);
            if (debug) {
                System.out.println("passwordHash: " + Utils.bytesToString((byte[])passwordHash));
                System.out.println("need: 44 EB BA 8D 53 12 B8 D6 11 47 44 11 F5 69 89 AE");
            }
            byte[] z_passwordHash = new byte[21];
            for (int i = 0; i < z_passwordHash.length; ++i) {
                z_passwordHash[i] = i < passwordHash.length ? passwordHash[i] : (byte)0;
            }
            byte[] DES_Key = new byte[7];
            System.arraycopy(z_passwordHash, 0, DES_Key, 0, 7);
            byte[] auth_1 = MicrosoftVendor.DES_Encrypt(challengeHash, DES_Key);
            System.arraycopy(z_passwordHash, 7, DES_Key, 0, 7);
            byte[] auth_2 = MicrosoftVendor.DES_Encrypt(challengeHash, DES_Key);
            System.arraycopy(z_passwordHash, 14, DES_Key, 0, 7);
            byte[] auth_3 = MicrosoftVendor.DES_Encrypt(challengeHash, DES_Key);
            System.arraycopy(auth_1, 0, response, 0, 8);
            System.arraycopy(auth_2, 0, response, 8, 8);
            System.arraycopy(auth_3, 0, response, 16, 8);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return response;
    }

    private static byte[] challengeHash(byte[] authenticatorChallenge, byte[] peerChallenge, byte[] userName) throws NoSuchAlgorithmException {
        byte[] challengeHash = new byte[8];
        MessageDigest md = MessageDigest.getInstance("SHA");
        md.update(peerChallenge);
        md.update(authenticatorChallenge);
        md.update(userName);
        System.arraycopy(md.digest(), 0, challengeHash, 0, 8);
        return challengeHash;
    }

    private static byte[] NTPasswordHash(byte[] userPassword) throws NoSuchAlgorithmException {
        MessageDigest md4 = Utils.newMD4();
        md4.update(userPassword, 0, userPassword.length);
        byte[] passwordHash = md4.digest();
        return passwordHash;
    }

    private static byte[] DES_Encrypt(byte[] clear, byte[] key) throws Exception {
        byte[] result = new byte[8];
        if (clear.length == 8 && key.length == 7) {
            byte[] key8 = MicrosoftVendor.insertParityBits(key);
            if (debug) {
                System.out.println("key: " + Utils.bytesToString((byte[])key));
                System.out.println("key8:" + Utils.bytesToString((byte[])key8));
            }
            Cipher ecipher = Cipher.getInstance("DES");
            ecipher.init(1, new SecretKeySpec(key8, "DES"));
            result = ecipher.doFinal(clear);
        } else {
            System.err.println("DES_Encrypt() params ERROR!");
        }
        return result;
    }

    private static byte[] insertParityBits(byte[] key) {
        byte[] result = null;
        BitArray ba = new BitArray(64);
        int bitArrayPos = 0;
        boolean checkBit = false;
        for (int i = 0; i < 56; ++i) {
            boolean bitValue;
            int byteNum = i / 8;
            boolean bl = bitValue = (key[byteNum] & 1 << 7 - i % 8) > 0;
            if (i != 0 && i % 7 == 0) {
                ba.set(bitArrayPos, checkBit);
                checkBit = bitValue;
                ba.set(++bitArrayPos, bitValue);
                ++bitArrayPos;
                continue;
            }
            checkBit ^= bitValue;
            ba.set(bitArrayPos, bitValue);
            ++bitArrayPos;
        }
        result = ba.toByteArray();
        return result;
    }

    public static void main(String[] args) {
        try {
            byte[] userName = Utils.hexStringToBytes((String)"55 73 65 72");
            byte[] userpassw = Utils.hexStringToBytes((String)"63 00 6C 00 69 00 65 00 6E 00 74 00 50 00 61 00 73 00 73 00");
            byte[] authenticatorChallenge = Utils.hexStringToBytes((String)"5B 5D 7C 7D 7B 3F 2F 3E 3C 2C 60 21 32 26 26 28");
            byte[] peerChallenge = Utils.hexStringToBytes((String)"21 40 23 24 25 5E 26 2A 28 29 5F 2B 3A 33 7C 7E");
            byte[] myNTResponse = MicrosoftVendor.generateNTResponse(authenticatorChallenge, peerChallenge, userName, userpassw);
            System.out.println("myNTResponse: " + Utils.bytesToString((byte[])myNTResponse));
            System.out.println("need: 82 30 9E CD 8D 70 8B 5E A0 8F AA 39 81 CD 83 54 42 33 11 4A 3D 85 D6 DF");
            String authResponse = MicrosoftVendor.generateAuthenticatorResponse(authenticatorChallenge, peerChallenge, userName, userpassw, myNTResponse, (byte)0);
            System.out.println("AuthenticatorResponse: " + authResponse);
            System.out.println("need: S=407A5589115FD0D6209F510FE9C04566932CDA56");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

