/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.admin;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGControlPanelMonthAndDays;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.field.BGTextArea;
import ru.bitel.bgbilling.kernel.table.client.BGDataSourceTableModel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;

public class WebLogTabQuery
extends BGUPanel {
    private BGControlPanelPages page;
    private BGControlPanelMonthAndDays period;
    private BGTextArea queryInfo = new BGTextArea(3, 10);
    private BGDataSourceTableModel logTableModel = new BGDataSourceTableModel("WebLog");

    public WebLogTabQuery(BGControlPanelMonthAndDays period, BGControlPanelPages page) {
        this.page = page;
        this.period = period;
    }

    @Override
    protected void jbInit() throws Exception {
        BGUTable table = new BGUTable(this.logTableModel);
        table.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting() && table.getSelectedRow() > -1) {
                Optional.ofNullable((BGUTableRowData)this.logTableModel.getSelectedRow()).ifPresent(a -> this.queryInfo.setText(a.optValue("query").orElse("")));
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.getQueryInfoPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private JPanel getQueryInfoPanel() {
        this.queryInfo.setDisabledTextColor(Color.black);
        this.queryInfo.setEnabled(true);
        this.queryInfo.setEditable(false);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(" \u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043f\u043e \u0437\u0430\u043f\u0440\u043e\u0441\u0443 "));
        panel.add((Component)new JScrollPane(this.queryInfo), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    public void setQuery(String conId, String filterQuery) {
        BGUTableParams tableParams = new BGUTableParams().addParam("contracts", conId).addParam("query_filter", filterQuery).setPeriod(this.period.getPeriod()).setPage(this.page.getPage());
        this.logTableModel.loadData(this.getKernelContext(), tableParams, this.page, null);
        this.queryInfo.setText("");
    }

    public void clearTable() {
        this.logTableModel.deleteRows();
    }
}

