/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.admin;

import bitel.billing.module.common.TransferData;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.runner.BGClientRunnerCipher;
import ru.bitel.bgbilling.client.runner.BGClientRunnerDbInfo;
import ru.bitel.common.Preferences;
import ru.bitel.common.model.GuiTitlable;

public class DBInfo
extends BGClientRunnerDbInfo
implements GuiTitlable {
    private String dbServerEmail = null;
    private TransferData transferData = null;
    private Node menuBarNode = null;
    private Node toolBarNode = null;
    private Node paramsNode = null;
    private Node modulesNode = null;
    private Node pluginsNode = null;
    private TimeZone timeZone = null;
    private boolean localItem = false;
    private boolean saveAccount = false;
    private String firmTitle;
    private String serverVersion;
    private String user;

    public DBInfo() {
    }

    public DBInfo(DBInfo info) {
        this.setDbServerKey(info.getDbServerKey());
        this.setDbServerTitle(info.getDbServerTitle());
        this.setDbServerURL(info.getDbServerURL());
        this.setDbServerProxyHost(info.getDbServerProxyHost());
        this.setDbServerProxyPort(info.getDbServerProxyPort());
        this.setDbServerLogin(info.getDbServerLogin());
        this.setDbServerPassword(info.getDbServerPassword());
        this.dbServerEmail = info.dbServerEmail;
        this.transferData = info.transferData;
        this.menuBarNode = info.menuBarNode;
        this.toolBarNode = info.toolBarNode;
        this.paramsNode = info.paramsNode;
        this.modulesNode = info.modulesNode;
        this.pluginsNode = info.pluginsNode;
        this.setLocalItem(info.isLocalItem());
        this.saveAccount = info.saveAccount;
        this.setFavorite(info.isFavorite());
    }

    public TransferData getTransferData() {
        if (this.transferData == null) {
            this.createTransferData();
        }
        return this.transferData;
    }

    public void setConnected(boolean connected) {
        if (connected) {
            this.createTransferData();
        } else {
            this.transferData = null;
        }
    }

    private void createTransferData() {
        try {
            this.transferData = new TransferData(URI.create(this.getDbServerURL()).toURL());
            this.transferData.setUser(this.getDbServerLogin(), this.getDbServerPassword());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setMenuBarNode(Node node) {
        this.menuBarNode = node;
    }

    public Node getMenuBarNode() {
        return this.menuBarNode;
    }

    public void setToolBarNode(Node node) {
        this.toolBarNode = node;
    }

    public Node getToolBarNode() {
        return this.toolBarNode;
    }

    public void setParamsNode(Node paramsNode) {
        this.paramsNode = paramsNode;
    }

    public String getDbServerEmail() {
        return this.dbServerEmail;
    }

    public void setDbServerEmail(String dbServerEmail) {
        this.dbServerEmail = dbServerEmail;
    }

    public Map<String, String> getParamsMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Element paramElement = (Element)this.paramsNode;
        if (this.paramsNode != null && this.paramsNode.hasChildNodes()) {
            NodeList list = paramElement.getElementsByTagName("param");
            for (int index = 0; index < list.getLength(); ++index) {
                Element element = (Element)list.item(index);
                map.put("dbinfo." + element.getAttribute("key"), element.getAttribute("value"));
            }
        }
        return map;
    }

    public Map<String, Preferences> getModulesParamsMap() {
        return this.getModulesParamsMap(true);
    }

    public Map<String, Preferences> getPluginsParamsMap() {
        return this.getModulesParamsMap(false);
    }

    private Map<String, Preferences> getModulesParamsMap(boolean isModule) {
        Node node = isModule ? this.modulesNode : this.pluginsNode;
        String elementsByTagName = isModule ? "module" : "plugin";
        HashMap<String, Preferences> resultMap = new HashMap<String, Preferences>();
        Element modulesElement = (Element)node;
        if (node != null && node.hasChildNodes()) {
            NodeList list = modulesElement.getElementsByTagName(elementsByTagName);
            for (int index = 0; index < list.getLength(); ++index) {
                NodeList listParam = ((Element)list.item(index)).getElementsByTagName("param");
                HashMap<String, String> paramsMap = new HashMap<String, String>();
                for (int paramIndex = 0; paramIndex < listParam.getLength(); ++paramIndex) {
                    Element element = (Element)listParam.item(paramIndex);
                    paramsMap.put(element.getAttribute("key"), element.getAttribute("value"));
                }
                resultMap.put(((Element)list.item(index)).getAttribute("id"), new Preferences(paramsMap));
            }
        }
        return resultMap;
    }

    @Override
    public boolean isSaveAccount() {
        return this.saveAccount;
    }

    @Override
    public void setSaveAccount(boolean saveAccount) {
        this.saveAccount = saveAccount;
    }

    public boolean isLocalItem() {
        return this.localItem;
    }

    public void setLocalItem(boolean localItem) {
        this.localItem = localItem;
    }

    public String getFirmTitle() {
        return this.firmTitle;
    }

    public void setFirmTitle(String firmTitle) {
        this.firmTitle = firmTitle;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public void setModulesNode(Node modulesNode) {
        this.modulesNode = modulesNode;
    }

    public void setPluginsNode(Node pluginsNode) {
        this.pluginsNode = pluginsNode;
    }

    public static DBInfo parseDBInfoFromJson(JSONObject dbInfoJSONObject) {
        DBInfo dbInfo = null;
        if (dbInfoJSONObject != null) {
            dbInfo = new DBInfo();
            dbInfo.setDbServerKey(dbInfoJSONObject.optString("key", ""));
            dbInfo.setDbServerTitle(dbInfoJSONObject.optString("title", ""));
            dbInfo.setDbServerURL(dbInfoJSONObject.optString("url", ""));
            dbInfo.setDbServerProxyHost(dbInfoJSONObject.optString("proxyHost", ""));
            dbInfo.setDbServerProxyPort(dbInfoJSONObject.optString("proxyPort", ""));
            dbInfo.setDbServerJavaHome(dbInfoJSONObject.optString("javaHome", ""));
            dbInfo.setSaveAccount(Boolean.valueOf(dbInfoJSONObject.optString("safe", "false")));
            String auth = dbInfoJSONObject.optString("auth", null);
            if (auth != null) {
                String[] loginPassword = BGClientRunnerCipher.cipher(auth, true).split("\t", -1);
                dbInfo.setDbServerLogin(loginPassword[0]);
                dbInfo.setDbServerPassword(loginPassword[1]);
            }
        }
        return dbInfo;
    }

    @Override
    public String getGuiTitle() {
        return this.getDbServerTitle();
    }
}

