/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.search.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Optional;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuListener;
import ru.bitel.bgbilling.client.BGClient;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.search.common.SearchImplementation;
import ru.bitel.bgbilling.kernel.contract.search.common.service.ContractSearchService;
import ru.bitel.common.client.BGComboBoxPopupMenuListener;

public class SearchPopup
extends JPopupMenu {
    private boolean noSelect = false;
    private boolean autoWidth = false;
    private ContractSearchService contractSearchService;
    private ActionListener popupItemClickListener;

    public SearchPopup(ClientContext context, CustomSearch customSearch, boolean autoWidth) {
        this.contractSearchService = (ContractSearchService)context.getWebService(ContractSearchService.class, 0);
        this.popupItemClickListener = e -> {
            SearchImplementation selectImplementation;
            if (e.getSource() instanceof SearchMenuItem && (selectImplementation = ((SearchMenuItem)e.getSource()).implementation) != null) {
                customSearch.customSearchImpl(selectImplementation);
            }
        };
        this.autoWidth = autoWidth;
        this.setBackground(Color.WHITE);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int selectedIndex = SearchPopup.this.getSelectionModel().getSelectedIndex();
                int itemsCount = SearchPopup.this.getComponentCount();
                if (e.getKeyCode() == 38) {
                    if (selectedIndex == -1 || selectedIndex == 0) {
                        SearchPopup.this.getSelectionModel().setSelectedIndex(itemsCount - 1);
                    } else {
                        SearchPopup.this.getSelectionModel().setSelectedIndex(--selectedIndex);
                    }
                } else if (e.getKeyCode() == 40) {
                    if (selectedIndex == itemsCount - 1 || selectedIndex == -1) {
                        SearchPopup.this.getSelectionModel().setSelectedIndex(0);
                    } else {
                        SearchPopup.this.getSelectionModel().setSelectedIndex(++selectedIndex);
                    }
                } else if (e.getKeyCode() == 10 && selectedIndex >= 0) {
                    SearchPopup.this.popupItemClickListener.actionPerformed(new ActionEvent(SearchPopup.this.getComponent(selectedIndex), 0, ""));
                }
            }
        });
        this.addPopupMenuListener((PopupMenuListener)new BGComboBoxPopupMenuListener());
    }

    public void setSearchImplementationItems(String inputText) throws BGException {
        this.removeAll();
        if (!this.noSelect) {
            try {
                this.contractSearchService.getValidadedSearches(inputText).forEach(implClazz -> {
                    SearchMenuItem menuItem = new SearchMenuItem(implClazz.getTitle(), (SearchImplementation)((Object)implClazz));
                    menuItem.setBackground(Color.WHITE);
                    menuItem.addActionListener(this.popupItemClickListener);
                    this.add(menuItem);
                });
            }
            catch (Exception ex) {
                this.noSelect = true;
            }
        }
    }

    public Optional<SearchImplementation> getSearchImplementationByIndex(int index) {
        try {
            Component component = this.getComponent(index);
            if (component instanceof SearchMenuItem) {
                return Optional.ofNullable(((SearchMenuItem)component).getImplementation());
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return Optional.empty();
    }

    @Override
    public void setSize(Dimension sizeSearchPopup) {
        this.setMinimumSize(sizeSearchPopup);
        this.setPreferredSize(sizeSearchPopup);
        this.setPreferredSize(sizeSearchPopup);
    }

    public static DocumentListener getDocumentListenerBySearchField(Component invoker, JTextField searchTextField, SearchPopup searchPopup) {
        return SearchPopup.getDocumentListenerBySearchField(invoker, searchTextField, searchPopup, searchTextField.getWidth());
    }

    public static DocumentListener getDocumentListenerBySearchField(final Component invoker, final JTextField searchTextField, final SearchPopup searchPopup, int width) {
        return new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (searchPopup.isVisible()) {
                    searchPopup.setVisible(false);
                }
                try {
                    searchPopup.setSearchImplementationItems(searchTextField.getText());
                }
                catch (BGException ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
                int height = 20 * searchPopup.getComponentCount();
                int width = searchTextField.getWidth();
                if (searchPopup.autoWidth) {
                    Graphics graphics = BGClient.getFrame().getGraphics();
                    for (int i = 0; i < searchPopup.getComponentCount(); ++i) {
                        Component component = searchPopup.getComponent(i);
                        if (!(component instanceof SearchMenuItem)) continue;
                        width = Math.max(width, graphics.getFontMetrics(component.getFont()).stringWidth(((SearchMenuItem)component).getText()) + 10);
                    }
                }
                searchPopup.setSize(new Dimension(width, height));
                searchPopup.show(invoker, searchTextField.getX(), searchTextField.getY() + searchTextField.getHeight());
                searchTextField.requestFocus();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
    }

    public ContractSearchService getContractSearchService() {
        return this.contractSearchService;
    }

    public static interface CustomSearch {
        public void customSearchImpl(SearchImplementation var1);
    }

    public static class SearchMenuItem
    extends JMenuItem {
        private SearchImplementation implementation;

        public SearchMenuItem(String text, SearchImplementation implementation) {
            super(text);
            this.implementation = implementation;
        }

        public SearchImplementation getImplementation() {
            return this.implementation;
        }
    }
}

