/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import ru.bitel.bgbilling.kernel.contract.status.server.ContractStatusList;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTree;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.util.AbstractPeriodItemSet;

public final class TariffModuleTreeSet {
    private final Entry[] entries;

    TariffModuleTreeSet(List<Entry> entryList) {
        this.entries = entryList.toArray(new Entry[entryList.size()]);
    }

    public Entry getEntry(long millis) {
        for (Entry entry : this.entries) {
            TariffModuleTree tree;
            if (entry.timeFrom != 0L && entry.timeFrom > millis || entry.timeTo != 0L && entry.timeTo < millis || (tree = entry.getTree()) == null) continue;
            return entry;
        }
        return null;
    }

    public List<Entry> getEntryList(long millis) {
        ArrayList<Entry> result = new ArrayList<Entry>(4);
        for (Entry entry : this.entries) {
            TariffModuleTree tree;
            if (entry.timeFrom != 0L && entry.timeFrom > millis || entry.timeTo != 0L && entry.timeTo < millis || (tree = entry.getTree()) == null) continue;
            result.add(entry);
        }
        return result;
    }

    public TariffModuleTree getTree(long millis) {
        Entry entry = this.getEntry(millis);
        return entry != null ? entry.getTree() : null;
    }

    public TariffModuleTree getTree(Calendar date) {
        return this.getTree(date.getTimeInMillis());
    }

    public TariffModuleTree getTree(Date date) {
        return this.getTree(date.getTime());
    }

    public TariffModuleTree getTree(LocalDate date) {
        return this.getTree(date.atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    public List<Entry> getEntryList(Calendar date) {
        return this.getEntryList(date.getTimeInMillis());
    }

    public Entry[] entries() {
        ArrayList<Entry> result = new ArrayList<Entry>();
        for (Entry entry : this.entries) {
            TariffModuleTree tree = entry.getTree();
            if (tree == null) continue;
            result.add(entry);
        }
        if (result.size() == this.entries.length) {
            return this.entries;
        }
        return result.toArray(new Entry[result.size()]);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(200);
        result.append("TariffModuleTreeSet [");
        for (Entry entry : this.entries) {
            TariffModuleTree tree = entry.getTree();
            if (tree == null) continue;
            result.append(tree.getTreeId());
            result.append(":");
            result.append(TimeUtils.formatPeriod(new Date(entry.timeFrom), entry.timeTo == 0L ? null : new Date(entry.timeTo)));
            result.append("; ");
        }
        result.append("]");
        return result.toString();
    }

    public static final class Entry {
        private final AtomicReference<TariffModuleTree> tree;
        private final int contractTariffId;
        private final long timeFrom;
        private final long timeTo;

        public Entry(AtomicReference<TariffModuleTree> tree, int contractTariffId, long timeFrom, long timeTo) {
            this.tree = tree;
            this.contractTariffId = contractTariffId;
            this.timeFrom = timeFrom;
            this.timeTo = timeTo;
        }

        public long getTimeTo() {
            return this.timeTo;
        }

        public long getTimeFrom() {
            return this.timeFrom;
        }

        public Calendar getCalendarFrom() {
            return TimeUtils.convertMillisToCalendar(this.timeFrom);
        }

        public Calendar getCalendarTo() {
            return TimeUtils.convertMillisToCalendar(this.timeTo);
        }

        public TariffModuleTree getTree() {
            return this.tree.get();
        }

        public int getContractTariffId() {
            return this.contractTariffId;
        }

        public float getPartOnPeriod(long accountingPeriodMillisFrom, long accountingPeriodMillisTo) {
            return TimeUtils.getPart(this.timeFrom, this.timeTo, accountingPeriodMillisFrom, accountingPeriodMillisTo);
        }

        public float getPartOnPeriod(long accountingPeriodMillisFrom, long accountingPeriodMillisTo, ContractStatusList suspendStatusList) {
            if (suspendStatusList == null || suspendStatusList.size() == 0) {
                return this.getPartOnPeriod(accountingPeriodMillisFrom, accountingPeriodMillisTo);
            }
            long millisFrom = this.timeFrom == 0L || this.timeFrom <= accountingPeriodMillisFrom ? accountingPeriodMillisFrom : this.timeFrom;
            long millisTo = this.timeTo == 0L || accountingPeriodMillisTo <= this.timeTo ? accountingPeriodMillisTo : this.timeTo;
            GregorianCalendar calendarFrom = new GregorianCalendar();
            GregorianCalendar calendarTo = new GregorianCalendar();
            calendarFrom.setTimeInMillis(millisFrom);
            calendarTo.setTimeInMillis(millisTo);
            int day1 = calendarFrom.get(5);
            int result = TimeUtils.daysDelta(calendarFrom, calendarTo) + 1;
            BitSet days = new BitSet();
            days.set(day1, day1 + result);
            BitSet daysSuspended = new BitSet();
            GregorianCalendar suspendFrom = new GregorianCalendar();
            GregorianCalendar suspendTo = new GregorianCalendar();
            int size = suspendStatusList.size();
            for (int i = 0; i < size; ++i) {
                Object p = suspendStatusList.get(i);
                if (((AbstractPeriodItemSet.PeriodItem)p).timeFrom == 0L || ((AbstractPeriodItemSet.PeriodItem)p).timeFrom <= millisFrom) {
                    suspendFrom.setTimeInMillis(millisFrom);
                } else {
                    suspendFrom.setTimeInMillis(((AbstractPeriodItemSet.PeriodItem)p).timeFrom);
                }
                if (((AbstractPeriodItemSet.PeriodItem)p).timeTo == 0L || millisTo <= ((AbstractPeriodItemSet.PeriodItem)p).timeTo) {
                    suspendTo.setTimeInMillis(millisTo);
                } else {
                    suspendTo.setTimeInMillis(((AbstractPeriodItemSet.PeriodItem)p).timeTo);
                }
                int dim = TimeUtils.daysDelta(calendarFrom, suspendFrom);
                result = TimeUtils.daysDelta(suspendFrom, suspendTo) + 1;
                if (result <= 0) continue;
                daysSuspended.set(day1 + dim, day1 + dim + result);
            }
            days.andNot(daysSuspended);
            int daysCount = days.cardinality();
            calendarFrom.setTimeInMillis(accountingPeriodMillisFrom);
            calendarTo.setTimeInMillis(accountingPeriodMillisTo);
            return (float)daysCount / (float)(TimeUtils.daysDelta(calendarFrom, calendarTo) + 1);
        }
    }
}

