/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.common.Utils;

public class ContractModuleManager
extends AbstarctDaoConstant {
    public ContractModuleManager(Connection con) {
        super(con, "contract_module", 0);
    }

    public List<BGModule> getContractModules(int contractId) throws SQLException {
        return ModuleCache.getInstance().getModulesListWithIds(this.getContractModuleSet(contractId));
    }

    public Set<Integer> getContractModuleSet(int contractId) throws SQLException {
        HashSet<Integer> result = new HashSet<Integer>();
        String query = "SELECT mid FROM " + this.tableName + " WHERE cid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(rs.getInt(1));
                }
            }
        }
        return result;
    }

    public Map<Integer, Set<Integer>> getContractModuleMap() throws SQLException {
        HashMap<Integer, Set<Integer>> result = new HashMap<Integer, Set<Integer>>();
        String query = "SELECT cid, mid FROM " + this.tableName + " ORDER BY cid";
        try (Statement ps = this.con.createStatement();
             ResultSet rs = ps.executeQuery(query);){
            int currentContractId = 0;
            HashSet<Integer> s = new HashSet<Integer>();
            while (rs.next()) {
                int contractId = rs.getInt(1);
                if (currentContractId != contractId) {
                    currentContractId = contractId;
                    s = new HashSet();
                    result.put(currentContractId, s);
                }
                s.add(rs.getInt(2));
            }
        }
        return result;
    }

    public void addContractModule(int contractId, int moduleId) throws SQLException {
        boolean needInsert = false;
        String query = "SELECT COUNT(*) FROM " + this.tableName + " WHERE cid=? AND mid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setInt(2, moduleId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    needInsert = rs.getInt(1) == 0;
                }
            }
        }
        if (needInsert) {
            query = "INSERT INTO " + this.tableName + " SET cid=?, mid=?";
            ps = this.con.prepareStatement(query);
            try {
                ps.setInt(1, contractId);
                ps.setInt(2, moduleId);
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }

    public void deleteContractModule(int contractId, int moduleId) throws SQLException, BGException {
        ContractDeleteEvent event = EventProcessor.getInstance().request(new ContractDeleteEvent(moduleId, 0, contractId, true));
        if (!Utils.isBlankString(event.getError())) {
            throw new BGException(event.getError());
        }
        EventProcessor.getInstance().request(new ContractDeleteEvent(moduleId, 0, contractId, false));
        String query = "DELETE FROM " + this.tableName + " WHERE cid=? AND mid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setInt(2, moduleId);
            ps.executeUpdate();
        }
    }
}

