/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;

public class BGCheckListCellRenderer<T extends BGUListItem>
extends JCheckBox
implements ListCellRenderer<T> {
    Border m_noFocusBorder = new EmptyBorder(1, 5, 1, 5);

    public BGCheckListCellRenderer() {
        this.setOpaque(true);
        this.setBorder(this.m_noFocusBorder);
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setFont(list.getFont());
        this.setText("<html>" + ((IdTitle)value).getGuiTitle() + "</html>");
        T item = value;
        this.setSelected(((BGUListItem)item).isSelected());
        this.setEnabled(list.isEnabled());
        this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
        this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
        JLabel idLabel = new JLabel("#" + ((Id)value).getId());
        idLabel.setForeground(new Color(0xCCCCCC));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
        panel.add((Component)this, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 10, 0));
        panel.add((Component)idLabel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 5, 0));
        return panel;
    }

    public String getId(T value) {
        return ((Id)value).getId() > -1 ? " <span style='color: #ccc;'>[<i>#" + ((Id)value).getId() + "</i>]</span>" : "";
    }
}

