/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.xml.strategy;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.xml.JAXBUtils;
import ru.bitel.common.xml.MapAdapters;
import ru.bitel.common.xml.strategy.DefaultMarshallerStrategy;

public class WebMarshallerStrategy
extends DefaultMarshallerStrategy {
    private static final Set<Class<?>> DEFAULT_CLASSES = new HashSet<Class>(Arrays.asList(WebDate.class));

    @Override
    public Object prepareForMarshal(Object result) {
        if (result instanceof Date) {
            return new WebDate((Date)result);
        }
        return result;
    }

    @Override
    public Set<Class<?>> getDefaultClasses() {
        return DEFAULT_CLASSES;
    }

    @Override
    public Marshaller newMarshaller(JAXBContext context) throws JAXBException {
        Marshaller m = super.newMarshaller(context);
        m.setAdapter(JAXBUtils.DateTimeAdapter.class, (XmlAdapter)new JAXBUtils.DateTimeAdapter(this){

            @Override
            public String marshal(Date v) throws Exception {
                return TimeUtils.format(v, "dd.MM.yyyy HH:mm:ss");
            }

            @Override
            public Date unmarshal(String v) throws Exception {
                return TimeUtils.parseDate(v, "dd.MM.yyyy HH:mm:ss");
            }
        });
        m.setAdapter(JAXBUtils.DateAdapter.class, (XmlAdapter)new JAXBUtils.DateAdapter(this){

            @Override
            public String marshal(Date v) throws Exception {
                return TimeUtils.format(v, "dd.MM.yyyy");
            }

            @Override
            public Date unmarshal(String v) throws Exception {
                return TimeUtils.parseDate(v, "dd.MM.yyyy");
            }
        });
        m.setAdapter(MapAdapters.StringMapAdapter.class, (XmlAdapter)new MapAdapters.StringMapAdapter(this){

            @Override
            protected Object marshalObject(Object value) {
                if (value instanceof Date) {
                    return new WebDate((Date)value);
                }
                return super.marshalObject(value);
            }

            @Override
            protected Object unmarshalObject(Object value) {
                if (value instanceof WebDate) {
                    return TimeUtils.parseDate(((WebDate)value).value, "dd.MM.yyyy");
                }
                return super.unmarshalObject(value);
            }
        });
        return m;
    }

    static class WebDate {
        @XmlAttribute
        protected String value;
        @XmlAttribute
        protected int year;
        @XmlAttribute
        protected int month;
        @XmlAttribute
        protected int date;

        public WebDate(Date date) {
            this.value = TimeUtils.format(date, "dd.MM.yyyy");
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(date);
            this.year = c.get(1);
            this.month = c.get(2) + 1;
            this.date = c.get(5);
        }

        public WebDate() {
        }
    }
}

