/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.param.server.bean;

import bitel.billing.server.admin.bean.ContractParameterGroupManager;
import bitel.billing.server.contract.bean.ContractParameterManager;
import java.sql.Connection;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPref;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.MultiListParamValues;
import ru.bitel.bgbilling.kernel.contract.param.server.bean.ContractParameterPrefDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrBoolean;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrList;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;

public class ContractParameters {
    public static Set<Integer> getContractParameterIdsInGroup(int contractParamGroupId, Connection con) throws BGException {
        Set<Integer> ids = null;
        if (contractParamGroupId > 0) {
            ids = new ContractParameterGroupManager(con).getParameterSetInGroup(contractParamGroupId);
        }
        return ids;
    }

    public static List<ContractParameterPref> getContractParameterPrefList(Set<Integer> parameterIds, Connection con) throws Exception {
        ArrayList<ContractParameterPref> list = new ArrayList<ContractParameterPref>();
        ContractParameterPrefDao prefDao = new ContractParameterPrefDao(con);
        for (ContractParameterPref contractParameterPref : prefDao.getContractParameterPrefList(parameterIds)) {
            if (!contractParameterPref.isRead() && !contractParameterPref.isWrite()) continue;
            list.add(contractParameterPref);
        }
        return list;
    }

    public static Map<Integer, String> getContractParameterValue(List<ContractParameterPref> showList, int contractId, Connection con) throws Exception {
        HashSet<Integer> paramIds = new HashSet<Integer>();
        for (ContractParameterPref contractParameterPref : showList) {
            if (!contractParameterPref.isRead() && !contractParameterPref.isWrite()) continue;
            paramIds.add(contractParameterPref.getId());
        }
        return ContractParameters.getContractParameterValue(paramIds, contractId, con);
    }

    public static Map<Integer, String> getContractParameterValue(Set<Integer> paramIds, int contractId, Connection con) throws Exception {
        HashMap<Integer, String> paramValue = new HashMap<Integer, String>();
        try (ContractDao contractDao = new ContractDao(con, 0);
             ContractParameterManager contractParameterManager = new ContractParameterManager(con);){
            Map<Integer, EntityAttr> paramValueMap = contractDao.getContractParameters(contractId, paramIds);
            for (Map.Entry<Integer, EntityAttr> entry : paramValueMap.entrySet()) {
                Object dateParamValue;
                EntityAttr entityAttr = entry.getValue();
                if (entityAttr instanceof EntityAttrText) {
                    EntityAttrText text = (EntityAttrText)entityAttr;
                    paramValue.put(entry.getKey(), text.getValue());
                    continue;
                }
                entityAttr = entry.getValue();
                if (entityAttr instanceof EntityAttrAddress) {
                    EntityAttrAddress address = (EntityAttrAddress)entityAttr;
                    paramValue.put(entry.getKey(), address.getTitle());
                    continue;
                }
                entityAttr = entry.getValue();
                if (entityAttr instanceof EntityAttrBoolean) {
                    EntityAttrBoolean bool;
                    paramValue.put(entry.getKey(), (bool = (EntityAttrBoolean)entityAttr).getValue() ? "\u0432\u043a\u043b\u044e\u0447\u0435\u043d\u043e" : "\u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u043e");
                    continue;
                }
                entityAttr = entry.getValue();
                if (entityAttr instanceof EntityAttrDate) {
                    EntityAttrDate date = (EntityAttrDate)entityAttr;
                    dateParamValue = date.getValue();
                    if (dateParamValue == null) continue;
                    DateFormat format = TimeUtils.getDateFormat((String)"dd.MM.yyyy");
                    paramValue.put(entry.getKey(), TimeUtils.format((Date)dateParamValue, (DateFormat)format));
                    continue;
                }
                dateParamValue = entry.getValue();
                if (dateParamValue instanceof EntityAttrEmail) {
                    EntityAttrEmail email = (EntityAttrEmail)dateParamValue;
                    String emails = email.toString().trim();
                    emails = emails.replaceAll("\n", "; ");
                    emails = emails.replaceAll("<", "&lt;");
                    emails = emails.replaceAll(">", "&gt;");
                    paramValue.put(entry.getKey(), emails);
                    continue;
                }
                entityAttr = entry.getValue();
                if (entityAttr instanceof EntityAttrPhone) {
                    EntityAttrPhone phone = (EntityAttrPhone)entityAttr;
                    paramValue.put(entry.getKey(), phone.toString());
                    continue;
                }
                entityAttr = entry.getValue();
                if (!(entityAttr instanceof EntityAttrList)) continue;
                EntityAttrList list = (EntityAttrList)entityAttr;
                paramValue.put(entry.getKey(), list.toString());
            }
            for (Map.Entry<Integer, Object> entry : contractParameterManager.getMultiListParamValueMap(contractId, new HashSet<Integer>(paramIds)).entrySet()) {
                MultiListParamValues listParamValue = (MultiListParamValues)entry.getValue();
                if (listParamValue == null) continue;
                paramValue.put(entry.getKey(), listParamValue.toStringValue());
            }
        }
        return paramValue;
    }
}

