/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean;

import bitel.billing.server.contract.bean.ContractScriptManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebMenuDao;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.security.server.PermissionOfRoles;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractCreateData;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractFilters;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPattern;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffGroup;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.enums.ContractFace;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.enums.ContractMode;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroup;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroupAttr;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterListItem;
import ru.bitel.bgbilling.kernel.contract.api.common.dto.ContractSearchDto;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractModifiedEvent;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractStatusDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.ContractTariffGroupDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.label.server.bean.ContractLabelManager;
import ru.bitel.bgbilling.kernel.contract.limit.server.bean.LimitManager;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObject;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ObjectDao;
import ru.bitel.bgbilling.kernel.contract.pattern.server.bean.ContractPatternDao;
import ru.bitel.bgbilling.kernel.contract.script.common.bean.ContractScript;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatus;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.directory.api.server.ServerDirectoryFactory;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCloseEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.generator.common.bean.BGGenerator;
import ru.bitel.bgbilling.kernel.generator.server.bean.BGGeneratorDao;
import ru.bitel.bgbilling.kernel.module.common.bean.PermissionKit;
import ru.bitel.bgbilling.kernel.module.common.bean.Role;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IndexHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.entity.common.bean.AbstractSpecAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrBoolean;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrList;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrMultiList;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpec;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrList;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrMultiList;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrPhone;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrText;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;

public class ContractDao
extends AbstractEntityAttrDao<Contract> {
    public static final String MESSAGE_ABOUT_DUPLICATE = "\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u0441 \u0442\u0430\u043a\u0438\u043c \u0438\u043c\u0435\u043d\u0435\u043c \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!";

    public ContractDao(Connection con, int userId) {
        super(con, "contract", "contract", CONTRACT_SUPPORT, 0, userId);
    }

    @Override
    public Directory<? extends EntitySpec> getEntitySpecDirectory() throws BGException {
        if (this.entitySpecDirectory == null) {
            this.entitySpecDirectory = ServerDirectoryFactory.newUnmodifiableDirectory(ContractParameterGroup.class, this.con, 0, true);
        }
        return this.entitySpecDirectory;
    }

    @Override
    protected Directory<? extends AbstractSpecAttr> getEntitySpecAttrDirectory() throws BGException {
        if (this.entitySpecAttrDirectory == null) {
            this.entitySpecAttrDirectory = ServerDirectoryFactory.newUnmodifiableDirectory(ContractParameterGroupAttr.class, this.con, 0, true);
        }
        return this.entitySpecAttrDirectory;
    }

    @Override
    protected Contract getFromRS(ResultSet rs, boolean loadAttributes) throws SQLException, BGException {
        return Contract.builder().setId(rs.getInt("id")).setTitle(rs.getString("title")).setPassword(rs.getString("pswd")).setComment(rs.getString("comment")).setBalanceMode(rs.getByte("mode")).setBalanceLimit(rs.getBigDecimal("closesumma")).setGroups(rs.getLong("gr")).setPersonType(rs.getByte("fc")).setParamGroupId(rs.getInt("pgid")).setDateFrom(rs.getDate("date1")).setDateTo(rs.getDate("date2")).setHidden(rs.getBoolean("del")).setSuperContractId(rs.getInt("scid")).setDependSubList(rs.getString("sub_list")).setBalanceSubMode(rs.getByte("sub_mode")).setStatus(rs.getByte("status")).setCommentPatternId(rs.getInt("title_pattern_id")).setStatusTimeChange(rs.getDate("status_date")).setDomainId(rs.getInt("domainId")).build();
    }

    public boolean updateContractParameter(int contractId, EntityAttr entityAttr) throws BGException {
        try {
            return super.updateEntityAttribute(contractId, entityAttr);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public boolean deleteContractParameter(int entityId, int entitySpecAttrId) throws BGException {
        return super.deleteEntityAttribute(entityId, entitySpecAttrId);
    }

    @Deprecated
    public void updateContractParameters(int contractId, Map<Integer, EntityAttr> entityAttributes) throws BGException {
        try {
            super.updateEntityAttributes(contractId, entityAttributes);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public Map<Integer, EntityAttr> getContractParameters(int contractId, int paramGroupId) throws Exception {
        Map<Object, Object> result = paramGroupId > 0 ? super.getEntityAttributes(paramGroupId, contractId, false) : super.getAllEntityAttributes(contractId, false);
        return result != null ? result : new HashMap(4);
    }

    public Map<Integer, EntityAttr> getContractParameters(int entityId, Set<Integer> entitySpecAttrIds) throws Exception {
        return super.getEntityAttributes(entityId, entitySpecAttrIds);
    }

    public Map<Integer, String> getContractParameterValuesForParameterIds(int contractId, Set<Integer> parameterIds) throws Exception {
        return super.getEntityValueForIds(contractId, parameterIds);
    }

    public EntityAttr getContractParameter(int contractId, int parameterId) throws BGException {
        return super.getEntityAttribute(contractId, parameterId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchContractByParameterText(SearchResult<ContractSearchDto> searchResult, ContractFilters contractFilters, FilterEntityAttrText filterEntityAttrText) throws SQLException {
        Objects.requireNonNull(searchResult, "searchResult must be not null");
        Objects.requireNonNull(contractFilters, "contractFilters must be not null");
        Objects.requireNonNull(filterEntityAttrText, "filterEntityAttrText must be not null");
        String tableName = "contract_by_param_text";
        String query = "CREATE TEMPORARY TABLE " + tableName + " AS SELECT contract.id AS contract_id, contract.title AS contract_title, contract.comment AS contract_comment, param.val AS parameter_value FROM contract_parameter_type_1 AS param LEFT JOIN contract ON contract.id=param.cid WHERE true AND UPPER(param.val) REGEXP ? " + this.getWhereParameterIds(filterEntityAttrText.getEntitySpecAttrIds(), "pid") + this.getFilter(contractFilters, "contract") + "ORDER BY contract.title";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            IndexHolder index = new IndexHolder();
            ps.setString(index.getNext(), filterEntityAttrText.getValue().toUpperCase());
            ps.executeUpdate();
            Page page = searchResult.getPage();
            this.listContractSearchDto(tableName, searchResult.getList(), page, rs -> rs.getString("parameter_value"));
            this.setPageRecordCount(tableName, page);
        }
        finally {
            this.dropTemporaryTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchContractByobjectParameterText(SearchResult<ContractSearchDto> searchResult, ContractFilters contractFilters, FilterEntityAttrText filterEntityAttrText) throws SQLException {
        Objects.requireNonNull(searchResult, "searchResult must be not null");
        Objects.requireNonNull(contractFilters, "contractFilters must be not null");
        Objects.requireNonNull(filterEntityAttrText, "filterEntityAttrText must be not null");
        String tableName = "contract_by_object_param_text";
        String query = "CREATE TEMPORARY TABLE " + tableName + " AS SELECT contract.id AS contract_id, contract.title AS contract_title, contract.comment AS contract_comment, param.value AS parameter_value FROM object_param_value_text AS param LEFT JOIN object ON object.id=param.object_id LEFT JOIN contract ON contract.id=object.cid WHERE true AND UPPER(param.value) REGEXP ? " + this.getWhereParameterIds(filterEntityAttrText.getEntitySpecAttrIds(), "param_id") + this.getFilter(contractFilters, "contract") + "ORDER BY contract.title";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            IndexHolder index = new IndexHolder();
            ps.setString(index.getNext(), filterEntityAttrText.getValue().toUpperCase());
            ps.executeUpdate();
            Page page = searchResult.getPage();
            this.listContractSearchDto(tableName, searchResult.getList(), page, rs -> rs.getString("parameter_value"));
            this.setPageRecordCount(tableName, page);
        }
        finally {
            this.dropTemporaryTable(tableName);
        }
    }

    public Optional<EntityAttrText> optContractParameterText(int contractId, int parameterId) throws BGException {
        return super.optEntityAttribute(contractId, parameterId).filter(a -> a instanceof EntityAttrText).map(a -> (EntityAttrText)a);
    }

    public Optional<String> optContractParameterTextAsString(int contractId, int parameterId) throws BGException {
        return this.optContractParameterText(contractId, parameterId).map(EntityAttrText::getValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchContractByParameterDate(SearchResult<ContractSearchDto> searchResult, ContractFilters contractFilters, FilterEntityAttrDate filterEntityAttrDate) throws SQLException {
        Objects.requireNonNull(searchResult, "searchResult must be not null");
        Objects.requireNonNull(contractFilters, "contractFilters must be not null");
        Objects.requireNonNull(filterEntityAttrDate, "filterEntityAttrDate must be not null");
        Date date1 = filterEntityAttrDate.getPeriodFrom();
        Date date2 = filterEntityAttrDate.getPeriodTo();
        String tableName = "contract_by_param_date";
        String query = "CREATE TEMPORARY TABLE " + tableName + " AS SELECT contract.id AS contract_id, contract.title AS contract_title, contract.comment AS contract_comment, param.val AS parameter_value FROM contract_parameter_type_6 AS param LEFT JOIN contract ON contract.id=param.cid WHERE true " + this.getWhereParameterIds(filterEntityAttrDate.getEntitySpecAttrIds(), "pid") + this.getFilter(contractFilters, "contract") + Optional.ofNullable(date1).map(a -> "AND param.val>=? ").orElse("") + Optional.ofNullable(date2).map(a -> "AND param.val<=? ").orElse("") + "ORDER BY contract.title";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            IndexHolder index = new IndexHolder();
            this.psSetDate(ps, date1 != null, index, date1);
            this.psSetDate(ps, date2 != null, index, date2);
            ps.executeUpdate();
            Page page = searchResult.getPage();
            this.listContractSearchDto(tableName, searchResult.getList(), page, rs -> TimeUtils.format((Date)rs.getDate("parameter_value"), (String)"dd.MM.yyyy"));
            this.setPageRecordCount(tableName, page);
        }
        finally {
            this.dropTemporaryTable(tableName);
        }
    }

    public Optional<EntityAttrDate> optContractParameterDate(int contractId, int parameterId) throws BGException {
        return super.optEntityAttribute(contractId, parameterId).filter(a -> a instanceof EntityAttrDate).map(a -> (EntityAttrDate)a);
    }

    public Date getContractParameterDate(int contractId, int parameterId, Date defaultValue) throws BGException {
        return this.optContractParameterDate(contractId, parameterId).map(EntityAttrDate::getValue).orElse(defaultValue);
    }

    public Optional<EntityAttrBoolean> optContractParameterBoolean(int contractId, int parameterId) throws BGException {
        return super.optEntityAttribute(contractId, parameterId).filter(a -> a instanceof EntityAttrBoolean).map(a -> (EntityAttrBoolean)a);
    }

    public Boolean getContractParameterBoolean(int contractId, int parameterId, Boolean defaultValue) throws BGException {
        return this.optContractParameterBoolean(contractId, parameterId).map(EntityAttrBoolean::getValue).orElse(defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchContractByParameterPhone(SearchResult<ContractSearchDto> searchResult, ContractFilters contractFilters, FilterEntityAttrPhone filterEntityAttrPhone) throws SQLException {
        Objects.requireNonNull(searchResult, "searchResult must be not null");
        Objects.requireNonNull(contractFilters, "contractFilters must be not null");
        Objects.requireNonNull(filterEntityAttrPhone, "filterEntityAttrPhone must be not null");
        String phone = filterEntityAttrPhone.getValue();
        String tableName = "contract_by_param_date";
        String query = "CREATE TEMPORARY TABLE " + tableName + " AS SELECT contract.id AS contract_id, contract.title AS contract_title, contract.comment AS contract_comment, param.phone AS parameter_value FROM contract_parameter_type_phone_item AS param LEFT JOIN contract ON contract.id=param.cid WHERE true " + this.getWhereParameterIds(filterEntityAttrPhone.getEntitySpecAttrIds(), "pid") + this.getFilter(contractFilters, "contract") + Optional.ofNullable(phone).map(a -> "AND param.phone REGEXP ? ").orElse("") + "ORDER BY contract.title";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            IndexHolder index = new IndexHolder();
            this.psSetString(ps, phone != null, index, phone);
            ps.executeUpdate();
            Page page = searchResult.getPage();
            this.listContractSearchDto(tableName, searchResult.getList(), page, rs -> rs.getString("parameter_value"));
            this.setPageRecordCount(tableName, page);
        }
        finally {
            this.dropTemporaryTable(tableName);
        }
    }

    public Optional<EntityAttrPhone> getContractParameterPhone(int contractId, int parameterId) throws BGException {
        return super.optEntityAttribute(contractId, parameterId).filter(a -> a instanceof EntityAttrPhone).map(a -> (EntityAttrPhone)a);
    }

    public String getContractParameterPhoneFirst(int contractId, int parameterId) throws BGException {
        return super.optEntityAttribute(contractId, parameterId).filter(a -> a instanceof EntityAttrPhone && !((EntityAttrPhone)a).toUnformattedPhoneList().isEmpty()).map(a -> (String)((EntityAttrPhone)a).toUnformattedPhoneList().get(0)).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchContractByParameterEmail(SearchResult<ContractSearchDto> searchResult, ContractFilters contractFilters, FilterEntityAttrEmail filterEntityAttrEmail) throws SQLException {
        Objects.requireNonNull(searchResult, "searchResult must be not null");
        Objects.requireNonNull(contractFilters, "contractFilters must be not null");
        Objects.requireNonNull(filterEntityAttrEmail, "filterEntityAttrEmail must be not null");
        String email = filterEntityAttrEmail.getValue();
        String tableName = "contract_by_param_email";
        String query = "CREATE TEMPORARY TABLE " + tableName + " AS SELECT contract.id AS contract_id, contract.title AS contract_title, contract.comment AS contract_comment, param.email AS parameter_value FROM contract_parameter_type_3 AS param LEFT JOIN contract ON contract.id=param.cid WHERE true " + this.getWhereParameterIds(filterEntityAttrEmail.getEntitySpecAttrIds(), "pid") + this.getFilter(contractFilters, "contract") + Optional.ofNullable(email).map(a -> "AND param.email REGEXP ? ").orElse("") + "ORDER BY contract.title";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            IndexHolder index = new IndexHolder();
            this.psSetString(ps, email != null, index, email);
            ps.executeUpdate();
            Page page = searchResult.getPage();
            this.listContractSearchDto(tableName, searchResult.getList(), page, rs -> rs.getString("parameter_value"));
            this.setPageRecordCount(tableName, page);
        }
        finally {
            this.dropTemporaryTable(tableName);
        }
    }

    public Optional<EntityAttrEmail> getContractParameterEmail(int contractId, int parameterId) throws BGException {
        return super.optEntityAttribute(contractId, parameterId).filter(a -> a instanceof EntityAttrEmail).map(a -> (EntityAttrEmail)a);
    }

    public Optional<String> optContractParameterEmailFirst(int contractId, int parameterId) throws BGException {
        return super.optEntityAttribute(contractId, parameterId).filter(a -> a instanceof EntityAttrEmail && !((EntityAttrEmail)a).getAddressList().isEmpty()).map(a -> (String)((EntityAttrEmail)a).getAddressList().get(0));
    }

    public Optional<String> optContractParameterEmailAsString(int contractId, int parameterId) throws BGException {
        return this.getContractParameterEmail(contractId, parameterId).map(EntityAttrEmail::toString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchContractByParameterList(SearchResult<ContractSearchDto> searchResult, ContractFilters contractFilters, FilterEntityAttrList filterEntityAttrList) throws SQLException {
        Objects.requireNonNull(searchResult, "searchResult must be not null");
        Objects.requireNonNull(contractFilters, "contractFilters must be not null");
        Objects.requireNonNull(filterEntityAttrList, "filterEntityAttrList must be not null");
        int parameterId = filterEntityAttrList.getEntitySpecAttrId();
        Set valueIds = filterEntityAttrList.getValueIds();
        String tableName = "contract_by_param_list";
        String query = "CREATE TEMPORARY TABLE " + tableName + " AS SELECT contract.id AS contract_id, contract.title AS contract_title, contract.comment AS contract_comment, t3.title AS parameter_value FROM contract_parameter_type_7 AS param LEFT JOIN contract ON contract.id=param.cid LEFT JOIN contract_parameter_type_7_values AS t3 ON t3.id=param.val AND t3.pid=param.pid WHERE true " + (String)(parameterId > 0 ? "AND param.pid=" + parameterId + " " : "") + this.getFilter(contractFilters, "contract") + (String)(valueIds != null && !valueIds.isEmpty() ? "AND param.val IN ( " + Utils.toString((Iterable)valueIds) + " ) " : "") + "ORDER BY contract.title";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.executeUpdate();
            Page page = searchResult.getPage();
            this.listContractSearchDto(tableName, searchResult.getList(), page, rs -> rs.getString("parameter_value"));
            this.setPageRecordCount(tableName, page);
        }
        finally {
            this.dropTemporaryTable(tableName);
        }
    }

    public Optional<EntityAttrList> getContractParameterList(int contractId, int parameterId) throws BGException {
        return super.optEntityAttribute(contractId, parameterId).filter(a -> a instanceof EntityAttrList).map(a -> (EntityAttrList)a);
    }

    public Optional<String> getContractParameterListAsString(int contractId, int parameterId) throws BGException {
        Optional<EntityAttrList> attrList = super.optEntityAttribute(contractId, parameterId).filter(a -> a instanceof EntityAttrList).map(a -> (EntityAttrList)a);
        Directory<ContractParameterListItem> directory = ServerDirectoryFactory.newUnmodifiableDirectory(ContractParameterListItem.class, this.con, parameterId, true);
        return Optional.ofNullable(attrList.isEmpty() ? null : (attrList.get().getValue() > 0 ? directory.get(attrList.get().getValue()).getTitle() : attrList.get().getCustomValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchContractByParameterMultiList(SearchResult<ContractSearchDto> searchResult, ContractFilters contractFilters, FilterEntityAttrMultiList filterEntityAttrMultiList) throws SQLException {
        Objects.requireNonNull(searchResult, "searchResult must be not null");
        Objects.requireNonNull(contractFilters, "contractFilters must be not null");
        Objects.requireNonNull(filterEntityAttrMultiList, "filterEntityAttrMultiList must be not null");
        int parameterId = filterEntityAttrMultiList.getEntitySpecAttrId();
        Set valueIds = filterEntityAttrMultiList.getValueIds();
        String tableName = "contract_by_param_multilist";
        String query = "CREATE TEMPORARY TABLE " + tableName + " AS SELECT contract.id AS contract_id, contract.title AS contract_title, contract.comment AS contract_comment, t3.title AS parameter_value FROM contract_parameter_type_multilist_item AS param LEFT JOIN contract ON contract.id=param.cid LEFT JOIN contract_parameter_type_multilist_values AS t3 ON t3.id=param.val AND t3.pid=param.pid WHERE true " + (String)(parameterId > 0 ? "AND param.pid=" + parameterId + " " : "") + this.getFilter(contractFilters, "contract") + (String)(valueIds != null && !valueIds.isEmpty() ? "AND param.val IN ( " + Utils.toString((Iterable)valueIds) + " ) " : "") + "ORDER BY contract.title";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.executeUpdate();
            Page page = searchResult.getPage();
            this.listContractSearchDto(tableName, searchResult.getList(), page, rs -> rs.getString("parameter_value"));
            this.setPageRecordCount(tableName, page);
        }
        finally {
            this.dropTemporaryTable(tableName);
        }
    }

    public Optional<EntityAttrMultiList> getContractParameterMultiList(int contractId, int parameterId) throws BGException {
        return super.optEntityAttribute(contractId, parameterId).filter(a -> a instanceof EntityAttrMultiList).map(a -> (EntityAttrMultiList)a);
    }

    public Optional<String> getContractParameterMultiListAsString(int contractId, int parameterId) throws BGException {
        Optional<EntityAttrMultiList> attrMultiList = this.getContractParameterMultiList(contractId, parameterId);
        return Optional.ofNullable(attrMultiList.isEmpty() ? null : attrMultiList.get().getTitle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchContractByParameterAddress(SearchResult<ContractSearchDto> searchResult, ContractFilters contractFilters, FilterEntityAttrAddress filterEntityAttrAddress) throws SQLException {
        Objects.requireNonNull(searchResult, "searchResult must be not null");
        Objects.requireNonNull(contractFilters, "contractFilters must be not null");
        Objects.requireNonNull(filterEntityAttrAddress, "filterEntityAttrAddress must be not null");
        int streetId = filterEntityAttrAddress.getStreetId();
        int houseId = filterEntityAttrAddress.getHouseId();
        String flat = filterEntityAttrAddress.getFlat();
        String room = filterEntityAttrAddress.getRoom();
        Object whereHouse = "";
        if (houseId > 0) {
            whereHouse = "AND param.hid=" + houseId + " ";
        } else if (streetId > 0) {
            whereHouse = "AND param.hid IN ( SELECT id FROM address_house WHERE streetid=" + streetId + " ) ";
        }
        String tableName = "contract_by_param_address";
        String query = "CREATE TEMPORARY TABLE " + tableName + " AS SELECT contract.id AS contract_id, contract.title AS contract_title, contract.comment AS contract_comment, param.address AS parameter_value FROM contract_parameter_type_2 AS param LEFT JOIN contract ON contract.id=param.cid WHERE true " + this.getWhereParameterIds(filterEntityAttrAddress.getEntitySpecAttrIds(), "pid") + (String)whereHouse + this.getFilter(contractFilters, "contract") + (Utils.notEmptyString((String)flat) ? "AND param.flat REGEXP ? " : "") + (Utils.notBlankString((String)room) ? "AND param.room REGEXP ? " : "") + "ORDER BY contract.title";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            IndexHolder index = new IndexHolder();
            this.psSetString(ps, Utils.notBlankString((String)flat), index, "^[^[:digit:]]*" + flat + "[^[:digit:]]*$");
            this.psSetString(ps, Utils.notBlankString((String)room), index, "^[^[:digit:]]*" + room + "[^[:digit:]]*$");
            ps.executeUpdate();
            Page page = searchResult.getPage();
            this.listContractSearchDto(tableName, searchResult.getList(), page, rs -> rs.getString("parameter_value"));
            this.setPageRecordCount(tableName, page);
        }
        finally {
            this.dropTemporaryTable(tableName);
        }
    }

    public Optional<EntityAttrAddress> getContractParameterAddress(int contractId, int parameterId) throws BGException {
        return super.optEntityAttribute(contractId, parameterId).filter(a -> a instanceof EntityAttrAddress).map(a -> (EntityAttrAddress)a);
    }

    public Optional<String> getContractParameterAddressAsString(int contractId, int parameterId) throws BGException {
        return Optional.ofNullable(this.getContractParameterAddress(contractId, parameterId).map(EntityAttrAddress::getTitle).orElse(null));
    }

    public String getEmailFromContractParameter(int contractId, int parameterId) throws BGException {
        if (contractId < 1 || parameterId < 1) {
            return null;
        }
        return this.optContractParameterEmailAsString(contractId, parameterId).orElse(this.optContractParameterTextAsString(contractId, parameterId).orElse(null));
    }

    protected void updateImpl(Contract contract) throws BGException, SQLException {
        if (contract == null) {
            throw new BGException("contract == null");
        }
        boolean update = contract.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET gr=?, title=?, title_pattern_id=?, pswd=?, date1=?, date2=?, mode=?, closesumma=?, pgid=?, fc=?, comment=?, del=?, scid=?, sub_list=?, sub_mode=?, status=?, status_date=?, domainId=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setLong(index++, contract.getGroups());
            ps.setString(index++, contract.getTitle() != null ? contract.getTitle().trim() : null);
            ps.setInt(index++, contract.getCommentPatternId());
            ps.setString(index++, contract.getPassword());
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)contract.getDateFrom()));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)contract.getDateTo()));
            ps.setInt(index++, contract.getBalanceMode());
            ps.setBigDecimal(index++, contract.getBalanceLimit());
            ps.setInt(index++, contract.getParamGroupId());
            ps.setInt(index++, contract.getPersonType());
            ps.setString(index++, contract.getComment());
            ps.setBoolean(index++, contract.isHidden());
            ps.setInt(index++, contract.getSuperCid());
            ps.setString(index++, contract.getDependSubList());
            ps.setInt(index++, contract.getBalanceSubMode());
            ps.setInt(index++, contract.getStatus());
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)contract.getStatusTimeChange()));
            ps.setInt(index++, contract.getDomainId());
            this.executeUpdate((Id)contract, index, ps);
            new ContractLabelManager(this.con).syncLabelAndGroupContract(contract.getId());
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    @Deprecated
    public void updateParameter(int contractId, EntityAttr a) throws BGException {
        try {
            super.updateEntityAttribute(contractId, a);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void updateMode(int contractId, ContractMode contractMode) throws BGException {
        if (contractId < 0 || contractMode == null) {
            return;
        }
        try {
            Object query = "UPDATE " + this.tableName + " SET mode=? WHERE id=?";
            try (PreparedStatement ps = this.con.prepareStatement((String)query);){
                ps.setInt(1, ContractMode.DEBET == contractMode ? 1 : 0);
                ps.setInt(2, contractId);
                ps.executeUpdate();
            }
            query = "INSERT INTO log_contract_mode VALUES ( now(), ?, ?, ? )";
            ps = this.con.prepareStatement((String)query);
            try {
                ps.setInt(1, this.userId);
                ps.setInt(2, ContractMode.DEBET == contractMode ? 1 : 0);
                ps.setInt(3, contractId);
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new BGException((Throwable)ex);
        }
        EventProcessor.getInstance().publishAfterCommit(new ContractModifiedEvent(this.userId, contractId));
    }

    public void updateFace(int contractId, ContractFace contractFace) throws BGException {
        if (contractId < 0 || contractFace == null) {
            return;
        }
        try {
            Object query = "UPDATE " + this.tableName + " SET fc=? WHERE id=?";
            try (PreparedStatement ps = this.con.prepareStatement((String)query);){
                ps.setInt(1, ContractFace.FIZIC == contractFace ? 0 : 1);
                ps.setInt(2, contractId);
                ps.executeUpdate();
            }
            query = "INSERT INTO log_contract_face VALUES ( now(), ?, ?, ? )";
            ps = this.con.prepareStatement((String)query);
            try {
                ps.setInt(1, this.userId);
                ps.setInt(2, ContractFace.FIZIC == contractFace ? 0 : 1);
                ps.setInt(3, contractId);
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new BGException((Throwable)ex);
        }
        EventProcessor.getInstance().publishAfterCommit(new ContractModifiedEvent(this.userId, contractId));
    }

    public boolean updatePassword(int contractId, String pswd1, String pswd2, boolean isPswdAuto) throws BGException {
        String error;
        boolean result = false;
        if (!isPswdAuto && (error = ContractUtils.checkPassword((ParameterMap)Setup.getSetup(), pswd1, pswd2)) != null) {
            throw new BGMessageException(error);
        }
        try {
            pswd1 = pswd1.trim();
            String query = "UPDATE contract SET pswd=? WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, pswd1);
            ps.setInt(2, contractId);
            ps.executeUpdate();
            ps.close();
            result = true;
        }
        catch (SQLException ex) {
            throw new BGMessageException(ex.getLocalizedMessage());
        }
        return result;
    }

    @Deprecated
    public List<Contract> list(String title, String comment, int fc, long groupMaskAnd, int firm, List<FilterEntityAttr> entityFilter, boolean subContracts, boolean closed, boolean hidden, Page page) throws BGException {
        ContractFilters contractFilters = ContractFilters.builder().setTitle(title).setComment(comment).setFaceType(fc).setGroupMask(groupMaskAnd).setSubContracts(subContracts).setClosed(closed).setHidden(hidden).build();
        return this.list(contractFilters, entityFilter, "title", page);
    }

    public List<Contract> list(ContractFilters contractFilters, List<FilterEntityAttr> entityFilter, Page page) throws BGException {
        return this.list(contractFilters, entityFilter, "title", page);
    }

    @Deprecated
    public List<Contract> list(String title, String comment, int fc, long groupMaskAnd, int firm, List<FilterEntityAttr> entityFilter, boolean subContracts, boolean closed, boolean hidden, String orderBy, Page page) throws BGException {
        ContractFilters contractFilters = ContractFilters.builder().setTitle(title).setComment(comment).setFaceType(fc).setGroupMask(groupMaskAnd).setSubContracts(subContracts).setClosed(closed).setHidden(hidden).build();
        return this.list(contractFilters, entityFilter, orderBy, page);
    }

    public List<Contract> list(ContractFilters contractFilters, List<FilterEntityAttr> entityFilter, Page page, Set<Integer> labelIds, boolean inAllLabels) throws BGException {
        return this.list(contractFilters, entityFilter, "title", page, labelIds, inAllLabels);
    }

    public List<Contract> list(ContractFilters contractFilters, List<FilterEntityAttr> entityFilter, String orderBy, Page page) throws BGException {
        return this.list(contractFilters, entityFilter, orderBy, page, null, false);
    }

    public List<Contract> list(ContractFilters contractFilters, List<FilterEntityAttr> entityFilter, String orderBy, Page page, Set<Integer> labelIds, boolean inAllLabels) throws BGException {
        Optional<User> userOpt;
        java.sql.Date sqlNow = TimeUtils.convertDateToSqlDate((Date)new Date());
        StringBuilder where = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        if (!(PermissionOfRoles.isAdmin(this.userId) && PermissionOfRoles.isPermissionCheckerDisabled() || !(userOpt = PermissionOfRoles.getUserById(this.userId)).isPresent())) {
            User user = userOpt.get();
            if (user.getContractCid() > 0 && user.getContractPid() > 0) {
                sb.append("LEFT JOIN contract_parameter_type_8 as par ON par.cid=contract.id ");
                if (user.getContractCid() > 0 && user.getContractPid() > 0) {
                    where.append(" AND par.pid=" + user.getContractPid() + " AND par.val=" + user.getContractCid());
                }
            } else {
                ContractDao.addLabelAndDomainFilter(where, user);
            }
        }
        sb.append("LEFT JOIN contract_label_link AS labels ON contract.id=labels.contract_id");
        String what = null;
        Object groupBy = "";
        if (Utils.notEmptyCollection(labelIds)) {
            what = this.tableName + ".* ";
            this.addLabelsWhereFilter(labelIds, where, inAllLabels);
            groupBy = (String)groupBy + "contract.id";
        }
        boolean titleRegexp = this.isRegexp(contractFilters.getTitle());
        boolean commentRegexp = this.isRegexp(contractFilters.getComment());
        ArrayList<Object> params = new ArrayList<Object>();
        if (contractFilters.getContractId() > 0) {
            params.add(contractFilters.getContractId());
        }
        params.add(contractFilters.getGroupMask());
        params.add(contractFilters.getGroupMask());
        params.add(contractFilters.getGroupMask());
        params.add(contractFilters.isSubContracts());
        params.add(contractFilters.getFaceType() != 0 && contractFilters.getFaceType() != 1);
        params.add(contractFilters.getFaceType());
        params.add(contractFilters.isClosed());
        params.add(sqlNow);
        params.add(contractFilters.isHidden());
        if (Utils.notBlankString((String)contractFilters.getTitle())) {
            params.add(contractFilters.getTitle());
            params.add(contractFilters.getTitle() != null ? (titleRegexp ? contractFilters.getTitle().toUpperCase() : "%" + contractFilters.getTitle() + "%") : null);
        }
        if (Utils.notBlankString((String)contractFilters.getComment())) {
            params.add(contractFilters.getComment());
            params.add(contractFilters.getComment() != null ? (commentRegexp ? contractFilters.getComment().toUpperCase() : "%" + contractFilters.getComment() + "%") : null);
        }
        params.add(Utils.notEmptyCollection(labelIds) || contractFilters.getTitle() != null || contractFilters.getComment() != null || contractFilters.getFaceType() != -1 || entityFilter != null && entityFilter.size() > 0 || contractFilters.getContractId() > 0);
        return super.list(false, page, what, sb.toString(), entityFilter, (contractFilters.getContractId() > 0 ? " contract.id=? AND " : "") + " (?=0 OR contract.gr&?=?)" + where.toString() + " AND (? OR contract.scid IN (0, -1)) AND (? OR contract.fc=?) AND (? OR contract.date2 IS NULL OR ?<=contract.date2) AND (? OR contract.del=0)" + (String)(Utils.isBlankString((String)contractFilters.getTitle()) ? "" : " AND (? IS NULL OR " + (titleRegexp ? "UPPER(contract.title) REGEXP" : "contract.title LIKE") + " ?)") + (String)(Utils.isBlankString((String)contractFilters.getComment()) ? "" : " AND (? IS NULL OR " + (commentRegexp ? "UPPER(contract.comment) REGEXP" : "contract.comment LIKE") + " ?)") + " AND (? OR contract.gr=0)", (String)groupBy, orderBy, params.toArray());
    }

    private void addLabelsWhereFilter(Set<Integer> labelIds, StringBuilder where, boolean inAllLabels) {
        if (inAllLabels) {
            if (!labelIds.isEmpty()) {
                where.append(" AND (SELECT COUNT(*)=" + labelIds.size() + " FROM contract_label_link WHERE contract_id=contract.id AND label_id IN (" + Utils.toString(labelIds) + ") )");
            }
        } else {
            where.append(" AND contract.id IN (SELECT contract_id FROM contract_label_link WHERE label_id IN (" + Utils.toString(labelIds) + ") )");
        }
    }

    private boolean isRegexp(String regex) {
        boolean result = false;
        try {
            Pattern.compile(regex);
            result = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public List<Contract> getContracts(String idList) throws BGException {
        ArrayList<Contract> result = new ArrayList<Contract>();
        if (Utils.isBlankString((String)idList)) {
            return result;
        }
        if ((idList = Utils.toString((Iterable)Utils.toIntegerList((String)idList))).length() == 0) {
            return result;
        }
        String query = "SELECT * FROM contract WHERE id IN ( " + idList + " )";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                result.add((Contract)((Object)this.getFromRS(rs)));
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<Contract> getSubContracts(int contractId) throws Exception {
        ArrayList<Contract> result = new ArrayList<Contract>();
        String query = "SELECT * FROM contract WHERE scid=? ORDER BY title";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add((Contract)((Object)this.getFromRS(rs)));
                }
            }
        }
        return result;
    }

    public List<Contract> getSubContracts(int contractId, int subMode) throws BGException {
        ArrayList<Contract> result = new ArrayList<Contract>();
        String query = "SELECT * FROM contract WHERE scid=? AND (? OR sub_mode=?) ORDER BY title";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setBoolean(2, subMode == -1);
            ps.setInt(3, subMode);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add((Contract)((Object)this.getFromRS(rs)));
                }
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public Contract getByTitle(String title) throws BGException {
        return (Contract)((Object)this.get("`title`=?", new Object[]{title}));
    }

    public Optional<Contract> optByTitle(String title) throws BGException {
        return Optional.ofNullable(this.getByTitle(title));
    }

    public void updatePassword(int contractId, String password) throws BGException {
        String query = "UPDATE contract SET pswd=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, password);
            ps.setInt(2, contractId);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public static void addLabelAndDomainFilter(StringBuilder where, User user) {
        if (user == null || user.getId() == 0 || PermissionOfRoles.isAdmin(user.getId()) || PermissionOfRoles.isPermissionCheckerDisabled()) {
            return;
        }
        Optional<Role> role = PermissionOfRoles.getRoleByUser(user);
        if (role.isEmpty()) {
            return;
        }
        int count = 0;
        for (PermissionKit kit : role.get().getPermissionKits()) {
            if (Utils.isEmptyCollection(kit.getDomenIds()) && Utils.isEmptyCollection(kit.getContractLabels())) continue;
            where.append(count == 0 ? " AND ( " : " OR ( ");
            if (Utils.notEmptyCollection(kit.getDomenIds())) {
                where.append(" contract.domainId IN (").append(Utils.toString(kit.getDomenIds())).append(") ");
            }
            if (Utils.notEmptyCollection(kit.getContractLabels())) {
                if (Utils.notEmptyCollection(kit.getDomenIds())) {
                    where.append(" AND");
                }
                where.append(" labels.label_id IN (").append(Utils.toString(kit.getContractLabels())).append(") ");
            }
            if (count > 0) {
                where.append(" )");
            }
            ++count;
        }
        if (count > 0) {
            where.append(" )");
        }
    }

    public void updateDomain(int contractId, int domainId) throws BGException {
        String query = "UPDATE contract SET domainId=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, domainId);
            ps.setInt(2, contractId);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<Contract> getContractByTextParameter(int parameterId, String value) throws BGException {
        ArrayList<Contract> result = new ArrayList<Contract>();
        String query = "SELECT * FROM contract_parameter_type_1 AS p LEFT JOIN contract AS c ON c.id=p.cid WHERE p.pid=? AND p.val=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, parameterId);
            ps.setString(index++, value);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add((Contract)((Object)this.getFromRS(rs)));
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public List<Contract> getContractForTextlikeParamValue(int parameterId, String value) {
        if (Utils.isBlankString((String)value)) {
            return null;
        }
        ArrayList<Contract> result = new ArrayList<Contract>();
        String query = "SELECT contract.* FROM contract LEFT JOIN contract_parameter_type_1 as param_string ON param_string.cid=contract.id AND param_string.pid=? LEFT JOIN contract_parameter_type_phone_item as param_phone_item ON param_phone_item.cid = contract.id AND param_phone_item.pid=? LEFT JOIN contract_parameter_type_3 as param_email ON param_email.cid = contract.id AND param_email.pid=? WHERE param_string.val=? OR param_phone_item.phone=? OR param_email.email LIKE ?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, parameterId);
            ps.setInt(index++, parameterId);
            ps.setInt(index++, parameterId);
            ps.setString(index++, value.trim());
            ps.setString(index++, value.trim().replace(" ", "").replace("+", ""));
            ps.setString(index++, "%<" + value.trim().replace(" ", "").replace(";", "") + ">%");
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add((Contract)((Object)this.getFromRS(rs)));
                }
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return result;
    }

    public String contractListByFilter(ContractFilters contractFilters, List<FilterEntityAttr> entityFilter, Page page) throws BGException {
        return "{}";
    }

    public void checkContractParameter(EntityAttr entityAttr) throws BGException {
        super.checkEntityAttribute(entityAttr);
    }

    public Contract createFromPattern(ContractCreateData data, boolean inModules) throws Exception {
        return this.createFromPattern(data, null, inModules);
    }

    public Contract createFromPattern(ContractCreateData data, Map<String, Object> params, boolean inModules) throws Exception {
        Contract result = null;
        String title = data.getTitle();
        String query = null;
        try (Statement st = this.con.createStatement();){
            Object ps;
            ContractPatternDao contractPatternDao = new ContractPatternDao(this.con);
            int id = -1;
            ContractPattern pattern = contractPatternDao.getPattern(data.getPatternId());
            if (pattern == null) {
                pattern = new ContractPattern();
            }
            if (pattern.getId() > 0 && pattern.getData() != null && inModules) {
                ContractCreateEvent checkEvent = new ContractCreateEvent(this.userId, 0, pattern, params, true);
                checkEvent.setDateFrom(data.getDateFrom());
                checkEvent = EventProcessor.getInstance().request(checkEvent);
                if (Utils.notBlankString((String)checkEvent.getError())) {
                    throw new BGException(checkEvent.getError());
                }
            }
            this.con.commit();
            boolean add = false;
            if (data.getTitle() == null) {
                String namePattern;
                int namePatternId = pattern.getNamePatternId();
                String string = namePattern = namePatternId > 0 ? ((BGGenerator)new BGGeneratorDao(this.con).get(namePatternId)).getPattern() : "";
                if (data.getCustomTitle() != null) {
                    if (data.getCustomTitle().indexOf("${") == -1 && new ContractPatternDao(this.con).isContractTitleDuplicated(data.getCustomTitle(), false, -1)) {
                        throw new BGMessageException(MESSAGE_ABOUT_DUPLICATE);
                    }
                    namePattern = data.getCustomTitle();
                }
                if (Utils.notBlankString((String)namePattern)) {
                    title = new ContractPatternDao(this.con).getContractTitle(namePattern, data.getDateFrom(), data.getTitleParams());
                    add = true;
                }
            }
            if (add && !this.checkContractTitleOnDublication(title, -1) || !add && new ContractPatternDao(this.con).isContractTitleDuplicated(title, true, -1)) {
                throw new BGMessageException(MESSAGE_ABOUT_DUPLICATE);
            }
            if (Utils.isBlankString((String)title)) {
                title = "New contract";
            }
            if (pattern.getId() > 0) {
                long groups = pattern.getGroups();
                for (Integer contractLabelId : pattern.getContractLabels()) {
                    if (contractLabelId >= 66) continue;
                    groups |= 1L << contractLabelId - 2;
                }
                query = "INSERT INTO contract SET gr=?, title=?, pswd=?, date1=?, date2=?, closesumma=?, mode=?, pgid=?, fc=?, title_pattern_id=?, status=?, domainId=?";
                ps = this.con.prepareStatement(query);
                try {
                    ps.setLong(1, groups);
                    ps.setString(2, title);
                    ps.setString(3, data.getPassword());
                    ps.setDate(4, TimeUtils.convertDateToSqlDate((Date)data.getDateFrom()));
                    if (pattern.getDaysToLive() == 0) {
                        ps.setDate(5, null);
                    } else {
                        LocalDate dateFrom = TimeUtils.convertDateToLocalDate((Date)data.getDateFrom());
                        ps.setDate(5, TimeUtils.convertLocalDateToSqlDate((LocalDate)dateFrom.plusDays(pattern.getDaysToLive() - 1)));
                    }
                    ps.setBigDecimal(6, pattern.getClosesumma());
                    ps.setInt(7, pattern.getMode());
                    ps.setInt(8, pattern.getParamsGroupId());
                    ps.setInt(9, pattern.getFc());
                    ps.setInt(10, pattern.getPatternId());
                    ps.setInt(11, pattern.getStatus());
                    ps.setInt(12, pattern.getDomainId());
                    ps.executeUpdate();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            query = "INSERT INTO contract SET title=?, date1=?, pswd=?";
            try (PreparedStatement ps2 = this.con.prepareStatement(query);){
                ps2.setString(1, title);
                ps2.setDate(2, TimeUtils.convertDateToSqlDate((Date)data.getDateFrom()));
                ps2.setString(3, data.getPassword());
                ps2.executeUpdate();
            }
            id = ServerUtils.lastInsertId(this.con);
            new ContractLabelManager(this.con).setContractLabelIds(id, new ArrayList<Integer>(pattern.getContractLabels()));
            result = (Contract)this.get(id);
            ContractStatus contractStatus = ContractStatus.builder().setContractId(id).setStatus(pattern.getStatus()).setDateFrom(data.getDateFrom()).setDateTo(null).setComment("\u0421\u0442\u0430\u0442\u0443\u0441 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c").build();
            new ContractStatusDao(this.con).changeStatus(contractStatus, this.userId, false);
            if (result != null) {
                int tariffGroupId;
                List<String> serviceList;
                Element objectsElement;
                List<String> moduleList = pattern.getModuleList();
                if (moduleList != null && !moduleList.isEmpty()) {
                    query = "INSERT INTO contract_module SET cid=?, mid=?";
                    try (PreparedStatement ps3 = this.con.prepareStatement(query);){
                        ps3.setInt(1, result.getId());
                        for (String moduleId : moduleList) {
                            ps3.setString(2, moduleId);
                            ps3.executeUpdate();
                        }
                    }
                }
                if (pattern.getData() != null && (objectsElement = XMLUtils.selectElement((Node)pattern.getData(), (String)"//objects")) != null) {
                    ObjectDao com = new ObjectDao(this.con);
                    NodeList objects = objectsElement.getElementsByTagName("object");
                    for (int i = 0; i < objects.getLength(); ++i) {
                        Element singleObject = (Element)objects.item(i);
                        int oid = Utils.parseInt((String)singleObject.getAttribute("type"));
                        int amount = Utils.parseInt((String)singleObject.getAttribute("amount"));
                        for (int j = 0; j < amount; ++j) {
                            ContractObject newObj = ContractObject.builder().setTitle("").setContractId(id).setTypeId(oid).setDateFrom(data.getDateFrom()).build();
                            com.update((Object)newObj);
                        }
                    }
                }
                if ((serviceList = pattern.getServiceList()) != null && !serviceList.isEmpty()) {
                    query = "INSERT INTO contract_service SET cid=?, sid=?, date1=?, date2=?";
                    ps = this.con.prepareStatement(query);
                    try {
                        ps.setInt(1, result.getId());
                        ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)result.getDateFrom()));
                        ps.setDate(4, TimeUtils.convertDateToSqlDate((Date)result.getDateTo()));
                        for (String serviceId : serviceList) {
                            ps.setString(2, serviceId);
                            ps.executeUpdate();
                        }
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                }
                if (pattern.getTariffGroupList().size() > 0 && (tariffGroupId = pattern.getTariffGroupList().get(0).intValue()) > 0) {
                    ContractTariffGroup contractTariffGroup = ContractTariffGroup.builder().setContractId(result.getId()).setTariffGroupId(tariffGroupId).build();
                    new ContractTariffGroupDao(this.con).update((Object)contractTariffGroup);
                }
                query = "INSERT INTO contract_tariff SET cid=?, tpid=?, date1=?, date2=?, pos=?, tariff_group_id=?";
                try (PreparedStatement ps4 = this.con.prepareStatement(query);){
                    ps4.setInt(1, result.getId());
                    Object tariffData = pattern.getTariffPlanList();
                    if (data.getContractTariffs() != null && !data.getContractTariffs().isEmpty()) {
                        tariffData = data.getContractTariffs().stream().map(a -> String.valueOf(a.getTariffPlanId())).toList();
                    }
                    Iterator<String> serviceId = tariffData.iterator();
                    while (serviceId.hasNext()) {
                        Object tariffPlan = serviceId.next();
                        String[] aa = ((String)tariffPlan).split(":");
                        if (aa.length < 2) {
                            tariffPlan = (String)tariffPlan + ":0:-1:currentDate:0:unlim:0";
                        } else if (aa.length < 3) {
                            tariffPlan = (String)tariffPlan + ":-1:currentDate:0:unlim:0";
                        } else if (aa.length < 4) {
                            tariffPlan = (String)tariffPlan + ":currentDate:0:unlim:0";
                        }
                        aa = ((String)tariffPlan).split(":");
                        if (aa.length < 7) {
                            this.getLogger().error("createFromPattern: tariffPlan = {}; aa.length = {}", tariffPlan, (Object)aa.length);
                            continue;
                        }
                        LocalDate from = TimeUtils.getPeriodFrom((LocalDate)TimeUtils.convertDateToLocalDate((Date)result.getDateFrom()), (String)aa[3], (int)Utils.parseInt((String)aa[4]));
                        LocalDate to = TimeUtils.getPeriodTo((LocalDate)from, (String)aa[5], (int)Utils.parseInt((String)aa[6]));
                        ps4.setInt(2, Utils.parseInt((String)aa[0], (int)0));
                        ps4.setDate(3, TimeUtils.convertLocalDateToSqlDate((LocalDate)from));
                        ps4.setDate(4, TimeUtils.convertLocalDateToSqlDate((LocalDate)to));
                        ps4.setInt(5, Utils.parseInt((String)aa[1]));
                        ps4.setInt(6, Utils.parseInt((String)aa[2]));
                        ps4.executeUpdate();
                    }
                }
                ContractScriptManager contractScriptManager = new ContractScriptManager(this.con);
                for (Integer scriptId : pattern.getScriptList()) {
                    ContractScript contractScript = new ContractScript();
                    contractScript.setContractId(result.getId());
                    contractScript.setScriptId(scriptId);
                    contractScript.setPeriod(new Period(new Date(), null));
                    contractScriptManager.updateContractScript(contractScript);
                }
                int webMenuId = pattern.getWebMenuId();
                if (webMenuId > 0) {
                    new WebMenuDao(this.con).setWebMenuIdForContract(webMenuId, id);
                }
                if ("on".equals(pattern.getLimitMode())) {
                    new LimitManager(this.con).setLimitManageMode(this.userId, result.getId(), 0);
                }
                if (pattern != null && pattern.getData() != null && inModules) {
                    ContractCreateEvent contractCreateEvent = new ContractCreateEvent(this.userId, id, pattern, params, false);
                    contractCreateEvent.setDateFrom(result.getDateFrom());
                    contractCreateEvent.setDateTo(result.getDateTo());
                    contractCreateEvent = EventProcessor.getInstance().request(contractCreateEvent);
                }
            }
            if (data.getContractSuperId() > 0) {
                result.setSuperCid(data.getContractSuperId());
                result.setBalanceSubMode((byte)data.getContractSubMode());
                this.addSub(data.getContractSuperId(), id, data.getContractSubMode());
            }
        }
        catch (Exception ex) {
            if (!MESSAGE_ABOUT_DUPLICATE.equals(ex.getMessage())) {
                ContractPatternDao.removeContractTitleFromLastTitles(title);
            }
            if (ex instanceof BGMessageException) {
                throw ex;
            }
            this.logError(ex);
            throw new BGException(ex.getMessage(), ex.getCause());
        }
        return result;
    }

    public boolean checkContractTitleOnDublication(String contractTitle, int contractId) {
        boolean result = true;
        String query = "SELECT count(*) FROM contract WHERE " + (String)(contractId > 0 ? "id<>" + contractId + " AND " : "") + "UPPER(title)=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, contractTitle.toUpperCase());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1) == 0;
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return result;
    }

    public String addSub(int superId, int subId, int subMode) throws SQLException, BGException {
        ServerContext context;
        Contract contract = (Contract)this.get(subId);
        if (contract.getSuperCid() != 0) {
            return "\u0421\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u043c \u043c\u043e\u0436\u043d\u043e \u0441\u0434\u0435\u043b\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0435\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440!";
        }
        Contract superContract = (Contract)this.get(superId);
        if (superContract.isSub()) {
            return "\u0421\u0443\u043f\u0435\u0440\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u043c \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0432\u044b\u0441\u0442\u0443\u043f\u0430\u0442\u044c \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440!";
        }
        Date recalculateDate = this.getRecalculateDate(contract.getId());
        if (recalculateDate == null && subMode == 0) {
            return "\u0421\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0438\u043c\u0435\u0435\u0442 \u0437\u0430\u043f\u0438\u0441\u0438 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u0432 \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u043c \u043f\u0435\u0440\u0438\u043e\u0434\u0435!!";
        }
        String query = "UPDATE contract SET scid=?, sub_list='', sub_mode=? WHERE id=?";
        PreparedStatement psSetSuper = this.con.prepareStatement(query);
        psSetSuper.setInt(1, superId);
        psSetSuper.setInt(2, subMode);
        psSetSuper.setInt(3, subId);
        psSetSuper.executeUpdate();
        psSetSuper.close();
        this.updateSuperContractDependSubList(superId);
        if (subMode == 0) {
            query = "UPDATE contract_balance SET summa1=0 WHERE cid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, subId);
            ps.executeUpdate();
            ps.close();
            BalanceUtils bu = new BalanceUtils(this.con);
            bu.recalculateBalance(superId, recalculateDate);
            bu.recalculateBalance(subId, recalculateDate);
            bu.close();
        }
        if ((context = (ServerContext)ServerContext.get()) != null) {
            context.publishAfterCommit(new ContractModifiedEvent(this.userId, subId));
            context.publishAfterCommit(new ContractModifiedEvent(this.userId, superId));
        } else {
            EventProcessor.getInstance().publish(new ContractModifiedEvent(this.userId, subId));
            EventProcessor.getInstance().publish(new ContractModifiedEvent(this.userId, superId));
        }
        return null;
    }

    public void updateSuperContractDependSubList(int superId) throws SQLException {
        StringBuffer subList = new StringBuffer();
        String query = "SELECT id, sub_mode FROM contract WHERE scid=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, superId);
        boolean hasSub = false;
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            hasSub = true;
            int mode = rs.getInt(2);
            if (mode != 0) continue;
            if (subList.length() != 0) {
                subList.append(",");
            }
            subList.append(rs.getString(1));
        }
        ps.close();
        query = "UPDATE contract SET scid=?, sub_list=? WHERE id=?";
        ps = this.con.prepareStatement(query);
        if (!hasSub) {
            ps.setInt(1, 0);
            ps.setString(2, "");
        } else {
            ps.setInt(1, -1);
            ps.setString(2, subList.toString());
        }
        ps.setInt(3, superId);
        ps.executeUpdate();
        ps.close();
    }

    private Date getRecalculateDate(int cid) throws SQLException {
        GregorianCalendar recalculateDate = new GregorianCalendar();
        String query = "SELECT yy, mm FROM contract_balance WHERE cid=? ORDER BY yy, mm";
        try (PreparedStatement firstDatePs = this.con.prepareStatement(query);){
            firstDatePs.setInt(1, cid);
            try (ResultSet rs = firstDatePs.executeQuery();){
                if (rs.next()) {
                    recalculateDate = new GregorianCalendar(rs.getInt(1), rs.getInt(2) - 1, 1);
                }
            }
        }
        Calendar closePeriodDate = ClosedDateChecker.getInstance().getClosePeriodDate(1);
        if (closePeriodDate != null && TimeUtils.dateBefore((Calendar)recalculateDate, (Calendar)closePeriodDate)) {
            return null;
        }
        return recalculateDate.getTime();
    }

    public String freeContract(int contractId) throws Exception {
        Contract contract = (Contract)this.get(contractId);
        int superCid = contract.getSuperCid();
        Date recalculateDate = this.getRecalculateDate(contract.getId());
        if (recalculateDate == null && contract.getBalanceSubMode() == 0) {
            return "\u0421\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0438\u043c\u0435\u0435\u0442 \u0437\u0430\u043f\u0438\u0441\u0438 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u0432 \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u043c \u043f\u0435\u0440\u0438\u043e\u0434\u0435!!";
        }
        String query = "UPDATE contract SET scid=0, sub_list='' WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, contractId);
        ps.executeUpdate();
        ps.close();
        this.updateSuperContractDependSubList(superCid);
        if (contract.getBalanceSubMode() == 0) {
            BalanceUtils bu = new BalanceUtils(this.con);
            bu.recalculateBalance(superCid, recalculateDate);
            bu.recalculateBalance(contractId, recalculateDate);
            bu.close();
        }
        return null;
    }

    public void closeContract(int contractId) throws SQLException, BGException {
        this.closeContract(contractId, 0, 0, new Date());
    }

    public void closeContract(int contractId, int moduleId, int userId) throws SQLException, BGException {
        this.closeContract(contractId, moduleId, userId, new Date());
    }

    public void closeContract(int contractId, int moduleId, int userId, Date date) throws BGException {
        Contract contract = (Contract)this.get(contractId);
        if (contract == null) {
            throw new BGMessageException("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0431\u0430\u0437\u0435");
        }
        if (date != null) {
            String error;
            Calendar closedDate = null;
            closedDate = ClosedDateChecker.getClosePeriodDateIfChecking("ActionUpdateContractDate2", moduleId, userId);
            if (closedDate != null) {
                ClosedDateChecker.checkDatesForUpdate(closedDate, contract.getDateTo(), date);
            }
            ArrayList<Contract> dependSubList = new ArrayList<Contract>();
            if (contract.getSuperCid() == -1) {
                Iterator iterator = Utils.toIntegerList((String)contract.getDependSubList()).iterator();
                while (iterator.hasNext()) {
                    String error2;
                    int subContractId = (Integer)iterator.next();
                    Contract subContract = (Contract)this.get(subContractId);
                    dependSubList.add(subContract);
                    if (subContract.getDateTo() != null && TimeUtils.dateBeforeOrEq((Date)subContract.getDateTo(), (Date)date) || !Utils.notBlankString((String)(error2 = this.checkClosePossible(subContractId, date, userId)))) continue;
                    throw new BGMessageException("\u0421\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440 #" + subContractId + " " + error2);
                }
            }
            if (Utils.notBlankString((String)(error = this.checkClosePossible(contractId, date, userId)))) {
                throw new BGException(error);
            }
            if (contract.getSuperCid() == -1) {
                try {
                    for (Contract subContract : dependSubList) {
                        if (subContract.getDateTo() != null && TimeUtils.dateBeforeOrEq((Date)subContract.getDateTo(), (Date)date)) continue;
                        this.changeDate2(subContract.getId(), date, userId);
                    }
                }
                catch (Exception ex) {
                    throw new BGException((Throwable)ex);
                }
            }
        }
        try {
            this.changeDate2(contractId, date, userId);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<Contract> getContracts(List<Integer> ids) throws BGException {
        ArrayList<Contract> result = new ArrayList<Contract>();
        if (ids == null || ids.isEmpty()) {
            return result;
        }
        String query = "SELECT * FROM " + this.tableName + " WHERE id IN ( " + Utils.toString(ids) + " )";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                result.add((Contract)((Object)this.getFromRS(rs)));
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public List<Contract> getContractsByTitles(List<String> titles) throws BGException {
        ArrayList<Contract> result = new ArrayList<Contract>();
        if (titles != null && !titles.isEmpty()) {
            String query = "SELECT * FROM " + this.tableName + " WHERE title IN (" + ", ?".repeat(titles.size()).substring(1) + " )";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                int len = titles.size();
                for (int index = 1; index <= len; ++index) {
                    ps.setString(index, titles.get(index - 1));
                }
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        result.add((Contract)((Object)this.getFromRS(rs)));
                    }
                }
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
        return result;
    }

    public List<Integer> getContractIdsByTitles(List<String> titles) throws BGException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (titles != null && !titles.isEmpty()) {
            String query = "SELECT id FROM " + this.tableName + " WHERE true " + " OR title=?".repeat(titles.size());
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                int len = titles.size();
                for (int index = 1; index <= len; ++index) {
                    ps.setString(index, titles.get(index - 1));
                }
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        result.add(rs.getInt(1));
                    }
                }
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
        return result;
    }

    private String checkClosePossible(int contractId, Date date, int userId) throws BGException {
        ContractCloseEvent checkEvent = new ContractCloseEvent(userId, contractId, date, true);
        EventProcessor.getInstance().request(checkEvent);
        return checkEvent.getError();
    }

    private void changeDate2(int contractId, Date date, int userId) throws SQLException, BGException {
        if (date == null) {
            String query = "UPDATE contract SET date2=? WHERE id=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ps.setNull(1, 91);
                ps.setInt(2, contractId);
                ps.executeUpdate();
            }
        }
        java.sql.Date sqlDate = TimeUtils.convertDateToSqlDate((Date)date);
        String query = "UPDATE contract SET date2=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setDate(1, sqlDate);
            ps.setInt(2, contractId);
            ps.executeUpdate();
        }
        query = "UPDATE contract_service SET date2=? WHERE isNull( date2 ) AND cid=?";
        ps = this.con.prepareStatement(query);
        try {
            ps.setDate(1, sqlDate);
            ps.setInt(2, contractId);
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        query = "UPDATE contract_tariff SET date2=? WHERE isNull( date2 ) AND cid=?";
        ps = this.con.prepareStatement(query);
        ps.setDate(1, sqlDate);
        ps.setInt(2, contractId);
        ps.executeUpdate();
        ps.close();
        query = "UPDATE contract_tree_link SET date2=? WHERE isNull( date2 ) AND cid=?";
        ps = this.con.prepareStatement(query);
        ps.setDate(1, sqlDate);
        ps.setInt(2, contractId);
        ps.executeUpdate();
        ps.close();
        query = "UPDATE contract_script SET date2=? WHERE isNull( date2 ) AND cid=?";
        ps = this.con.prepareStatement(query);
        ps.setDate(1, sqlDate);
        ps.setInt(2, contractId);
        ps.executeUpdate();
        ps.close();
        query = "UPDATE object SET date2=? WHERE isNull( date2 ) AND cid=?";
        ps = this.con.prepareStatement(query);
        ps.setDate(1, sqlDate);
        ps.setInt(2, contractId);
        ps.executeUpdate();
        ps.close();
        EventProcessor.getInstance().request(new ContractCloseEvent(userId, contractId, date, false));
    }

    public boolean isSubContract(int contractId, int subContractId) throws SQLException {
        boolean result = false;
        String query = "SELECT * FROM " + this.tableName + " WHERE id=? AND scid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, subContractId);
            ps.setInt(2, contractId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = true;
                }
            }
        }
        return result;
    }

    private String getFilter(ContractFilters contractFilters, String tableNameDate2) {
        Object filter = contractFilters.isHidden() ? "" : " AND del=0";
        filter = (String)filter + (String)(contractFilters.getFaceType() > -1 ? " AND fc=" + contractFilters.getFaceType() + " " : "");
        if (!contractFilters.isSubContracts()) {
            filter = (String)filter + " AND scid IN ( 0, -1 ) ";
        }
        if (!contractFilters.isClosed()) {
            filter = (String)filter + " AND (" + tableNameDate2 + ".date2 IS NULL OR CURRENT_DATE<=" + tableNameDate2 + ".date2 ) ";
        }
        return filter;
    }

    private String getWhereParameterIds(Set<Integer> ids, String columnName) {
        return ids != null && !ids.isEmpty() ? " AND param." + columnName + " IN ( " + Utils.toString(ids) + " ) " : "";
    }

    private void listContractSearchDto(String tableName, List<ContractSearchDto> list, Page page, ParamValueFormater function) throws SQLException {
        String query = "SELECT * FROM " + tableName + Page.toSqlLimit((Page)page);
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                list.add(new ContractSearchDto().setContractId(rs.getInt("contract_id")).setContractTitle(rs.getString("contract_title")).setContractComment(rs.getString("contract_comment")).setSearchValue(function.format(rs)));
            }
        }
    }

    public static Contract getContract(Connection con, int contractId) throws BGException {
        try (ContractDao contractDao = new ContractDao(con, 0);){
            Contract contract = (Contract)contractDao.get(contractId);
            return contract;
        }
    }

    static {
        try {
            new AbstractEntityAttrDao.AddressItemModifiedEventListener(){

                @Override
                protected AbstractEntityAttrDao<?> newDao(ServerContext context) {
                    return new ContractDao(context.getConnection(), context.getUserId());
                }
            };
        }
        catch (Throwable ex) {
            BGLogger.error(ex);
        }
    }

    @FunctionalInterface
    public static interface ParamValueFormater {
        public String format(ResultSet var1) throws SQLException;
    }
}

