/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree;

import bitel.billing.server.tariff.bean.TimeLimitSet;
import bitel.billing.server.tariff.bean.TimeTypeCache;
import java.util.Calendar;
import java.util.Set;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.worker.ThreadContext;

public class TimeTypeFilterTariffTreeNode
extends TariffTreeNode<AbstractTariffRequest<?>, TariffContext, TreeContext, ThreadContext> {
    private int timeType;

    public TimeTypeFilterTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.timeType = parameterMap.getInt("time_type", 0);
    }

    @Override
    protected int executeImpl(Long treeNodeId, Long parentTreeNodeId, AbstractTariffRequest<?> req, TariffContext context, TreeContext treeContext, ThreadContext workerContext) {
        Calendar time = req.getTime();
        Set<Long> acceptedSet = req.getAcceptedSet(TimeTypeFilterTariffTreeNode.class);
        if (!acceptedSet.contains(parentTreeNodeId)) {
            if (this.timeType == 0) {
                return 1;
            }
            TimeLimitSet limitSet = (TimeLimitSet)TimeTypeCache.getLimitMap().get(this.timeType);
            if (limitSet == null) {
                this.getLogger().error("Time type with id = " + this.timeType + " not found!");
            }
            if (time != null && limitSet != null && limitSet.checkTime(time)) {
                acceptedSet.add(parentTreeNodeId);
                return 1;
            }
        }
        return 0;
    }
}

