/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server;

import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffGroup;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffMasterData;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffMasterDataParam;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.ContractTariffDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.ContractTariffGroupDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.ContractTariffMasterDataHandler;
import ru.bitel.bgbilling.kernel.contract.label.server.bean.ContractLabelManager;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffGroup;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffGroupDao;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffPlanDao;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Period;

public class ContractTariffMasterDataDefaultHandler
implements ContractTariffMasterDataHandler {
    private int userId;
    private Contract contract = null;
    private List<IdTitle> tariffGroups = null;
    private ContractTariffMasterDataParam param;
    private List<Integer> tariffGroupIds = new ArrayList<Integer>();
    private List<Integer> tariffGroupDefaultIds = new ArrayList<Integer>();
    private List<Integer> contractLabelIds = new ArrayList<Integer>();

    @Override
    public ContractTariffMasterData get(ContractTariffMasterDataParam contractTariffMasterDataParam, int userId) throws Exception {
        this.param = contractTariffMasterDataParam;
        this.userId = userId;
        ServerContext context = (ServerContext)ServerContext.get();
        try (TariffGroupDao tariffGroupDao = new TariffGroupDao(context.getConnection());){
            this.contract = ContractDao.getContract(context.getConnection(), this.param.getContractId());
            ContractTariffGroup tariffGroupDefault = (ContractTariffGroup)new ContractTariffGroupDao(context.getConnection()).get(this.param.getContractId());
            if (tariffGroupDefault != null) {
                this.tariffGroupDefaultIds = this.getTariffGroupIds(tariffGroupDao, tariffGroupDefault.getTariffGroupId());
            }
            if (this.param.getContractTariffId() > 0) {
                ContractTariff contractTariff = (ContractTariff)new ContractTariffDao(context.getConnection()).get(this.param.getContractTariffId());
                if (contractTariff != null) {
                    if (contractTariff.getTariffGroupId() > 0) {
                        this.tariffGroupIds = this.getTariffGroupIds(tariffGroupDao, contractTariff.getTariffGroupId());
                    } else if (contractTariff.getTariffGroupId() == 0) {
                        this.tariffGroupIds = this.tariffGroupDefaultIds;
                    }
                }
            } else {
                this.tariffGroupIds = this.tariffGroupDefaultIds;
            }
            this.contractLabelIds = new ContractLabelManager(context.getConnection()).getContractLabelIds(this.param.getContractId());
        }
        switch (contractTariffMasterDataParam.getMode()) {
            case NEW: {
                return this.tariffNew(this.param.getContractId());
            }
            case EDIT: {
                return this.tariffEdit(this.param.getContractTariffId());
            }
            case COPY: {
                return this.tariffCopy(this.param.getContractTariffId());
            }
            case CHANGE: {
                return this.tariffChange(this.param.getContractTariffId());
            }
        }
        return null;
    }

    protected List<Integer> getTariffGroupIds(TariffGroupDao tariffGroupDao, int tariffGroupId) throws Exception {
        TariffGroup tariffGroup = (TariffGroup)tariffGroupDao.get(tariffGroupId);
        if (tariffGroup != null) {
            return tariffGroup.getPlanList().stream().map(a -> a.getId()).toList();
        }
        return new ArrayList<Integer>();
    }

    @Override
    public ContractTariffMasterData tariffNew(int contractId) throws Exception {
        ContractTariff contractTariff = new ContractTariff().setContractId(contractId).setPeriod(new Period(LocalDate.now(), null));
        return new ContractTariffMasterData().setContractTariff(contractTariff).setTariffs(this.getTariffs()).setTariffGroups(this.getTariffGroups());
    }

    @Override
    public ContractTariffMasterData tariffEdit(int contractTariffId) throws Exception {
        return new ContractTariffMasterData().setContractTariff(this.contractTariff(contractTariffId)).setTariffs(this.getTariffs()).setTariffGroups(this.getTariffGroups());
    }

    @Override
    public ContractTariffMasterData tariffCopy(int contractTariffId) throws Exception {
        ContractTariff newContractTariff = this.contractTariff(contractTariffId).setPeriod(new Period(LocalDate.now(), null)).setReplacedFromContractTariffId(contractTariffId);
        newContractTariff.setId(0);
        return new ContractTariffMasterData().setContractTariff(newContractTariff).setTariffs(this.getTariffs()).setTariffGroups(this.getTariffGroups());
    }

    @Override
    public ContractTariffMasterData tariffChange(int contractTariffId) throws Exception {
        ContractTariff newContractTariff = this.contractTariff(contractTariffId).setComment("").setPeriod(new Period(LocalDate.now(), null)).setReplacedFromContractTariffId(contractTariffId);
        newContractTariff.setId(0);
        return new ContractTariffMasterData().setContractTariff(newContractTariff).setTariffs(this.getTariffs()).setTariffGroups(this.getTariffGroups());
    }

    protected ContractTariff contractTariff(int contractTariffId) throws SQLException {
        ServerContext context = (ServerContext)ServerContext.get();
        return (ContractTariff)new ContractTariffDao(context.getConnection()).get(contractTariffId);
    }

    @Deprecated
    protected List<TariffPlan> contractTariffs() throws Exception {
        return this.tariffPlans();
    }

    protected List<TariffPlan> tariffPlans() throws Exception {
        ServerContext context = (ServerContext)ServerContext.get();
        try (TariffPlanDao tariffDao = new TariffPlanDao(context.getConnection());){
            List<TariffPlan> list = tariffDao.list();
            return list;
        }
    }

    protected List<TariffGroup> contractTariffGroups() throws Exception {
        ServerContext context = (ServerContext)ServerContext.get();
        try (TariffGroupDao tariffDao = new TariffGroupDao(context.getConnection());){
            List<TariffGroup> list = tariffDao.list();
            return list;
        }
    }

    protected IdTitle getTariffGroupDefault() {
        return new IdTitle(-1, "<\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e>");
    }

    protected IdTitle getTariffGroupNoSet() {
        return new IdTitle(0, "<\u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430>");
    }

    protected List<IdTitle> getTariffGroups() throws Exception {
        if (this.tariffGroups == null) {
            this.tariffGroups = new ArrayList<IdTitle>(this.contractTariffGroups().stream().map(IdTitle::toIdTitle).toList());
            this.tariffGroups.add(0, this.getTariffGroupNoSet());
            this.tariffGroups.add(0, this.getTariffGroupDefault());
        }
        return this.tariffGroups;
    }

    protected List<IdTitle> getTariffs() throws Exception {
        int tariffPlanId = Optional.ofNullable(this.contractTariff(this.param.getContractTariffId())).map(a -> a.getTariffPlanId()).orElse(0);
        ArrayList<IdTitle> tariffs = new ArrayList<IdTitle>(this.tariffPlans().stream().filter(a -> a.getId() != tariffPlanId).filter(a -> a.isUsed()).filter(a -> a.getFilterFace() == 0 || a.getFilterFace() - 1 == this.contract.getPersonType()).filter(a -> this.checkContractLabel(a.getFilterContractLabelIds())).filter(a -> this.checkUserFilter((TariffPlan)a)).map(IdTitle::toIdTitle).toList());
        if (this.param.getContractTariffId() > 0) {
            tariffs.add(0, this.tariffPlans().stream().filter(a -> a.getId() == tariffPlanId).findFirst().map(IdTitle::toIdTitle).orElse(new IdTitle(this.param.getContractTariffId(), "??? [#" + tariffPlanId + "]")));
        }
        return tariffs;
    }

    protected boolean checkUserFilter(TariffPlan tariffPlan) {
        return switch (this.param.getFilterKey()) {
            case "noSelect" -> true;
            case "tariffGroup" -> this.tariffGroupIds.contains(tariffPlan.getId());
            case "tariffGroupDefault" -> this.tariffGroupDefaultIds.contains(tariffPlan.getId());
            default -> false;
        };
    }

    protected boolean checkContractLabel(List<Integer> tariffContractLabelIds) {
        if (tariffContractLabelIds == null || tariffContractLabelIds.isEmpty()) {
            return true;
        }
        if (this.contractLabelIds == null || this.contractLabelIds.isEmpty()) {
            return false;
        }
        for (int tariflId : tariffContractLabelIds) {
            if (!this.contractLabelIds.contains(tariflId)) continue;
            return true;
        }
        return false;
    }

    protected int getContractId() {
        return this.param.getContractId();
    }

    protected Contract getContract() {
        return this.contract;
    }

    protected List<Integer> getContractLabelIds() {
        return this.contractLabelIds;
    }

    protected int getTariffId() {
        return this.param.getContractTariffId();
    }

    protected String getFilterKey() {
        return this.param.getFilterKey();
    }

    protected ContractTariffMasterDataParam getParam() {
        return this.param;
    }

    protected int getUserId() {
        return this.userId;
    }
}

