/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.access;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.Set;
import ru.bitel.bgbilling.apps.inet.access.Access;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class OldConnectionsRemover
extends BGLogger
implements Runnable {
    private final Access access;

    public OldConnectionsRemover(Access access) {
        this.access = access;
    }

    @Override
    public void run() {
        Connection con = this.access.setup.getDBConnectionFromPool();
        try {
            this.runImpl(con);
            if (!con.getAutoCommit()) {
                con.commit();
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    public void runImpl(Connection con) throws BGException {
        this.getLogger().debug("Run OldConnectionsRemover...");
        try {
            Set<String> partitions = this.getPartitions(con);
            int count = partitions != null && partitions.size() > 0 ? this.partitionedDelete(con, partitions) : this.simpleDelete(con);
            this.getLogger().debug("Removed " + count + " old connections with status=0");
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private int simpleDelete(Connection con) throws SQLException {
        PreparedStatement ps = con.prepareStatement("DELETE FROM inet_connection_" + this.access.moduleId + " WHERE connectionStart<? AND status=0");
        GregorianCalendar calendar = new GregorianCalendar();
        TimeUtils.clear_MIN_MIL_SEC((Calendar)calendar);
        ((Calendar)calendar).add(11, -24);
        ps.setTimestamp(1, TimeUtils.convertCalendarToTimestamp((Calendar)calendar));
        int count = ps.executeUpdate();
        ps.close();
        return count;
    }

    private int partitionedDelete(Connection con, Set<String> partitions) throws SQLException {
        int count = 0;
        Random r = new Random();
        for (String partition : partitions) {
            if (r.nextInt(3) != 0) continue;
            PreparedStatement ps = con.prepareStatement("DELETE FROM inet_connection_" + this.access.moduleId + " PARTITION (" + partition + ") WHERE connectionStart<? AND status=0");
            GregorianCalendar calendar = new GregorianCalendar();
            TimeUtils.clear_MIN_MIL_SEC((Calendar)calendar);
            ((Calendar)calendar).add(11, -24);
            ps.setTimestamp(1, TimeUtils.convertCalendarToTimestamp((Calendar)calendar));
            count += ps.executeUpdate();
            ps.close();
            if (con.getAutoCommit()) continue;
            con.commit();
        }
        return count;
    }

    private Set<String> getPartitions(Connection con) {
        Set partitions = null;
        try {
            PreparedStatement ps = con.prepareStatement("EXPLAIN SELECT * FROM inet_connection_" + this.access.moduleId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                partitions = Utils.toSet((String)rs.getString("partitions"));
            }
            rs.close();
            ps.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return partitions;
    }
}

